'A reference to the Phidget21.NET.dll must be added to new projects in VB.Net
'From the "Project" menu select "Add Reference"
'From the "Add Reference" window select the ".NET" tab
'select "Phidget21.NET" and click "OK"

Public Class Form1

    Dim WithEvents advServo As Phidgets.AdvancedServo

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        advServo = New Phidgets.AdvancedServo
        advServo.open()
    End Sub

    Private Sub advServo_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles advServo.Attach
        positionTrk.SetRange(advServo.servos(0).PositionMin * 128, advServo.servos(0).PositionMax * 128)
        velocityTrk.SetRange(advServo.servos(0).VelocityMin, advServo.servos(0).VelocityMax)
        accelTrk.SetRange(advServo.servos(0).AccelerationMin, advServo.servos(0).AccelerationMax)
        maxPosnTrackBar.SetRange(advServo.servos(0).PositionMin, advServo.servos(0).PositionMax)
        minPosnTrackBar.SetRange(advServo.servos(0).PositionMin, advServo.servos(0).PositionMax)

        attachedTxt.Text = advServo.Attached.ToString()
        nameTxt.Text = advServo.Name
        serialTxt.Text = advServo.SerialNumber.ToString()
        versiontxt.Text = advServo.Version.ToString()
        numServosTxt.Text = advServo.servos.Count.ToString()

        For i As Integer = 0 To advServo.servos.Count - 1
            servoCmb.Items.Add(i)
        Next i

        'this will initialize all values
        servoCmb.SelectedIndex = 0
        servoCmb.Enabled = True

        velocityTrk.Enabled = True
        positionTrk.Enabled = True
        accelTrk.Enabled = True
        engagedCheckBox.Enabled = True
        speedRampingCheckBox.Enabled = True
        maxPosnTrackBar.Enabled = True
        minPosnTrackBar.Enabled = True
    End Sub

    Private Sub advServo_CurrentChange(ByVal sender As Object, ByVal e As Phidgets.Events.CurrentChangeEventArgs) Handles advServo.CurrentChange
        If e.Index = servoCmb.SelectedItem Then
            currentTxt.Text = e.Current.ToString()
        End If
    End Sub

    Private Sub advServo_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles advServo.Detach
        attachedTxt.Text = advServo.Attached.ToString()
        nameTxt.Clear()
        serialTxt.Clear()
        versiontxt.Clear()
        numServosTxt.Clear()

        velocityTrk.Enabled = False
        velocityTrk.Value = velocityTrk.Minimum
        positionTrk.Enabled = False
        positionTrk.Value = positionTrk.Minimum
        accelTrk.Enabled = False
        accelTrk.Value = accelTrk.Minimum
        engagedCheckBox.Enabled = False
        speedRampingCheckBox.Enabled = False
        maxPosnTrackBar.Enabled = False
        minPosnTrackBar.Enabled = False

        target_positionTxt.Clear()
        target_velocityTxt.Clear()

        minPosnTextBox.Clear()
        maxPosnTextBox.Clear()

        accelTxt.Clear()

        servoCmb = New ComboBox()
        servoCmb.Enabled = False
    End Sub

    Private Sub advServo_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles advServo.Error
        MessageBox.Show(e.exception.Message, "Error Event")
    End Sub

    Private Sub advServo_PositionChange(ByVal sender As Object, ByVal e As Phidgets.Events.PositionChangeEventArgs) Handles advServo.PositionChange
        If e.Index = servoCmb.SelectedItem Then
            actual_positionTxt.Text = e.Position.ToString()
            stoppedCheckBox.Checked = advServo.servos(e.Index).Stopped
        End If
    End Sub

    Private Sub advServo_VelocityChange(ByVal sender As Object, ByVal e As Phidgets.Events.VelocityChangeEventArgs) Handles advServo.VelocityChange
        If e.Index = servoCmb.SelectedItem Then
            actual_velocityTxt.Text = e.Velocity.ToString()
        End If
    End Sub

    Private Sub servoCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles servoCmb.SelectedIndexChanged
        Dim index As Integer = servoCmb.SelectedItem

        'Use a try-catch block around code where you are getting and displaying the servo data
        'if the current position state has yet to be set, it will throw a PhidgetException for value not set
        'you can use this to test this and to display that the value is unknown
        Try
            engagedCheckBox.Checked = advServo.servos(index).Engaged
            speedRampingCheckBox.Checked = advServo.servos(index).SpeedRamping

            maxPosnTrackBar.SetRange(advServo.servos(index).PositionMin, advServo.servos(index).PositionMax)
            maxPosnTrackBar.Value = advServo.servos(index).PositionMax
            maxPosnTextBox.Text = (advServo.servos(index).PositionMax).ToString()

            minPosnTrackBar.SetRange(advServo.servos(index).PositionMin, advServo.servos(index).PositionMax)
            minPosnTrackBar.Value = advServo.servos(index).PositionMin
            minPosnTextBox.Text = (advServo.servos(index).PositionMin).ToString()

            positionTrk.SetRange(advServo.servos(index).PositionMin * 128, advServo.servos(index).PositionMax * 128)

            If advServo.servos(index).Engaged Then
                positionTrk.Value = advServo.servos(index).Position
                actual_positionTxt.Text = advServo.servos(index).Position.ToString()
                target_positionTxt.Text = advServo.servos(index).Position.ToString()
            Else
                positionTrk.Value = minPosnTrackBar.Value
                actual_velocityTxt.Text = advServo.servos(index).Velocity.ToString()
                actual_positionTxt.Text = "Unknown"
                target_positionTxt.Text = positionTrk.Value.ToString()
            End If

            positionTrk.Maximum = advServo.servos(index).PositionMax * 128
            positionTrk.Minimum = advServo.servos(index).PositionMin * 128

            currentTxt.Text = advServo.servos(index).Current.ToString()
            actual_velocityTxt.Text = advServo.servos(index).Velocity.ToString()

            velocityTrk.Value = advServo.servos(index).VelocityLimit
            target_velocityTxt.Text = advServo.servos(index).VelocityLimit.ToString()

            accelTrk.Value = advServo.servos(index).Acceleration
            accelTxt.Text = advServo.servos(index).Acceleration.ToString()
            maxPosnTextBox.Text = (advServo.servos(index).PositionMax).ToString()
            minPosnTextBox.Text = (advServo.servos(index).PositionMin).ToString()

            stoppedCheckBox.Checked = advServo.servos(index).Stopped

        Catch ex As Phidgets.PhidgetException

            actual_positionTxt.Text = "Unknown"
            actual_velocityTxt.Text = "Unknown"
            currentTxt.Text = "Unknown"

            positionTrk.Maximum = advServo.servos(index).PositionMax * 128
            positionTrk.Minimum = advServo.servos(index).PositionMin * 128
            positionTrk.Value = advServo.servos(index).PositionMin
            velocityTrk.Value = advServo.servos(index).VelocityMin
            accelTrk.Value = advServo.servos(index).AccelerationMin

            target_positionTxt.Text = positionTrk.Value.ToString()
            target_velocityTxt.Text = velocityTrk.Value.ToString()
            accelTxt.Text = accelTrk.Value.ToString()
        End Try
    End Sub

    Private Sub accelTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles accelTrk.Scroll
        Try
            Dim accel As Double = accelTrk.Value
            If accel < advServo.servos(servoCmb.SelectedItem).AccelerationMin Then
                accel = advServo.servos(servoCmb.SelectedItem).AccelerationMin
            End If
            If accel > advServo.servos(servoCmb.SelectedItem).AccelerationMax Then
                accel = advServo.servos(servoCmb.SelectedItem).AccelerationMax
            End If
            advServo.servos(servoCmb.SelectedItem).Acceleration = accel
            accelTxt.Text = accelTrk.Value.ToString()
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.Description)
        End Try
    End Sub

    Private Sub positionTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles positionTrk.Scroll
        'A PhidgetException will be thrown if you try to set the position to any value NOT between -23 and 232
        Try
            advServo.servos(servoCmb.SelectedItem).Position = positionTrk.Value / 128.0
            target_positionTxt.Text = (positionTrk.Value / 128.0).ToString()
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.Description)
        End Try
    End Sub

    Private Sub velocityTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles velocityTrk.Scroll

        Try
            advServo.servos(servoCmb.SelectedItem).VelocityLimit = velocityTrk.Value
            target_velocityTxt.Text = velocityTrk.Value.ToString()
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.Description)
        End Try
    End Sub

    Private Sub engagedCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles engagedCheckBox.CheckedChanged
        advServo.servos(servoCmb.SelectedItem).Engaged = engagedCheckBox.Checked
    End Sub

    Private Sub speedRampingCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles speedRampingCheckBox.CheckedChanged
        advServo.servos(servoCmb.SelectedItem).SpeedRamping = speedRampingCheckBox.Checked
    End Sub

    Private Sub maxPosnTrackBar_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles maxPosnTrackBar.Scroll
        Try
            advServo.servos(servoCmb.SelectedItem).PositionMax = maxPosnTrackBar.Value
            maxPosnTextBox.Text = maxPosnTrackBar.Value.ToString()
            positionTrk.Maximum = maxPosnTrackBar.Value * 128
            minPosnTrackBar.Maximum = maxPosnTrackBar.Value
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.Description)
        End Try
    End Sub

    Private Sub minPosnTrackBar_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles minPosnTrackBar.Scroll
        Try
            advServo.servos(servoCmb.SelectedItem).PositionMin = minPosnTrackBar.Value
            minPosnTextBox.Text = minPosnTrackBar.Value.ToString()
            positionTrk.Minimum = minPosnTrackBar.Value * 128
            maxPosnTrackBar.Minimum = minPosnTrackBar.Value
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.Description)
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        RemoveHandler advServo.Attach, AddressOf advServo_Attach
        RemoveHandler advServo.CurrentChange, AddressOf advServo_CurrentChange
        RemoveHandler advServo.Detach, AddressOf advServo_Detach
        RemoveHandler advServo.Error, AddressOf advServo_Error
        RemoveHandler advServo.PositionChange, AddressOf advServo_PositionChange
        RemoveHandler advServo.VelocityChange, AddressOf advServo_VelocityChange
        Application.DoEvents()

        advServo.close()
        advServo = Nothing
    End Sub
End Class
