' - TextLCD full -
' This example creates a nice gui to display the connected TextLCD's details as well as provides fields and checkboxes to
' manipulate all of the available controls and methods for a TextLCD such as backligh, cursor, cursor blink, contrast,
' and a simulation of the custom characters ability of the TextLCD api.
' NOTE: You can only create and display a maximum of 8 custom characters at a time on the TextLCD.  The method to create
' a custom character is not simply straight bit setting.  There is a web tool located in the documentation section of the
' website that one can refer to in order to generate the int values to generate a custom character
'
' Please note that this example was designed to work with only one Phidget TextLCD connected. 
' For an example using multiple Phidget TextLCDs, please see a "multiple" example in the TextLCD Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1

    Dim WithEvents phidgetLCD As Phidgets.TextLCD

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'initialize our TextLCD Phidget and hook the event handlers
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        phidgetLCD = New Phidgets.TextLCD
        phidgetLCD.open()

        dispText1.Enabled = False
        dispText2.Enabled = False
        clearBtn.Enabled = False
        backlightChk.Enabled = False
        cursorChk.Enabled = False
        contrastTrkBr.Enabled = False

    End Sub
    'attach event handler...we will display the attach status and the attached TextLCD device's details
    'We will also enable the fields used to manipulate the TextLCD as well as do some initializing of
    'ranges and maximum values for some of these fields

    Private Sub lcd_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetLCD.Attach
        attachedText.Text = sender.Attached.ToString()
        nameText.Text = sender.Name
        serialText.Text = sender.SerialNumber.ToString()
        versionText.Text = sender.Version.ToString()
        dispText1.Enabled = True
        dispText1.MaxLength = phidgetLCD.rows(0).MaximumLength
        dispText2.Enabled = True
        dispText2.MaxLength = phidgetLCD.rows(1).MaximumLength
        clearBtn.Enabled = True
        backlightChk.Enabled = True
        cursorChk.Enabled = True
        contrastTrkBr.Enabled = True
        contrastTrkBr.SetRange(0, 255)
        contrastTrkBr.Value = 130

        phidgetLCD.Backlight = True
        backlightChk.Checked = phidgetLCD.Backlight
        phidgetLCD.Cursor = True
        cursorChk.Checked = phidgetLCD.Cursor
        phidgetLCD.CursorBlink = True
        cursorBlinkChk.Checked = phidgetLCD.CursorBlink
    End Sub

    'detach event handler.... we will display the device attach status and clear all the other fields
    Private Sub lcd_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetLCD.Detach
        attachedText.Text = sender.Attached.ToString()
        nameText.Text = ""
        serialText.Text = ""
        versionText.Text = ""
        dispText1.Enabled = False
        dispText2.Enabled = False
        clearBtn.Enabled = False
        backlightChk.Enabled = False
        cursorChk.Enabled = False
        contrastTrkBr.Enabled = False
    End Sub

    'Error event handler..we will simply display the error details text in a popup message box
    Private Sub lcd_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetLCD.Error
        MessageBox.Show(e.Description)
    End Sub

    'line 1 textChanged event handler...when the user is entering text, pass it on to the textLCD to be displayed
    Private Sub dispText1_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dispText1.TextChanged
        phidgetLCD.rows(0).DisplayString = sender.Text
    End Sub


    'line 2 textChanged event handler...when the user is entering text, pass it on to the textLCD to be displayed
    Private Sub dispText2_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dispText2.TextChanged
        phidgetLCD.rows(1).DisplayString = sender.Text
    End Sub

    'If the clear button is clicked, we want to clear the fields as well as clear the TextLCD screen
    Private Sub clearBtn_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles clearBtn.Click
        dispText1.Clear()
        dispText2.Clear()
        phidgetLCD.rows(0).DisplayString = ""
        phidgetLCD.rows(1).DisplayString = ""
    End Sub

    'Enable or disable the backlight by clicking on the checkbox
    Private Sub backlightChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles backlightChk.CheckedChanged
        phidgetLCD.Backlight = backlightChk.Checked
    End Sub

    'enable or disable the cursor by clicking on the checkbox
    Private Sub cursorChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cursorChk.CheckedChanged
        phidgetLCD.Cursor = cursorChk.Checked
    End Sub

    'enable or disable a blinking cursor by clicking on the checkbox
    Private Sub cursorBlinkChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cursorBlinkChk.CheckedChanged
        phidgetLCD.CursorBlink = cursorBlinkChk.Checked
    End Sub

    'display ou simulation of the custom characters when the checkbox is clicked
    Private Sub customChrChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles customChrChk.CheckedChanged
        If (sender.Checked) Then

            phidgetLCD.rows(0).DisplayString = "Testing Custom Chars"
            phidgetLCD.customCharacters(0).setCustomCharacter(949247, 536)
            phidgetLCD.customCharacters(1).setCustomCharacter(1015791, 17180)
            phidgetLCD.customCharacters(2).setCustomCharacter(1048039, 549790)
            phidgetLCD.customCharacters(3).setCustomCharacter(1031395, 816095)
            phidgetLCD.customCharacters(4).setCustomCharacter(498785, 949247)
            phidgetLCD.customCharacters(5).setCustomCharacter(232480, 1015791)
            phidgetLCD.customCharacters(6).setCustomCharacter(99328, 1048039)
            phidgetLCD.rows(1).DisplayString = phidgetLCD.customCharacters(0).StringCode & _
                phidgetLCD.customCharacters(1).StringCode & _
                phidgetLCD.customCharacters(2).StringCode & _
                phidgetLCD.customCharacters(3).StringCode & _
                phidgetLCD.customCharacters(4).StringCode & _
                phidgetLCD.customCharacters(5).StringCode & _
            phidgetLCD.customCharacters(6).StringCode()

        Else

            phidgetLCD.rows(0).DisplayString = ""
            phidgetLCD.rows(1).DisplayString = ""
        End If
    End Sub


    'adjust the contast of the screen on the textLCD based on the value selected on the slider (100 to 0)
    Private Sub contrastTrkBr_Scroll(ByVal sender As Object, ByVal e As System.EventArgs) Handles contrastTrkBr.Scroll
        phidgetLCD.Contrast = contrastTrkBr.Value
    End Sub

    'When the application is terminating, close the Phidget.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        RemoveHandler phidgetLCD.Attach, AddressOf lcd_Attach
        RemoveHandler phidgetLCD.Detach, AddressOf lcd_Detach
        RemoveHandler phidgetLCD.Error, AddressOf lcd_Error
        Application.DoEvents()

        phidgetLCD.close()
    End Sub

End Class
