' - RFID full -
' This example displays a gui that shows the attached Phidgets RFID reader device's details and will display and tag
' data that is scanned by the antenna.  it also provides checkboxes to manipulate the different attirbutes of the RFID reader as
' well as the digital outputs.
'
' Please note that this example was designed to work with only one Phidget RFID connected. 
' For an example using multiple Phidget RFIDs, please see a "multiple" example in the RFID Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    Dim WithEvents phidgetRFID As Phidgets.RFID

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub
    'initialize our Phidgets RFID reader and hook the event handlers 
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Disabled controls until Phidget is attached
        antennaChk.Enabled = False
        ledChk.Enabled = False
        output0Chk.Enabled = False
        output1chk.Enabled = False
        'To reduce code complexity we assume that there is one PhidgetPHSensor
        'attached to the PC before the program is run.
        phidgetRFID = New Phidgets.RFID

        phidgetRFID.open()


    End Sub



    'attach event handler..populate the details fields as well as display the attached status.  enable the checkboxes to change
    'the values of the attributes of the RFID reader such as enable or disable the antenna and onboard led.
    Private Sub phidgetRFID_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetRFID.Attach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = sender.Name
        serialTxt.Text = sender.SerialNumber.ToString()
        versionTxt.Text = sender.Version.ToString()
        outputsTxt.Text = sender.outputs.Count.ToString()

        antennaChk.Checked = True
        phidgetRFID.Antenna = True
        antennaChk.Enabled = True
        ledChk.Enabled = True
        output0Chk.Enabled = True
        output1chk.Enabled = True
    End Sub

    'detach event handler...clear all the fields, display the attached status, and disable the checkboxes.
    Private Sub phidgetRFID_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetRFID.Detach

        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""
        outputsTxt.Text = ""

        antennaChk.Enabled = False
        ledChk.Enabled = False
        output0Chk.Enabled = False
        output1chk.Enabled = False
    End Sub

    Private Sub phidgetRFID_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetRFID.Error
        MessageBox.Show(e.Description)
    End Sub

    'Tag event handler...we'll display the tag code in the field on the GUI
    Private Sub phidgetRFID_Tag(ByVal sender As Object, ByVal e As Phidgets.Events.TagEventArgs) Handles phidgetRFID.Tag
        tagTxt.Text = e.Tag
    End Sub

    'Tag lost event handler...here we simply want to clear our tag field in the GUI
    Private Sub phidgetRFID_TagLost(ByVal sender As Object, ByVal e As Phidgets.Events.TagEventArgs) Handles phidgetRFID.TagLost
        tagTxt.Text = ""
    End Sub

    'Enable or disable the RFID antenna by clicking the checkbox
    Private Sub antennaChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles antennaChk.CheckedChanged
        phidgetRFID.Antenna = antennaChk.Checked
    End Sub

    'turn on and off the onboard LED by clicking the checkox
    Private Sub ledChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ledChk.CheckedChanged
        phidgetRFID.LED = ledChk.Checked
    End Sub

    'turn on and off output 0, to light a LED for example
    Private Sub output0Chk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles output0Chk.CheckedChanged
        phidgetRFID.outputs(0) = output0Chk.Checked
    End Sub

    'turn on and off output 1, to light a LED for example
    Private Sub output1chk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles output1chk.CheckedChanged
        phidgetRFID.outputs(1) = output1chk.Checked
    End Sub

    'When the application is being terminated, close the Phidget.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        RemoveHandler phidgetRFID.Attach, AddressOf phidgetRFID_Attach
        RemoveHandler phidgetRFID.Detach, AddressOf phidgetRFID_Detach
        RemoveHandler phidgetRFID.Error, AddressOf phidgetRFID_Error
        RemoveHandler phidgetRFID.Tag, AddressOf phidgetRFID_Tag
        RemoveHandler phidgetRFID.TagLost, AddressOf phidgetRFID_TagLost
        Application.DoEvents()

        phidgetRFID.close()
    End Sub
End Class
