' - Manager full -
'This example creates a data grid view that will display the details of the different Phidgets
'devices that ar currently connected to the machine.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1

    Dim WithEvents phidgetMan As Phidgets.Manager

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'initialize our phidgets manager
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        phidgetMan = New Phidgets.Manager()

        dataGridView1.ColumnCount = 4
        dataGridView1.Columns(0).Name = "Device Name"
        dataGridView1.Columns(0).Width = 150
        dataGridView1.Columns(0).MinimumWidth = 150
        dataGridView1.Columns(0).AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill
        dataGridView1.Columns(1).Name = "Serial No."
        dataGridView1.Columns(1).Width = 80
        dataGridView1.Columns(1).MinimumWidth = 80
        dataGridView1.Columns(2).Name = "Version"
        dataGridView1.Columns(2).Width = 75
        dataGridView1.Columns(2).MinimumWidth = 75
        dataGridView1.Columns(3).Name = "Attached"
        dataGridView1.Columns(3).Width = 75
        dataGridView1.Columns(3).MinimumWidth = 75

        phidgetMan.open()

        label3.Text = Phidgets.Phidget.LibraryVersion 'Display the library version on the form.

    End Sub

    'attach event handling code....we will add a row for te newly attached device
    Private Sub phidgetMan_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetMan.Attach
        Dim newrow() As String = {e.Device.Name, e.Device.SerialNumber.ToString(), e.Device.Version.ToString(), e.Device.Attached.ToString()}
        dataGridView1.Rows.Add(newrow)
    End Sub


    'detach event handling code...we will remove the row in the data table that holds the information for the detached device
    Private Sub phidgetMan_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetMan.Detach
        Dim row As DataGridViewRow
        For Each row In dataGridView1.Rows
            If row.Cells(1).Value.Equals(e.Device.SerialNumber.ToString()) Then
                dataGridView1.Rows.Remove(row)
            End If
        Next
    End Sub

    'error event handling code...we will simply display the error message in a popup message box
    Private Sub phidgetMan_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetMan.Error
        MessageBox.Show(e.Description)
    End Sub

    'When the application is being terminated, close the Phidget.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        RemoveHandler phidgetMan.Attach, AddressOf phidgetMan_Attach
        RemoveHandler phidgetMan.Detach, AddressOf phidgetMan_Detach
        RemoveHandler phidgetMan.Error, AddressOf phidgetMan_Error
        Application.DoEvents()

        phidgetMan.close()
    End Sub



End Class
