'A reference to the PhidgetNET.dll must be added to new projects in VB.Net
'From the "Project" menu select "Add Reference"
'From the "Add Reference" window select the "Browse" tab
'Browse to the directory you installed the Phidgets library to
'The default is "C:\Program Files\Phidgets"
'Select "PhidgetsNET.dll" and click "OK"
'To view objects that have been added, select the "View" menu
'Select "Object Browser"
'Then expand the PhidgetsNET.dll item

Public Class Form1
    Dim WithEvents phidgetIFK As Phidgets.InterfaceKit
    Private input_checkboxes As CheckBox()
    Private sensor_textboxes As TextBox()

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'To reduce code complexity we assume that there is one PhidgetInterfacekit
        'attached to the PC before the program is run.
        phidgetIFK = New Phidgets.InterfaceKit
        phidgetIFK.open()

        'Defaults for text fields
        txtStatus.Text = "Not Connected"

    End Sub

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'If the form closes and the Phidget RFID is attached Close it.
        If phidgetIFK.Attached = True Then
            phidgetIFK.close()
        End If
    End Sub

    Private Sub ClickInputs(ByVal sender As Object, ByVal e As EventArgs)
        MessageBox.Show("You don't usually click an input " & DirectCast(sender, CheckBox).Tag.ToString)
    End Sub

    Private Sub ClickOutputs(ByVal sender As Object, ByVal e As EventArgs)
        'MessageBox.Show("Clicked was " & DirectCast(sender, CheckBox).CheckState.ToString)
        phidgetIFK.outputs(DirectCast(sender, CheckBox).Tag) = DirectCast(sender, CheckBox).CheckState
    End Sub

    Private Sub phidgetIFK_Attach1(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetIFK.Attach
        'When the Phidget Intefacekit attaches update the form text boxes
        txtStatus.Text = "Connected"
        txtNumOutputs.Text = Str(phidgetIFK.outputs.Count)
        txtNumInputs.Text = Str(phidgetIFK.inputs.Count)
        txtNumSensors.Text = Str(phidgetIFK.sensors.Count)
        txtSerialNumber.Text = Str(phidgetIFK.SerialNumber)
        txtVersion.Text = Str(phidgetIFK.Version)

        'These statements are used to control the input check boxes later
        ReDim input_checkboxes(phidgetIFK.inputs.Count - 1)
        ReDim sensor_textboxes(phidgetIFK.sensors.Count - 1)

        'Dynamically create checkboxes for outputs and add the Click event handler
        For i As Integer = 0 To phidgetIFK.outputs.Count - 1
            Dim chkOutput As New CheckBox
            chkOutput.Location = New Drawing.Point(20, 170 + i * 20)
            chkOutput.Width = 20
            chkOutput.TabIndex = i
            chkOutput.Text = i.ToString
            chkOutput.Tag = i.ToString
            AddHandler chkOutput.Click, AddressOf ClickOutputs
            Controls.Add(chkOutput)
        Next
        'Dynamically create checkboxes for inputs, add the click event handler and
        'assign the checkbox to input_checkboxes array
        For i As Integer = 0 To phidgetIFK.inputs.Count - 1
            Dim chkInput As New CheckBox
            chkInput.Location = New Drawing.Point(110, 170 + i * 20)
            chkInput.Width = 20
            chkInput.TabIndex = i
            chkInput.Tag = i.ToString
            chkInput.Name = i.ToString
            chkInput.Text = chkInput.Tag.ToString
            AddHandler chkInput.Click, AddressOf ClickInputs
            Controls.Add(chkInput)
            input_checkboxes(i) = chkInput
        Next
        'Dynamically add textboxes for sensor values and assign them to an array
        For i As Integer = 0 To phidgetIFK.sensors.Count - 1
            Dim txtSensorValue As New TextBox
            txtSensorValue.Location = New Drawing.Point(185, 170 + i * 20)
            txtSensorValue.Width = 30
            txtSensorValue.TabIndex = i
            txtSensorValue.Tag = i.ToString
            txtSensorValue.Name = i.ToString
            Controls.Add(txtSensorValue)
            sensor_textboxes(i) = txtSensorValue
        Next
    End Sub

    Private Sub phidgetIFK_Detach1(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetIFK.Detach
        txtStatus.Text = "Not Connected"
    End Sub

    Private Sub phidgetIFK_Error1(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetIFK.Error
        MessageBox.Show(e.Description)
        Me.Close()
    End Sub

    Private Sub phidgetIFK_InputChange1(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles phidgetIFK.InputChange
        input_checkboxes(e.Index).Checked = e.Value
    End Sub

    Private Sub phidgetIFK_SensorChange(ByVal sender As Object, ByVal e As Phidgets.Events.SensorChangeEventArgs) Handles phidgetIFK.SensorChange
        sensor_textboxes(e.Index).Text = e.Value
    End Sub
End Class


