' - InterfaceKit full -
' In this example we display the interface kit details including the number of inputs and outputs it allows,
' and displays the values of the inputs and outputs.
' Note: This example was developed and run with an LED in digital output 0 and an LED in digital output 7 to test
' the simulated digital output.
'
' Please note that this example was designed to work with only one Phidget InterfaceKit connected. 
' For an example using multiple Phidget InterfaceKits, please see a "multiple" example in the InterfaceKit Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    Dim WithEvents phidgetIFK As Phidgets.InterfaceKit

    Private digiInArray As CheckBox()
    Private digiOutArray As CheckBox()
    Private sensorInArray As TextBox()

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'initialize the device
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        makeDigiInArray()
        makeDigiOutArray()
        makeSensorInArray()

        inputTrk.Value = 0
        inputTrk.Enabled = False
        sensitivityTxt.Text = ""

        ratioChk.Enabled = False
        ratioChk.Checked = False

        'To reduce code complexity we assume that there is one PhidgetInterfacekit
        'attached to the PC before the program is run.
        Try
            phidgetIFK = New Phidgets.InterfaceKit
            phidgetIFK.open()
        Catch ex As Exception
            MessageBox.Show(ex.ToString())
        End Try


    End Sub

    'attach event handler... here we'll display the interface kit details as well as determine how many output and input
    'fields to display as well as determine the range of values for the output simulator slider
    Private Sub phidgetIFK_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetIFK.Attach

        attachedTxt.Text = phidgetIFK.Attached.ToString()
        nameTxt.Text = phidgetIFK.Name
        serialTxt.Text = sender.SerialNumber.ToString()
        versionTxt.Text = sender.Version.ToString()
        digiInNumTxt.Text = phidgetIFK.inputs.Count.ToString()
        digiOutNumTxt.Text = sender.outputs.Count.ToString()
        sensorInNumTxt.Text = sender.sensors.Count.ToString()

        Dim i As Integer
        For i = 0 To phidgetIFK.inputs.Count - 1
            digiInArray(i).Visible = True
        Next i

        For i = 0 To phidgetIFK.outputs.Count - 1
            digiOutArray(i).Visible = True
            digiOutArray(i).Enabled = True
        Next i

        For i = 0 To phidgetIFK.sensors.Count - 1
            sensorInArray(i).Visible = True
        Next i

        If phidgetIFK.sensors.Count > 0 Then
            inputTrk.Enabled = True
            inputTrk.SetRange(0, 1000)
            inputTrk.Value = phidgetIFK.sensors(0).Sensitivity
            sensitivityTxt.Text = inputTrk.Value.ToString()

            phidgetIFK.ratiometric = True

            ratioChk.Enabled = True
            ratioChk.Checked = phidgetIFK.ratiometric
        End If
    End Sub

    ''ifkit detach event handler... here we display the statu, which will be false as the device is not attached.  We
    ''will also clear the display fields and hide the inputs and outputs.
    Private Sub phidgetIFK_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetIFK.Detach

        attachedTxt.Text = phidgetIFK.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""
        digiInNumTxt.Text = ""
        digiOutNumTxt.Text = ""
        sensorInNumTxt.Text = ""

        Dim i As Integer

        For i = 0 To 15
            digiInArray(i).Visible = False
            digiInArray(i).Checked = False
        Next

        For i = 0 To 15
            digiOutArray(i).Visible = False
            digiOutArray(i).Checked = False
            digiOutArray(i).Enabled = False
        Next

        For i = 0 To 7
            sensorInArray(i).Visible = False
            sensorInArray(i).Text = ""
        Next

        inputTrk.Value = 0
        inputTrk.Enabled = False
        sensitivityTxt.Text = ""

        ratioChk.Enabled = False
        ratioChk.Checked = False
    End Sub

    Private Sub phidgetIFK_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetIFK.Error
        MessageBox.Show(e.Description)
    End Sub

    'digital input change event handler... here we check or uncheck the corresponding input checkbox based on the index of
    'the digital input that generated the event
    Private Sub phidgetIFK_InputChange(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles phidgetIFK.InputChange
        digiInArray(e.Index).Checked = e.Value
    End Sub

    ''digital output change event handler... here we check or uncheck the corresponding output checkbox based on the index of
    ''the output that generated the event
    Private Sub phidgetIFK_OutputChange(ByVal sender As Object, ByVal e As Phidgets.Events.OutputChangeEventArgs) Handles phidgetIFK.OutputChange
        digiOutArray(e.Index).Checked = e.Value
    End Sub

    ''sensor input change event handler...Set the textbox content based on the input index that is communicating with the
    ''interface kit
    Private Sub phidgetIFK_SensorChange(ByVal sender As Object, ByVal e As Phidgets.Events.SensorChangeEventArgs) Handles phidgetIFK.SensorChange
        sensorInArray(e.Index).Text = e.Value.ToString()
    End Sub

    'Modify the digital ouputs...Please observe the properties window in the ofrm designer for the digital output checkboxes.
    'Each of the output checkboxes CheckedChanged events point to this one event handler, I use the sender object (the checkbox
    'triggering the event) to get the checkbox that is changing.  Also note that there is a "tag" property that is basically
    'user defined data associated with the control.  I used this to store the output index that the checkbox is supposed to
    'represent for use in the following code to easily index the output we wanted to change.  Hopefully this clarifies what
    'was done in this method.
    Private Sub ClickOutputs(ByVal sender As Object, ByVal e As System.EventArgs)

        Dim outputIndex As Integer
        Dim outputState As Boolean
        outputIndex = DirectCast(sender, CheckBox).Tag
        outputState = DirectCast(sender, CheckBox).CheckState
        'MessageBox.Show(outputIndex.ToString() + " and " + outputState.ToString())

        phidgetIFK.outputs(outputIndex) = outputState

    End Sub

    'Modify the sensitivity of the analog inputs. In other words, the amount that the inputs must change between 
    'sensorchange events.

    Private Sub inputTrk_Scroll(ByVal sender As Object, ByVal e As System.EventArgs) Handles inputTrk.Scroll
        Try
            Dim i As Integer
            For i = 0 To phidgetIFK.sensors.Count - 1
                phidgetIFK.sensors(i).Sensitivity = inputTrk.Value
            Next
            sensitivityTxt.Text = inputTrk.Value.ToString()
        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString())
        End Try
    End Sub

    Private Sub ratioChk_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ratioChk.CheckedChanged
        If phidgetIFK.Attached Then
            phidgetIFK.ratiometric = ratioChk.Checked
        End If
    End Sub

    'When the application is terminating, close the Phidget.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing

        RemoveHandler phidgetIFK.Attach, AddressOf phidgetIFK_Attach
        RemoveHandler phidgetIFK.Detach, AddressOf phidgetIFK_Detach
        RemoveHandler phidgetIFK.Error, AddressOf phidgetIFK_Error
        RemoveHandler phidgetIFK.InputChange, AddressOf phidgetIFK_InputChange
        RemoveHandler phidgetIFK.OutputChange, AddressOf phidgetIFK_OutputChange
        RemoveHandler phidgetIFK.SensorChange, AddressOf phidgetIFK_SensorChange
        Application.DoEvents()

        phidgetIFK.close()
    End Sub

    'this method creates the digital input array that corresponds to the group of checkboxes
    'we are suing to represent the state of the digital inputs on the interface kit
    Sub makeDigiInArray()
        ReDim digiInArray(15)

        digiInArray(0) = checkBox0
        digiInArray(1) = checkBox1
        digiInArray(2) = checkBox2
        digiInArray(3) = checkBox3
        digiInArray(4) = checkBox4
        digiInArray(5) = checkBox5
        digiInArray(6) = checkBox6
        digiInArray(7) = checkBox7
        digiInArray(8) = checkBox8
        digiInArray(9) = checkBox9
        digiInArray(10) = checkBox10
        digiInArray(11) = checkBox11
        digiInArray(12) = checkBox12
        digiInArray(13) = checkBox13
        digiInArray(14) = checkBox14
        digiInArray(15) = checkBox15

        Dim i As Integer
        For i = 0 To 15
            digiInArray(i).Visible = False
        Next i

    End Sub

    'this method creates the digital output array that corresponds to the group of checkboxes
    'we are using to represent the state of the digital outputs on the interface kit
    Sub makeDigiOutArray()
        ReDim digiOutArray(15)

        digiOutArray(0) = checkBox16
        digiOutArray(1) = checkBox17
        digiOutArray(2) = checkBox18
        digiOutArray(3) = checkBox19
        digiOutArray(4) = checkBox20
        digiOutArray(5) = checkBox21
        digiOutArray(6) = checkBox22
        digiOutArray(7) = checkBox23
        digiOutArray(8) = checkBox24
        digiOutArray(9) = checkBox25
        digiOutArray(10) = checkBox26
        digiOutArray(11) = checkBox27
        digiOutArray(12) = checkBox28
        digiOutArray(13) = checkBox29
        digiOutArray(14) = checkBox30
        digiOutArray(15) = checkBox31

        Dim i As Integer
        For i = 0 To 15
            digiOutArray(i).Visible = False
            AddHandler digiOutArray(i).Click, AddressOf ClickOutputs
        Next i

    End Sub

    'this method creates the analog input array (mst likelely connected to analog sensors) that corresponds to the group
    'of textboxes which will be holding the current values of the analog inputs that are being sent to the interface kit
    Sub makeSensorInArray()
        ReDim sensorInArray(7)

        sensorInArray(0) = textBox1
        sensorInArray(1) = textBox2
        sensorInArray(2) = textBox3
        sensorInArray(3) = textBox4
        sensorInArray(4) = textBox5
        sensorInArray(5) = textBox6
        sensorInArray(6) = textBox7
        sensorInArray(7) = textBox8

        Dim i As Integer
        For i = 0 To 7
            sensorInArray(i).Visible = False
        Next i

    End Sub
End Class
