' - TemperatureSensor full -
' This example displays the connected Phidget TemperatureSensor device's details as well as the current sensor readings
' being generated by the thermocouple.  This example also demonstrates the ability to modify the sensor's sensitivity
' by setting it to a new double value in the provided textbox.
' 
' Please note that this example was designed to work with only one Phidget TemperatureSensor connected. For an example using multiple 
' Phidget TemperatureSensors, please see a "multiple" example in the TemperatureSensor Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    Dim WithEvents phidgetTemperature As Phidgets.TemperatureSensor

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub



    'Initialize our temperatureSensor object and hook the event handlers
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        SensitivityTrk.SetRange(0, 200)
        SensitivityTrk.Enabled = False

        phidgetTemperature = New Phidgets.TemperatureSensor
        phidgetTemperature.open()

    End Sub

    'TemperatureSensor Attach event handler...We'll populate the fields in the GUI and enable the modify sensitivity textbox
    Private Sub temperatureSensor_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetTemperature.Attach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = sender.Name
        serialTxt.Text = sender.SerialNumber.ToString()
        versionTxt.Text = sender.Version.ToString()
        numThermoTxt.Text = sender.thermocouples.Count.ToString()

        SensitivityTrk.Enabled = True
        SensitivityTrk.Value = phidgetTemperature.thermocouples(0).Sensitivity * 100.0
        sensitivityTxt.Text = phidgetTemperature.thermocouples(0).Sensitivity.ToString()
        'Set the ranges
        thermoRange.Text = "(" + phidgetTemperature.thermocouples(0).TemperatureMin.ToString() + "C to " + _
                            phidgetTemperature.thermocouples(0).TemperatureMax.ToString() + "C)"
        ambientRange.Text = "(" + phidgetTemperature.ambientSensor.TemperatureMin.ToString() + "C to " + _
                            phidgetTemperature.ambientSensor.TemperatureMax.ToString() + "C)"
        Try
            potentialRange.Text = "(" + phidgetTemperature.thermocouples(0).PotentialMin.ToString() + "mV to " + _
                            phidgetTemperature.thermocouples(0).PotentialMax.ToString() + "mV)"
        Catch ex As Phidgets.PhidgetException
            'really old temperature sensors do not support this
            If ex.Type = Phidgets.PhidgetException.ErrorType.PHIDGET_ERR_UNSUPPORTED Then
                potentialRange.Text = "(Not Supported)"
            End If

        End Try

            thermoTypeComboBox.Enabled = True
            Select Case phidgetTemperature.thermocouples(0).Type
                Case Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_K_TYPE
                    thermoTypeComboBox.SelectedItem = "K-Type"
                Case Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_J_TYPE
                    thermoTypeComboBox.SelectedItem = "J-Type"
                Case Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_E_TYPE
                    thermoTypeComboBox.SelectedItem = "E-Type"
                Case Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_T_TYPE
                    thermoTypeComboBox.SelectedItem = "T-Type"
            End Select


    End Sub

    'TemperatureSensor Detach event handler....Clear the fields and disable the modify sensitivity textbox so that
    'new sensity value can't be sent while there is no device attached, otherwise this would generate a PhidgetException
    Private Sub temperatureSensor_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetTemperature.Detach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""
        numThermoTxt.Text = ""
        thermoTempTxt.Text = ""
        onboardTempTxt.Text = ""
        SensitivityTrk.Enabled = False
        SensitivityTrk.Value = 0
        sensitivityTxt.Clear()

    End Sub

    'Error event handler..We'll simply display the error description in a popup messagebox window
    Private Sub temperatureSensor_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetTemperature.Error
        MessageBox.Show(e.Description)
    End Sub

    'Temperature Change event handler...We'll display the current temperature reading from the sensor to the
    'specified textbox as they come in
    Private Sub temperatureSensor_TemperatureChange(ByVal sender As Object, ByVal e As Phidgets.Events.TemperatureChangeEventArgs) Handles phidgetTemperature.TemperatureChange
        If e.Index = 0 Then
            onboardTempTxt.Text = phidgetTemperature.ambientSensor.Temperature.ToString()
            thermoTempTxt.Text = e.Temperature.ToString()
            thermoPotTxt.Text = e.Potential.ToString()
        End If
    End Sub

    'When a new double valu is entered into the textbox, we will update the sensitivity value in the sensor
    'If no temperature sensor is attached when we try to update the sensitivity value, it will throw a PhidgetException,
    'so we will catch it and deal with it accordingly
    'Also, the sensitivity is a double value, so we should prevent and other values to be sent.  Since I am using the
    'Double.parse method, it will throw a FormatException if anything other than a double value is entered, so
    'we'll catch that and deal with it accordingly


    'When the application is terminating, close the Phidget.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing

        RemoveHandler phidgetTemperature.Attach, AddressOf temperatureSensor_Attach
        RemoveHandler phidgetTemperature.Detach, AddressOf temperatureSensor_Detach
        RemoveHandler phidgetTemperature.Error, AddressOf temperatureSensor_Error
        RemoveHandler phidgetTemperature.TemperatureChange, AddressOf temperatureSensor_TemperatureChange
        Application.DoEvents()

        phidgetTemperature.close()
    End Sub

    Private Sub SensitivityTrk_Scroll(ByVal sender As Object, ByVal e As System.EventArgs) Handles SensitivityTrk.Scroll

        Try
            phidgetTemperature.thermocouples(0).Sensitivity = SensitivityTrk.Value / 100.0
            sensitivityTxt.Text = (SensitivityTrk.Value / 100.0).ToString()
        Catch ex As Exception
            sensitivityTxt.Clear()
        End Try

    End Sub
    Private Sub thermoTypeComboBox_SelectedIndexChanged1(ByVal sender As Object, ByVal e As System.EventArgs) Handles thermoTypeComboBox.SelectedIndexChanged

        Try
            Select Case thermoTypeComboBox.SelectedItem.ToString()
                Case "K-Type"
                    phidgetTemperature.thermocouples(0).Type = Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_K_TYPE

                Case "J-Type"
                    phidgetTemperature.thermocouples(0).Type = Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_J_TYPE
                Case "E-Type"
                    phidgetTemperature.thermocouples(0).Type = Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_E_TYPE
                Case "T-Type"
                    phidgetTemperature.thermocouples(0).Type = Phidgets.TemperatureSensorSensor.ThermocoupleType.PHIDGET_TEMPERATURE_SENSOR_T_TYPE
            End Select
            thermoRange.Text = "(" + phidgetTemperature.thermocouples(0).TemperatureMin.ToString() + "C to " + _
                phidgetTemperature.thermocouples(0).TemperatureMax.ToString() + "C)"

        Catch ex As Phidgets.PhidgetException
            If ex.Type = Phidgets.PhidgetException.ErrorType.PHIDGET_ERR_UNSUPPORTED Then
                thermoTypeComboBox.Enabled = False
            End If
        End Try
    End Sub
End Class
