' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    Dim WithEvents phidgetMotor As Phidgets.MotorControl
    Private inputArray As CheckBox()

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'To reduce code complexity we assume that there is one PhidgetServo
        'attached to the PC before the program is run.
        phidgetMotor = New Phidgets.MotorControl

        Dim i As Integer
        ReDim inputArray(3)
        inputArray(0) = input0Chk
        inputArray(1) = input1Chk
        inputArray(2) = input2Chk
        inputArray(3) = input3Chk

        For i = 0 To phidgetMotor.inputs.Count - 1
            inputArray(i).Visible = False
            inputArray(i).Enabled = False
        Next

        phidgetMotor.open()

    End Sub

    Private Sub phidgetMotor_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetMotor.Attach
        Dim i As Integer
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = sender.Name.ToString()

        serialTxt.Text = sender.SerialNumber.ToString()
        versiontxt.Text = sender.Version.ToString()

        numMotorsTxt.Text = phidgetMotor.motors.Count.ToString()
        numInputsTxt.Text = phidgetMotor.inputs.Count.ToString()

        For i = 0 To 3
            inputArray(i).Visible = True
            inputArray(i).Enabled = True
        Next

        For i = 0 To sender.motors.Count - 1
            motorCmb.Items.Add(i)
            phidgetMotor.motors(i).Acceleration = 50
            phidgetMotor.motors(i).Velocity = 0
        Next
        motorCmb.Enabled = True
        motorCmb.SelectedIndex = 0

    End Sub

    Private Sub phidgetMotor_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetMotor.Detach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Clear()
        serialTxt.Clear()
        versiontxt.Clear()
        numMotorsTxt.Clear()
        numInputsTxt.Clear()
        Dim i As Integer
        For i = 0 To phidgetMotor.inputs.Count - 1
            inputArray(i).Visible = True
            inputArray(i).Enabled = False
        Next
        motorCmb.Items.Clear()
        motorCmb.SelectedItem = 0
        motorCmb.Enabled = False
    End Sub

    Private Sub phidgetMotor_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetMotor.Error
        MessageBox.Show(e.Description)
    End Sub

    Private Sub phidgetMotor_CurrentChange(ByVal sender As Object, ByVal e As Phidgets.Events.CurrentChangeEventArgs) Handles phidgetMotor.CurrentChange
        If e.Index = Int(motorCmb.SelectedItem) Then
            currentTxt.Text = e.Current.ToString()
        End If
    End Sub

    Private Sub phidgetMotor_InputChange(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles phidgetMotor.InputChange
        inputArray(e.Index).Checked = e.Value
    End Sub

    Private Sub phidgetMotor_VelocityChange(ByVal sender As Object, ByVal e As Phidgets.Events.VelocityChangeEventArgs) Handles phidgetMotor.VelocityChange
        If e.Index = Int(motorCmb.SelectedItem) Then
            velocityActualTxt.Text = e.Velocity.ToString()
        End If
    End Sub

    Private Sub accelTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles accelTrk.Scroll
        phidgetMotor.motors(motorCmb.SelectedItem).Acceleration = accelTrk.Value
        AccelerationTxt.Text = accelTrk.Value.ToString()
    End Sub

    Private Sub motorCmb_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles motorCmb.SelectedIndexChanged
        'the maximum bound of the PhidgetMotorControl is 100%, it's minimum bound is -100%
        velocityTrk.SetRange(-100, 100)
        velocityTrk.TickFrequency = 20
        accelTrk.SetRange(phidgetMotor.motors(motorCmb.SelectedItem).AccelerationMin + 1, phidgetMotor.motors(motorCmb.SelectedItem).AccelerationMax)
        accelTrk.TickFrequency = 10
        accelTrk.Value = 10

        velocityMaximumTxt.Text = phidgetMotor.motors(motorCmb.SelectedItem).Velocity.ToString()
        AccelerationTxt.Text = phidgetMotor.motors(motorCmb.SelectedItem).Acceleration.ToString()
        velocityTrk.Value = Int(phidgetMotor.motors(motorCmb.SelectedItem).Velocity)
        accelTrk.Value = Int(phidgetMotor.motors(motorCmb.SelectedItem).Acceleration)
    End Sub

    Private Sub velocityTrk_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles velocityTrk.Scroll
        phidgetMotor.motors(motorCmb.SelectedItem).Velocity = velocityTrk.Value
        velocityMaximumTxt.Text = velocityTrk.Value

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Dim i As Integer
        If phidgetMotor.Attached = True Then
            For i = 0 To phidgetMotor.motors.Count - 1
                phidgetMotor.motors(i).Velocity = 0
            Next
        End If

        RemoveHandler phidgetMotor.VelocityChange, AddressOf phidgetMotor_VelocityChange
        RemoveHandler phidgetMotor.InputChange, AddressOf phidgetMotor_InputChange
        RemoveHandler phidgetMotor.Error, AddressOf phidgetMotor_Error
        RemoveHandler phidgetMotor.CurrentChange, AddressOf phidgetMotor_CurrentChange
        RemoveHandler phidgetMotor.Attach, AddressOf phidgetMotor_Attach
        RemoveHandler phidgetMotor.Detach, AddressOf phidgetMotor_Detach
        Application.DoEvents()

        phidgetMotor.close()
    End Sub

 
End Class

