' - Encoder full -
' This example simply displays the Encoder info if it is attached and displays the acceleration data for each axis as it is 
' changing in pretty much raw form.  It also allows for modifying the sensitivity of each axis that is availabl on the attached
' Encoder.
'
' Please note that this example was designed to work with only one Phidget Encoder connected. For an example using multiple 
' Phidget Encoders, please see a "multiple" example in the Encoder Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    Dim WithEvents phidgetEncoder As Phidgets.Encoder

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'initalize the phidget device and call open
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'To reduce code complexity we assume that there is one PhidgetEncoder
        'attached to the PC before the program is run.
        phidgetEncoder = New Phidgets.Encoder
        phidgetEncoder.open()
        'Defaults for text fields
        attachedTxt.Text = "Not Connected"
        inputChk.Visible = False
        inputChk.Enabled = False
    End Sub

    'Encoder attach event handler
    Private Sub phidgetEncoder_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetEncoder.Attach
        'When the Phidget Encoder attaches update the form text boxes
        serialTxt.Text = (Str(phidgetEncoder.SerialNumber))

        attachedTxt.Text = phidgetEncoder.Attached.ToString()
        nameTxt.Text = phidgetEncoder.Name.ToString()
        serialTxt.Text = phidgetEncoder.SerialNumber.ToString()
        versionTxt.Text = phidgetEncoder.Version.ToString()
        numEncodersTxt.Text = phidgetEncoder.encoders.Count.ToString()
        numInputsTxt.Text = phidgetEncoder.inputs.Count.ToString()
        If phidgetEncoder.inputs.Count <> 0 Then
            inputChk.Visible = True
            inputChk.Enabled = True
        End If


    End Sub

    'Encoder detach event handler
    Private Sub phidgetEncoder_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetEncoder.Detach
        attachedTxt.Text = phidgetEncoder.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""
        numEncodersTxt.Text = ""
        numInputsTxt.Text = ""
        positionTxt.Text = ""
        encoderPositionTxt.Text = ""
        timeTxt.Text = ""

        inputChk.Checked = False

    End Sub

    'Encoder error event handler
    Private Sub phidgetEncoder_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetEncoder.Error
        MessageBox.Show(e.Description)
    End Sub

    'Input Change event handler....on the current Phidget Encoders, this means the pushbutton in the knob.
    'Event arguements contain the input index (on current Phidget Encoders will only be 1) and the value, a bool
    'to represent clicked or unlcicked state
    Private Sub phidgetEncoder_InputChange(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles phidgetEncoder.InputChange
        inputChk.Checked = e.Value
    End Sub


    'Encoder Position Change event handler...the event arguements will provide the encoder index, value, and 
    'the elapsed time since the last event.  These value, including the current position value stored in the
    'corresponding element in the encoder objects encoder collection could be used to calculate velocity...
    Private Sub phidgetEncoder_PositionChange(ByVal sender As Object, ByVal e As Phidgets.Events.EncoderPositionChangeEventArgs) Handles phidgetEncoder.PositionChange
        positionTxt.Text = e.PositionChange.ToString()
        timeTxt.Text = e.Time.ToString()
        encoderPositionTxt.Text = phidgetEncoder.encoders(e.Index).ToString()
    End Sub

    'When the application is being terminated, close the Phidget
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'If the form closes and the PhidgetEncoder is attached Close it.
        If phidgetEncoder.Attached = True Then
            RemoveHandler phidgetEncoder.Attach, AddressOf phidgetEncoder_Attach
            RemoveHandler phidgetEncoder.Detach, AddressOf phidgetEncoder_Detach
            RemoveHandler phidgetEncoder.Error, AddressOf phidgetEncoder_Error
            RemoveHandler phidgetEncoder.InputChange, AddressOf phidgetEncoder_InputChange
            RemoveHandler phidgetEncoder.PositionChange, AddressOf phidgetEncoder_PositionChange
            Application.DoEvents()

            phidgetEncoder.close()
        End If
    End Sub

End Class