'A reference to the Phidget21.NET.dll must be added to new projects in VB.Net 
'From the "Project" menu select "Add Reference" 
'From the "Add Reference" window select the "Browse" tab 
'Browse to the directory you installed the Phidgets library to 
'The default is "C:\Program Files\Phidgets" 
'Select "Phidget21.NET.dll" and click "OK" 
'To view objects that have been added, select the "View" menu 
'Select "Object Browser" 
'Then expand the Phidget21.NET.dll item 

Public Class Form1
    Dim WithEvents phidgetEncoder As Phidgets.Encoder


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'To reduce code complexity we assume that there is one PhidgetEncoder
        'attached to the PC before the program is run.
        phidgetEncoder = New Phidgets.Encoder()
        phidgetEncoder.open()
        'Defaults for text fields
        txtStatus.Text = "Not Connected"
    End Sub

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    Private Sub phidgetEncoder_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetEncoder.Attach
        'When the Phidget RFID attaches update the form text boxes
        Label1.Text = "PhidgetEncoder has Attached"
        txtStatus.Text = "Connected"
        txtSerialNumber.Text = (Str(phidgetEncoder.SerialNumber))

    End Sub
    Private Sub phidgetEncoder_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetEncoder.Detach
        'If the Phidget RFID detaches close the form
        Me.Close()

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'If the form closes and the PhidgetEncoder is attached Close it.
        If phidgetEncoder.Attached = True Then
            phidgetEncoder.close()
        End If
    End Sub

    Private Sub phidgetEncoder_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetEncoder.Error
        MessageBox.Show(e.Description)
        Me.Close()
    End Sub

    Private Sub phidgetEncoder_InputChange(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles phidgetEncoder.InputChange
        txtInputState.Text = e.Value
    End Sub


    Private Sub phidgetEncoder_PositionChange(ByVal sender As Object, ByVal e As Phidgets.Events.EncoderPositionChangeEventArgs) Handles phidgetEncoder.PositionChange
        txtEncoderPosition.Text = phidgetEncoder.encoders(e.Index)
        TrackBar1.Value = phidgetEncoder.encoders(e.Index)
    End Sub
End Class



