' - Accelerometer full -
' This example simply displays the accelerometer info if it is attached and displays the acceleration data for each axis as it is 
' changing in pretty much raw form.  It also allows for modifying the sensitivity of each axis that is availabl on the attached
' accelerometer.
'
' Please note that this example was designed to work with only one Phidget Accelerometer connected. For an example using multiple 
' Phidget Accelerometers, please see a "multiple" example in the Accelerometer Examples folder.
'
' Copyright 2007 Phidgets Inc.  
' This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
' To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

Public Class Form1
    Dim WithEvents phidgetAccel As Phidgets.Accelerometer

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    'initalize the phidget device and call open
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'To reduce code complexity we assume that there is one PhidgetAccelerometer
        'attached to the PC before the program is run.
        phidgetAccel = New Phidgets.Accelerometer
        phidgetAccel.open()
        'Defaults for text fields
        attachedTxt.Text = "Not Connected"
    End Sub

    'accelerometer attach event handler
    Private Sub phidgetAccel_Attach(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles phidgetAccel.Attach
        'When the Phidget RFID attaches update the form text boxes
        serialTxt.Text = (Str(phidgetAccel.SerialNumber))

        attachedTxt.Text = phidgetAccel.Attached.ToString()
        nameTxt.Text = phidgetAccel.Name.ToString()
        serialTxt.Text = phidgetAccel.SerialNumber.ToString()
        versionTxt.Text = phidgetAccel.Version.ToString()
        axesTxt.Text = phidgetAccel.axes.Count.ToString()
        sensitivity1Txt.Enabled = True
        sensitivity2Txt.Enabled = True

        'depending what kind of accelerometer you have (2-axis vs. 3-axis) enable or disable 
        'the axis-3 sensitivity settings text box
        If (phidgetAccel.axes.Count > 2) Then
            sensitivity3Txt.Enabled = True
        Else
            sensitivity3Txt.Enabled = False
        End If

    End Sub

    'accelerometer detach event handler
    Private Sub phidgetAccel_Detach(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles phidgetAccel.Detach
        attachedTxt.Text = sender.Attached.ToString()
        nameTxt.Text = ""
        serialTxt.Text = ""
        versionTxt.Text = ""
        axesTxt.Text = ""
        sensitivity1Txt.Text = ""
        sensitivity1Txt.Enabled = False
        sensitivity2Txt.Text = ""
        sensitivity2Txt.Enabled = False
        sensitivity3Txt.Text = ""
        sensitivity3Txt.Enabled = False
        acceleration1Txt.Text = ""
        acceleration2Txt.Text = ""
        acceleration3Txt.Text = ""

    End Sub

    'accelerometer error event handler
    Private Sub phidgetAccel_Error(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles phidgetAccel.Error
        MessageBox.Show(e.Description)
    End Sub

    'acceleration change event handler
    Private Sub phidgetAccel_AccelerationChange(ByVal sender As Object, ByVal e As Phidgets.Events.AccelerationChangeEventArgs) Handles phidgetAccel.AccelerationChange
        Try
            Select Case (e.Index)
                Case 0
                    acceleration1Txt.Text = phidgetAccel.axes(e.Index).Acceleration.ToString()
                Case 1
                    acceleration2Txt.Text = phidgetAccel.axes(e.Index).Acceleration.ToString()
                Case 2
                    acceleration3Txt.Text = phidgetAccel.axes(e.Index).Acceleration.ToString()
                Case Else
                    MessageBox.Show("Unexpected index provided")
            End Select
        Catch ex As Exception
            'MessageBox.Show(ex.ToString())
        End Try
    End Sub

    'fire an event to modify the sensity on axis one based on what was entered into the 
    'corresponding text box
    Private Sub sensitivity1Txt_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles sensitivity1Txt.TextChanged
        Try
            phidgetAccel.axes(0).Sensitivity = Double.Parse(sensitivity1Txt.Text)
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.ToString())
        Catch ex As FormatException
            'since I am parsing the string daa from the text boxes to doubles, the data that is entered there needs to be a double
            'if you empty the box it will through an exception, so default it to 0
            phidgetAccel.axes(0).Sensitivity = 0
            sensitivity1Txt.Text = "0"
        End Try
    End Sub

    'fire an event to modify the sensity on axis one based on what was entered into the 
    'corresponding text box
    Private Sub sensitivity2Txt_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles sensitivity2Txt.TextChanged
        Try
            phidgetAccel.axes(1).Sensitivity = Double.Parse(sensitivity2Txt.Text)
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.ToString())
        Catch ex As FormatException
            'since I am parsing the string daa from the text boxes to doubles, the data that is entered there needs to be a double
            'if you empty the box it will through an exception, so default it to 0
            phidgetAccel.axes(1).Sensitivity = 0
            sensitivity2Txt.Text = "0"
        End Try
    End Sub

    'fire an event to modify the sensity on axis one based on what was entered into the 
    'corresponding text box
    Private Sub sensitivity3Txt_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles sensitivity3Txt.TextChanged
        Try
            phidgetAccel.axes(2).Sensitivity = Double.Parse(sensitivity3Txt.Text)
        Catch ex As Phidgets.PhidgetException
            MessageBox.Show(ex.ToString())
        Catch ex As FormatException
            'since I am parsing the string daa from the text boxes to doubles, the data that is entered there needs to be a double
            'if you empty the box it will through an exception, so default it to 0
            phidgetAccel.axes(2).Sensitivity = 0
            sensitivity3Txt.Text = "0"
        End Try
    End Sub

    'When the application is being terminated, close the Phidget
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'If the form closes and the PhidgetAccelerometer is attached Close it.
        If phidgetAccel.Attached = True Then
            RemoveHandler phidgetAccel.Attach, AddressOf phidgetAccel_Attach
            RemoveHandler phidgetAccel.Detach, AddressOf phidgetAccel_Detach
            RemoveHandler phidgetAccel.Error, AddressOf phidgetAccel_Error
            RemoveHandler phidgetAccel.AccelerationChange, AddressOf phidgetAccel_AccelerationChange

            Application.DoEvents()

            phidgetAccel.close()
        End If
    End Sub

End Class