VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6900
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4920
   LinkTopic       =   "Form1"
   ScaleHeight     =   6900
   ScaleWidth      =   4920
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Display"
      Height          =   3975
      Left            =   175
      TabIndex        =   10
      Top             =   2760
      Width           =   4455
      Begin VB.TextBox textRow 
         BackColor       =   &H8000000F&
         Enabled         =   0   'False
         Height          =   285
         Index           =   3
         Left            =   360
         TabIndex        =   26
         Top             =   2280
         Width           =   3615
      End
      Begin VB.TextBox textRow 
         BackColor       =   &H8000000F&
         Enabled         =   0   'False
         Height          =   285
         Index           =   2
         Left            =   360
         TabIndex        =   25
         Top             =   1920
         Width           =   3615
      End
      Begin VB.TextBox textRow 
         BackColor       =   &H8000000F&
         Enabled         =   0   'False
         Height          =   285
         Index           =   1
         Left            =   360
         TabIndex        =   24
         Top             =   1560
         Width           =   3615
      End
      Begin MSComctlLib.Slider brightnessSlider 
         Height          =   375
         Left            =   1560
         TabIndex        =   23
         Top             =   3480
         Width           =   2655
         _ExtentX        =   4683
         _ExtentY        =   661
         _Version        =   393216
         Enabled         =   0   'False
         Max             =   255
      End
      Begin MSComctlLib.Slider contrastSlider 
         Height          =   375
         Left            =   1560
         TabIndex        =   21
         Top             =   3050
         Width           =   2655
         _ExtentX        =   4683
         _ExtentY        =   661
         _Version        =   393216
         Enabled         =   0   'False
         Max             =   255
      End
      Begin VB.CheckBox cursorBlinkCheckBox 
         Alignment       =   1  'Right Justify
         Caption         =   "Cursor Blink"
         Enabled         =   0   'False
         Height          =   285
         Left            =   2760
         TabIndex        =   19
         Top             =   2640
         Width           =   1215
      End
      Begin VB.CheckBox cursorCheckBox 
         Alignment       =   1  'Right Justify
         Caption         =   "Cursor"
         Enabled         =   0   'False
         Height          =   285
         Left            =   1680
         TabIndex        =   18
         Top             =   2640
         Width           =   855
      End
      Begin VB.CheckBox backlightCheckBox 
         Alignment       =   1  'Right Justify
         Caption         =   "Backlight"
         Enabled         =   0   'False
         Height          =   285
         Left            =   360
         TabIndex        =   17
         Top             =   2640
         Width           =   975
      End
      Begin VB.TextBox textRow 
         BackColor       =   &H8000000F&
         Enabled         =   0   'False
         Height          =   285
         Index           =   0
         Left            =   360
         TabIndex        =   16
         Top             =   1165
         Width           =   3615
      End
      Begin VB.CommandButton initializeCmd 
         Caption         =   "Initialize"
         Enabled         =   0   'False
         Height          =   315
         Left            =   3120
         TabIndex        =   15
         Top             =   720
         Width           =   855
      End
      Begin VB.ComboBox screenIndex 
         Enabled         =   0   'False
         Height          =   315
         Left            =   1560
         TabIndex        =   14
         Top             =   317
         Width           =   1455
      End
      Begin VB.ComboBox screenSize 
         Enabled         =   0   'False
         Height          =   315
         Left            =   1560
         TabIndex        =   12
         Top             =   720
         Width           =   1455
      End
      Begin VB.Label Label8 
         Caption         =   "Brightness:"
         Enabled         =   0   'False
         Height          =   285
         Left            =   360
         TabIndex        =   22
         Top             =   3543
         Width           =   855
      End
      Begin VB.Label Label7 
         Caption         =   "Contrast:"
         Enabled         =   0   'False
         Height          =   285
         Left            =   360
         TabIndex        =   20
         Top             =   3100
         Width           =   735
      End
      Begin VB.Label Label6 
         Caption         =   "Choose Screen:"
         Enabled         =   0   'False
         Height          =   255
         Left            =   360
         TabIndex        =   13
         Top             =   360
         Width           =   1335
      End
      Begin VB.Label Label3 
         Caption         =   "Screen Size:"
         Enabled         =   0   'False
         Height          =   285
         Left            =   360
         TabIndex        =   11
         Top             =   720
         Width           =   1215
      End
   End
   Begin VB.Frame Details 
      Caption         =   "Text LCD Details"
      Height          =   2535
      Left            =   175
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      Begin VB.TextBox versionF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   4
         Top             =   2030
         Width           =   2500
      End
      Begin VB.TextBox serialF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   3
         Top             =   1645
         Width           =   2500
      End
      Begin VB.TextBox nameF 
         BackColor       =   &H8000000F&
         Height          =   800
         Left            =   1560
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   2
         Top             =   745
         Width           =   2500
      End
      Begin VB.TextBox attachF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   1
         Top             =   360
         Width           =   2500
      End
      Begin VB.Label Label5 
         Caption         =   "Version:"
         Height          =   285
         Left            =   360
         TabIndex        =   9
         Top             =   2030
         Width           =   735
      End
      Begin VB.Label Label4 
         Caption         =   "Serial No:"
         Height          =   285
         Left            =   360
         TabIndex        =   8
         Top             =   1645
         Width           =   735
      End
      Begin VB.Label TextLCDDetailsFrame 
         Caption         =   "Name:"
         Height          =   285
         Left            =   360
         TabIndex        =   7
         Top             =   745
         Width           =   731
      End
      Begin VB.Label Label2 
         Caption         =   "Label2"
         Height          =   15
         Left            =   480
         TabIndex        =   6
         Top             =   720
         Width           =   2895
      End
      Begin VB.Label Label1 
         Caption         =   "Attached:"
         Height          =   285
         Left            =   360
         TabIndex        =   5
         Top             =   360
         Width           =   855
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     TextLCD-full

' Description:
' -This example:
'    o displays information about the PhidgetTextLCD
'    o depending on the device capability, the user can change the screen, screen size, backlight, cursor, cursor blink, contrast and brightness.

Option Explicit
Dim WithEvents PhidgetTextLCD As PhidgetTextLCD
Attribute PhidgetTextLCD.VB_VarHelpID = -1
Dim TextRowCopy(3, 1) As String

Private Sub Form_Load()
    Set PhidgetTextLCD = Controls.Add("Phidget21COM.PhidgetTextLCD", "phidgetTextLCD")
    PhidgetTextLCD.Open
    attachF.Text = PhidgetTextLCD.IsAttached
 
End Sub

Private Sub PhidgetTextLCD_OnAttach()
    
    DisplayDetails
    
    InitializeForm
    
    setRowEnables
End Sub

'Display the properties of the device
Private Sub DisplayDetails()
    attachF.Text = PhidgetTextLCD.IsAttached
    nameF.Text = PhidgetTextLCD.DeviceName
    serialF.Text = PhidgetTextLCD.SerialNumber
    versionF.Text = PhidgetTextLCD.DeviceVersion
End Sub

Private Sub InitializeForm()
    Dim i As Long
    Label7.Enabled = True
    backlightCheckBox.Enabled = True
    cursorCheckBox.Enabled = True
    cursorBlinkCheckBox.Enabled = True
    contrastSlider.Enabled = True
    
    PhidgetTextLCD.Contrast = 120
    contrastSlider.Value = PhidgetTextLCD.Contrast
    
    PhidgetTextLCD.Backlight = True
    backlightCheckBox.Value = 1
    
    PhidgetTextLCD.CursorOn = True
    cursorCheckBox.Value = 1
    
    If (PhidgetTextLCD.Backlight) Then
         backlightCheckBox.Value = 1
    Else
        backlightCheckBox.Value = 0
    End If
    
    For i = 0 To PhidgetTextLCD.ScreenCount - 1
        If (i >= screenIndex.ListCount) Then
            screenIndex.AddItem (i)
        End If
    Next i
    screenIndex = 0
    
   screenSize.AddItem ("1x8")
   screenSize.AddItem ("2x8")
   screenSize.AddItem ("1x16")
   screenSize.AddItem ("2x16")
   screenSize.AddItem ("4x16")
   screenSize.AddItem ("2x20")
   screenSize.AddItem ("4x20")
   screenSize.AddItem ("2x24")
   screenSize.AddItem ("1x40")
   screenSize.AddItem ("2x40")
   screenSize.AddItem ("4x40")
   screenSize = PhidgetTextLCD.screenSize
    
   Select Case PhidgetTextLCD.DeviceName
    
        Case "Phidget TextLCD":
            ScreenSizeToText
            If (PhidgetTextLCD.DeviceVersion >= 200) Then
                brightnessSlider.Enabled = True
                Label8.Enabled = True
            End If
        Case "Phidget TextLCD Adapter"
            Label6.Enabled = True
            screenIndex.Enabled = True
            Label3.Enabled = True
            screenSize.Enabled = True
            initializeCmd.Enabled = True
            initializeCmd.Visible = True
            Label8.Enabled = True
            brightnessSlider.Enabled = True
            brightnessSlider.Visible = True
            ScreenSizeToText
    End Select
    
End Sub

Private Sub initializeCmd_Click()
    PhidgetTextLCD.Initialize
    
    'reseting the text
    ResetText
    
End Sub

Private Sub PhidgetTextLCD_OnDetach()
    Label6.Enabled = False
    Label3.Enabled = False
    Label7.Enabled = False
    Label8.Enabled = False
    screenIndex.Enabled = False
    screenSize.Enabled = False
    textRow(0).Enabled = False
    textRow(1).Enabled = False
    textRow(2).Enabled = False
    textRow(3).Enabled = False
    textRow(0).BackColor = &H8000000F
    textRow(1).BackColor = &H8000000F
    textRow(2).BackColor = &H8000000F
    textRow(3).BackColor = &H8000000F
    ResetText
    backlightCheckBox.Enabled = False
    cursorCheckBox.Enabled = False
    cursorBlinkCheckBox.Enabled = False
    contrastSlider.Enabled = False
    brightnessSlider.Enabled = False
    initializeCmd.Enabled = False
    
  
End Sub

Private Sub screenIndex_Click()
    Dim i As Long
    
    'storing a copy of the old text
    For i = 0 To 3
        TextRowCopy(i, PhidgetTextLCD.Screen) = textRow(i).Text
    Next i
    
    
    PhidgetTextLCD.Screen = screenIndex
    
    'displaying the original text for the new selected screen
    For i = 0 To 3
        textRow(i).Text = TextRowCopy(i, screenIndex)
    Next i
      
    'displaying the backlight value for the new selected screen
    If (PhidgetTextLCD.Backlight) Then
         backlightCheckBox.Value = 1
    Else
        backlightCheckBox.Value = 0
    End If
    
     'displaying the cursor value for the new selected screen
    If (PhidgetTextLCD.CursorOn) Then
         cursorCheckBox.Value = 1
    Else
        cursorCheckBox.Value = 0
    End If
    
    'displaying the cursor blink value for the new selected screen
    If (PhidgetTextLCD.CursorBlink) Then
         cursorBlinkCheckBox.Value = 1
    Else
        cursorBlinkCheckBox.Value = 0
    End If
    ScreenSizeToText
End Sub

Private Sub screenSize_Click()
    setRowEnables
End Sub

Private Sub textRow_Change(Index As Integer)
    On Error GoTo errorChangeText
    
  
    PhidgetTextLCD.DisplayString(Index) = textRow(Index).Text
     
    Exit Sub
errorChangeText:
    Resume Next
End Sub

Private Sub backlightCheckBox_Click()
    If (backlightCheckBox.Value = 1) Then
        PhidgetTextLCD.Backlight = True
    Else
        PhidgetTextLCD.Backlight = False
    End If
End Sub

Private Sub brightnessSlider_Scroll()
    PhidgetTextLCD.Brightness = brightnessSlider.Value
End Sub

Private Sub contrastSlider_Scroll()
    PhidgetTextLCD.Contrast = contrastSlider.Value
End Sub

Private Sub cursorBlinkCheckBox_Click()
    If (cursorBlinkCheckBox.Value = 1) Then
        PhidgetTextLCD.CursorBlink = True
    Else
        PhidgetTextLCD.CursorBlink = False
    End If
End Sub

Private Sub cursorCheckBox_Click()
    If (cursorCheckBox.Value = 1) Then
        PhidgetTextLCD.CursorOn = True
    Else
        PhidgetTextLCD.CursorOn = False
    End If
End Sub


Private Sub setRowEnables()

    On Error GoTo errorScreenSize
    Select Case screenSize
        Case "1x8":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_1x8
            textRow(0).Enabled = True
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "2x8":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_2x8
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "1x16":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_1x16
            textRow(0).Enabled = True
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "2x16":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_2x16
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "4x16":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_4x16
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = True
            textRow(3).Enabled = True
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H80000005
            textRow(3).BackColor = &H80000005
        Case "2x20":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_2x20
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "4x20":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_4x20
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = True
            textRow(3).Enabled = True
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H80000005
            textRow(3).BackColor = &H80000005
        Case "2x24":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_2x24
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "1x40":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_1x40
            textRow(0).Enabled = True
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "2x40":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_2x40
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case "4x40":
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_4x40
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = True
            textRow(3).Enabled = True
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H80000005
            textRow(3).BackColor = &H80000005
        Case Default:
            PhidgetTextLCD.screenSize = PHIDGETCOM_TEXTLCD_SCREEN_UNKNOWN
            textRow(0).Enabled = False
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H8000000F
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        
        End Select
        Exit Sub
errorScreenSize:
    'older PhidgetTextLCDs do not support screen size
    'MsgBox "Your device does not support screen size"
    

End Sub


Private Sub ScreenSizeToText()
    
    'clear all textRow
    Dim i As Long
    
    Select Case PhidgetTextLCD.screenSize
        Case PHIDGETCOM_TEXTLCD_SCREEN_1x8:
            screenSize.Text = "1x8"
            textRow(0).Enabled = True
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_2x8:
            screenSize.Text = "2x8"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_1x16:
            screenSize.Text = "1x16"
            textRow(0).Enabled = True
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_2x16:
            screenSize.Text = "2x16"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_4x16:
            screenSize.Text = "4x16"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = True
            textRow(3).Enabled = True
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H80000005
            textRow(3).BackColor = &H80000005
        Case PHIDGETCOM_TEXTLCD_SCREEN_2x20:
            screenSize.Text = "2x20"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_4x20:
            screenSize.Text = "4x20"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = True
            textRow(3).Enabled = True
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H80000005
            textRow(3).BackColor = &H80000005
        Case PHIDGETCOM_TEXTLCD_SCREEN_2x24:
            screenSize.Text = "2x24"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_1x40:
            screenSize.Text = "1x40"
            textRow(0).Enabled = True
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_2x40:
            screenSize.Text = "2x40"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        Case PHIDGETCOM_TEXTLCD_SCREEN_4x40:
            screenSize.Text = "4x40"
            textRow(0).Enabled = True
            textRow(1).Enabled = True
            textRow(2).Enabled = True
            textRow(3).Enabled = True
            textRow(0).BackColor = &H80000005
            textRow(1).BackColor = &H80000005
            textRow(2).BackColor = &H80000005
            textRow(3).BackColor = &H80000005
        Case Default:
            screenSize.Text = "Unknown"
            textRow(0).Enabled = False
            textRow(1).Enabled = False
            textRow(2).Enabled = False
            textRow(3).Enabled = False
            textRow(0).BackColor = &H8000000F
            textRow(1).BackColor = &H8000000F
            textRow(2).BackColor = &H8000000F
            textRow(3).BackColor = &H8000000F
        End Select
End Sub

Private Sub ResetText()
    Dim i, j As Long
    For i = 0 To 3
        For j = 0 To PhidgetTextLCD.ScreenCount - 1
            TextRowCopy(i, j) = ""
        Next j
        textRow(i) = ""
    Next i
End Sub
