VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "Simple RFID Example"
   ClientHeight    =   3495
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   3750
   LinkTopic       =   "Form1"
   ScaleHeight     =   3495
   ScaleWidth      =   3750
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox RFCtl 
      Caption         =   "Enable Reader"
      Enabled         =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   9
      Top             =   1920
      Width           =   2055
   End
   Begin VB.CheckBox LEDCtl 
      Caption         =   "Onboard LED"
      Enabled         =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   1680
      Width           =   2055
   End
   Begin VB.TextBox Text1 
      BeginProperty Font 
         Name            =   "Courier"
         Size            =   15
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Left            =   120
      TabIndex        =   7
      Top             =   480
      Width           =   3495
   End
   Begin VB.CheckBox DigitalOutput 
      Caption         =   "DigitalOutput 1 - LED"
      Enabled         =   0   'False
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   4
      Top             =   1440
      Width           =   2415
   End
   Begin VB.CheckBox DigitalOutput 
      Caption         =   "DigitalOutput 0 - +5V Output"
      Enabled         =   0   'False
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   3
      Top             =   1200
      Width           =   2295
   End
   Begin MSComctlLib.ListView ListView1 
      Height          =   30
      Left            =   9600
      TabIndex        =   0
      Top             =   1200
      Width           =   30
      _ExtentX        =   53
      _ExtentY        =   53
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.Label Label1 
      Caption         =   "Library Information"
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   2280
      Width           =   1455
   End
   Begin VB.Label lblLibraryVersion 
      Height          =   855
      Left            =   120
      TabIndex        =   5
      Top             =   2520
      Width           =   3495
   End
   Begin VB.Label lblHelp 
      Caption         =   "Place RFID tags over the reader"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   960
      Width           =   3735
   End
   Begin VB.Label lblReaderStatus 
      Caption         =   "Attach an RFID Tag Reader"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   3135
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'A Simple RFID Demonstration
'Keep adding tag ID's as fast as we can see them to the top of the listbox
'Notice that there can be many multiple reads on a single tag
Option Explicit
Dim WithEvents RF As PhidgetRFID
Attribute RF.VB_VarHelpID = -1
Dim L As ListItem

Private Sub Form_Load()
    Set RF = Controls.Add("Phidget21COM.PhidgetRFID", "RF")
    RF.Open
End Sub

Private Sub LEDCtl_Click()
    If LEDCtl.Value = 0 Then
        RF.LEDOn = False
    Else
        RF.LEDOn = True
    End If
End Sub

'When the reader appears, set things up and say so
Private Sub RF_OnAttach()
    Dim I As Integer
    lblLibraryVersion.Caption = RF.LibraryVersion
    lblReaderStatus.Caption = "PhidgetRFID" & " Version " & RF.DeviceVersion & ", Serial# " & RF.SerialNumber
    lblHelp.Caption = "Place RFID Tags over the reader"
    
    For I = 0 To RF.OutputCount - 1
        DigitalOutput(I).Value = 0
        DigitalOutput(I).Enabled = True
        RF.OutputState(I) = False
    Next I
    
    RF.LEDOn = True
    RF.AntennaOn = True
    RFCtl.Value = 1             'Display check mark on screen
    LEDCtl.Value = 1            'Display check mark on screen
    RFCtl.Enabled = True
    LEDCtl.Enabled = True
    
    'Example for writing a new tag:
    'RF.Write "Hi there..", PHIDGETCOM_RFID_PROTOCOL_PHIDGETS, False

End Sub

'When the reader disappears, say so
Private Sub RF_OnDetach()
    Dim I As Integer
    lblReaderStatus.Caption = "Attach an RFID tag reader"
    lblHelp.Caption = ""
    For I = 0 To RF.OutputCount - 1
        DigitalOutput(I).Enabled = True
    Next I
    RFCtl.Enabled = False
    LEDCtl.Enabled = False
End Sub


Private Sub RF_OnTag(ByVal TagNumber As String)
    Text1 = TagNumber
End Sub

Private Sub DigitalOutput_Click(Index As Integer)
    If DigitalOutput(Index).Value = 0 Then
        RF.OutputState(Index) = False
    Else
        RF.OutputState(Index) = True
    End If
End Sub

Private Sub RF_OnTagLost(ByVal TagNumber As String)
    Text1 = ""
End Sub

Private Sub RFCtl_Click()
    If RFCtl.Value = 0 Then
        RF.AntennaOn = False
    Else
        RF.AntennaOn = True
    End If
End Sub
