VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   11400
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4770
   LinkTopic       =   "Form1"
   ScaleHeight     =   11400
   ScaleWidth      =   4770
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame sensorDataFrame 
      Caption         =   "Sensor Data"
      Height          =   735
      Left            =   175
      TabIndex        =   21
      Top             =   10560
      Visible         =   0   'False
      Width           =   4455
      Begin VB.CheckBox ratiometricCheckBox 
         Caption         =   "Ratiometric"
         Height          =   255
         Left            =   3240
         TabIndex        =   28
         Top             =   360
         Width           =   1095
      End
      Begin VB.TextBox sensorValueF 
         BackColor       =   &H8000000F&
         Height          =   285
         Index           =   0
         Left            =   600
         Locked          =   -1  'True
         TabIndex        =   27
         Top             =   320
         Width           =   855
      End
      Begin VB.Label sensorValueL 
         Caption         =   "0"
         Height          =   255
         Index           =   0
         Left            =   360
         TabIndex        =   26
         Top             =   360
         Width           =   255
      End
   End
   Begin VB.Frame encoderDataFrame 
      Caption         =   "Encoder Data"
      Height          =   855
      Left            =   175
      TabIndex        =   20
      Top             =   9600
      Visible         =   0   'False
      Width           =   4455
      Begin VB.CommandButton resetCmd 
         Caption         =   "Reset"
         Height          =   375
         Left            =   3240
         TabIndex        =   25
         Top             =   240
         Width           =   855
      End
      Begin VB.TextBox encoderPositionF 
         BackColor       =   &H8000000F&
         Height          =   285
         Index           =   0
         Left            =   1080
         Locked          =   -1  'True
         TabIndex        =   24
         Top             =   360
         Width           =   855
      End
      Begin VB.Label encoderPositionL 
         Caption         =   "Position:"
         Height          =   375
         Index           =   0
         Left            =   360
         TabIndex        =   23
         Top             =   360
         Width           =   735
      End
   End
   Begin VB.Frame digitalInputDataFrame 
      Caption         =   "Digital Input Data"
      Height          =   855
      Left            =   175
      TabIndex        =   19
      Top             =   8640
      Visible         =   0   'False
      Width           =   4455
      Begin VB.CheckBox digitalInput 
         Alignment       =   1  'Right Justify
         Caption         =   "0"
         Height          =   360
         Index           =   0
         Left            =   240
         TabIndex        =   22
         Top             =   360
         Width           =   495
      End
   End
   Begin VB.Frame motorDataFrame 
      Caption         =   "Motor Data"
      Height          =   5055
      Left            =   175
      TabIndex        =   18
      Top             =   3480
      Visible         =   0   'False
      Width           =   4455
      Begin MSComctlLib.Slider brakingSlider 
         Height          =   495
         Left            =   1560
         TabIndex        =   48
         Top             =   4500
         Width           =   2505
         _ExtentX        =   4419
         _ExtentY        =   873
         _Version        =   393216
         Max             =   100
         TickStyle       =   3
      End
      Begin MSComctlLib.Slider accelerationSlider 
         Height          =   495
         Left            =   1560
         TabIndex        =   47
         Top             =   4021
         Width           =   2505
         _ExtentX        =   4419
         _ExtentY        =   873
         _Version        =   393216
         TickStyle       =   3
      End
      Begin MSComctlLib.Slider velocitySlider 
         Height          =   375
         Left            =   1560
         TabIndex        =   46
         Top             =   3538
         Width           =   2505
         _ExtentX        =   4419
         _ExtentY        =   661
         _Version        =   393216
         Min             =   -100
         Max             =   100
         TickStyle       =   3
      End
      Begin VB.TextBox voltageF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   45
         Top             =   3120
         Width           =   2500
      End
      Begin VB.TextBox backEMFF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   2880
         Locked          =   -1  'True
         TabIndex        =   44
         Top             =   2280
         Width           =   1165
      End
      Begin VB.TextBox currentF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   43
         Top             =   2760
         Width           =   2500
      End
      Begin VB.TextBox brakingF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   42
         Top             =   1875
         Width           =   2500
      End
      Begin VB.TextBox accelerationF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   41
         Top             =   1500
         Width           =   2500
      End
      Begin VB.TextBox currentVelocityF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   40
         Top             =   1110
         Width           =   2500
      End
      Begin VB.TextBox targetVelocityF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   39
         Top             =   735
         Width           =   2500
      End
      Begin VB.CheckBox backEMFCheckBox 
         Alignment       =   1  'Right Justify
         Caption         =   "Back EMF Sensing:"
         Height          =   585
         Left            =   360
         TabIndex        =   36
         Top             =   2160
         Width           =   1405
      End
      Begin VB.ComboBox motorIndex 
         BackColor       =   &H80000009&
         Enabled         =   0   'False
         Height          =   315
         Left            =   1560
         TabIndex        =   30
         Top             =   300
         Width           =   975
      End
      Begin VB.Label Label20 
         Caption         =   "Braking:"
         Height          =   375
         Left            =   360
         TabIndex        =   51
         Top             =   4560
         Width           =   1455
      End
      Begin VB.Label Label19 
         Caption         =   "Acceleration:"
         Height          =   495
         Left            =   360
         TabIndex        =   50
         Top             =   4080
         Width           =   1335
      End
      Begin VB.Label Label18 
         Caption         =   "Target Velocity:"
         Height          =   495
         Left            =   360
         TabIndex        =   49
         Top             =   3600
         Width           =   1455
      End
      Begin VB.Label Label17 
         Caption         =   "Supply Voltage:"
         Height          =   375
         Left            =   360
         TabIndex        =   38
         Top             =   3120
         Width           =   1215
      End
      Begin VB.Label Label16 
         Caption         =   "Back EMF:"
         Height          =   255
         Left            =   1920
         TabIndex        =   37
         Top             =   2280
         Width           =   1095
      End
      Begin VB.Label Label15 
         Caption         =   "Current:"
         Height          =   255
         Left            =   360
         TabIndex        =   35
         Top             =   2760
         Width           =   855
      End
      Begin VB.Label Label14 
         Caption         =   "Braking:"
         Height          =   375
         Left            =   360
         TabIndex        =   34
         Top             =   1875
         Width           =   1095
      End
      Begin VB.Label Label13 
         Caption         =   "Acceleration:"
         Height          =   375
         Left            =   360
         TabIndex        =   33
         Top             =   1500
         Width           =   1095
      End
      Begin VB.Label Label12 
         Caption         =   "Current Velocity:"
         Height          =   285
         Left            =   360
         TabIndex        =   32
         Top             =   1110
         Width           =   1215
      End
      Begin VB.Label Label11 
         Caption         =   "Target Velocity:"
         Height          =   285
         Left            =   360
         TabIndex        =   31
         Top             =   735
         Width           =   1215
      End
      Begin VB.Label Label10 
         Caption         =   "Choose Motor:"
         Height          =   375
         Left            =   360
         TabIndex        =   29
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.Frame Details 
      Caption         =   "Motor Control Details"
      Height          =   3255
      Left            =   175
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      Begin VB.TextBox numSensorsF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   3240
         Locked          =   -1  'True
         TabIndex        =   17
         Top             =   2800
         Width           =   825
      End
      Begin VB.TextBox numEncodersF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   16
         Top             =   2800
         Width           =   825
      End
      Begin VB.TextBox numInputsF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   3240
         Locked          =   -1  'True
         TabIndex        =   15
         Top             =   2415
         Width           =   825
      End
      Begin VB.TextBox numMotorsF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   14
         Top             =   2415
         Width           =   825
      End
      Begin VB.TextBox attachF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   4
         Top             =   360
         Width           =   2500
      End
      Begin VB.TextBox nameF 
         BackColor       =   &H8000000F&
         Height          =   800
         Left            =   1560
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   3
         Top             =   745
         Width           =   2500
      End
      Begin VB.TextBox serialF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   2
         Top             =   1645
         Width           =   2500
      End
      Begin VB.TextBox versionF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   1
         Top             =   2030
         Width           =   2500
      End
      Begin VB.Label Label9 
         Caption         =   "# Sensor:"
         Height          =   375
         Left            =   2520
         TabIndex        =   13
         Top             =   2805
         Width           =   735
      End
      Begin VB.Label Label8 
         Caption         =   "# Encoder:"
         Height          =   375
         Left            =   360
         TabIndex        =   12
         Top             =   2800
         Width           =   1215
      End
      Begin VB.Label Label7 
         Caption         =   "# Inputs:"
         Height          =   255
         Left            =   2520
         TabIndex        =   11
         Top             =   2415
         Width           =   735
      End
      Begin VB.Label Label6 
         Caption         =   "# Motors:"
         Height          =   255
         Left            =   360
         TabIndex        =   10
         Top             =   2415
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Attached:"
         Height          =   285
         Left            =   360
         TabIndex        =   9
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "Label2"
         Height          =   15
         Left            =   480
         TabIndex        =   8
         Top             =   720
         Width           =   2895
      End
      Begin VB.Label motorControlDetailsFrame 
         Caption         =   "Name:"
         Height          =   285
         Left            =   360
         TabIndex        =   7
         Top             =   745
         Width           =   731
      End
      Begin VB.Label Label4 
         Caption         =   "Serial No:"
         Height          =   285
         Left            =   360
         TabIndex        =   6
         Top             =   1645
         Width           =   735
      End
      Begin VB.Label Label5 
         Caption         =   "Version:"
         Height          =   285
         Left            =   360
         TabIndex        =   5
         Top             =   2030
         Width           =   735
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     MotorControl-full

' Description:
' -This example:
'    o displays information about the PhidgetMotorControl
'    o depending on the device capability, the user can manipulate velocity, acceleration, braking, back EMF sensing state


Option Explicit
Dim WithEvents PhidgetMotorControl As PhidgetMotorControl
Attribute PhidgetMotorControl.VB_VarHelpID = -1

Private Sub Form_Load()
    Form1.Height = 3990
    Set PhidgetMotorControl = Controls.Add("Phidget21COM.PhidgetMotorControl", "phidgetMotorControl")
    PhidgetMotorControl.Open
    attachF.Text = PhidgetMotorControl.IsAttached
 
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim i As Long
    If (PhidgetMotorControl.IsAttached) Then
        For i = 0 To PhidgetMotorControl.MotorCount - 1
            PhidgetMotorControl.Velocity(i) = 0
        Next i
    End If
End Sub

Private Sub PhidgetMotorControl_OnAttach()
    
    
    brakingSlider.Enabled = True
    
    DisplayDetails
    
    InitializeForm
    
    If (PhidgetMotorControl.MotorCount > 0) Then
        motorDataFrame.Visible = True
        DisplayMotorData
    End If
    
    If (PhidgetMotorControl.InputCount > 0) Then
        digitalInputDataFrame.Visible = True
        DisplayDigitalInputData
    End If
    
    If (PhidgetMotorControl.EncoderCount > 0) Then
        encoderDataFrame.Visible = True
        DisplayEncoderData
    End If
    
    If (PhidgetMotorControl.SensorCount > 0) Then
        sensorDataFrame.Visible = True
        DisplaySensorData
    End If
   
End Sub

Private Sub PhidgetMotorControl_OnBackEMFUpdate(ByVal Index As Long, ByVal Voltage As Double)
    backEMFF.Text = Voltage
End Sub

Private Sub PhidgetMotorControl_OnCurrentChange(ByVal Index As Long, ByVal Current As Double)
    currentF.Text = Current
End Sub

Private Sub PhidgetMotorControl_OnDetach()
    Dim i As Long
    attachF.Text = "False"
    nameF.Text = ""
    serialF.Text = ""
    versionF.Text = ""
    numMotorsF.Text = ""
    numInputsF.Text = ""
    numEncodersF.Text = ""
    numSensorsF.Text = ""
    motorIndex.Clear
    motorIndex.Enabled = False
    targetVelocityF.Text = ""
    currentVelocityF.Text = ""
    accelerationF.Text = ""
    brakingF.Text = ""
    backEMFCheckBox.Enabled = False
    backEMFF.Text = ""
    currentF.Text = ""
    voltageF.Text = ""
    velocitySlider.Enabled = False
    accelerationSlider.Enabled = False
    brakingSlider.Enabled = False
    For i = 0 To digitalInput.Count - 1
        digitalInput(i).Visible = False
        digitalInput(i).Enabled = False
    Next i
    resetCmd.Enabled = False
    ratiometricCheckBox.Enabled = False
    
    motorDataFrame.Visible = "False"
    digitalInputDataFrame.Visible = "False"
    encoderDataFrame.Visible = "False"
    sensorDataFrame.Visible = "False"
    Form1.Height = 3990
End Sub

'Display the properties of the device
Private Sub DisplayDetails()
    attachF.Text = PhidgetMotorControl.IsAttached
    nameF.Text = PhidgetMotorControl.DeviceName
    serialF.Text = PhidgetMotorControl.SerialNumber
    versionF.Text = PhidgetMotorControl.DeviceVersion
    numMotorsF.Text = PhidgetMotorControl.MotorCount
    numInputsF.Text = PhidgetMotorControl.InputCount
    numEncodersF.Text = PhidgetMotorControl.EncoderCount
    numSensorsF.Text = PhidgetMotorControl.SensorCount
End Sub

Private Sub InitializeForm()
    Dim i As Long
    
    If (PhidgetMotorControl.DeviceName <> "Phidget Motor Controller 1-motor") Then
        Label20.Enabled = False
        brakingSlider.Enabled = False
        Label14.Enabled = False
        brakingF.Enabled = False
        backEMFCheckBox.Enabled = False
        Label16.Enabled = False
        backEMFF.Enabled = False
        Label17.Enabled = False
        voltageF.Enabled = False
        Form1.Height = 10125
        If (PhidgetMotorControl.DeviceName <> "Phidget Low Voltage Motor Controller 2-motor 4-input") Then
            currentF.Enabled = True
            Label15.Enabled = True
        Else
            currentF.Enabled = False
            Label15.Enabled = False
        End If
    Else
        Label20.Enabled = True
        brakingSlider.Enabled = True
        Label14.Enabled = True
        brakingF.Enabled = True
        backEMFCheckBox.Enabled = True
        Label16.Enabled = True
        backEMFF.Enabled = True
        Label17.Enabled = True
        currentF.Enabled = True
        Label15.Enabled = True
        voltageF.Enabled = True
        brakingSlider.Enabled = True
        resetCmd.Enabled = True
        ratiometricCheckBox.Enabled = True
        Form1.Height = 11910
    End If
    
    motorIndex.Enabled = True
    velocitySlider.Enabled = True
    accelerationSlider.Enabled = True
    For i = 0 To digitalInput.Count - 1
        digitalInput(i).Enabled = True
    Next i
  
    For i = 0 To PhidgetMotorControl.MotorCount - 1
        If (i >= motorIndex.ListCount) Then
            motorIndex.AddItem (i)
        End If
    Next i
   
    motorIndex = 0
End Sub

Private Sub DisplayMotorData()
        
    currentVelocityF.Text = PhidgetMotorControl.Velocity(motorIndex)
    accelerationF.Text = PhidgetMotorControl.Acceleration(motorIndex)
    
    On Error GoTo errorBraking
    brakingF.Text = PhidgetMotorControl.Braking(motorIndex)
    
    On Error GoTo errorCurrent
    currentF.Text = PhidgetMotorControl.Current(motorIndex)
   
    On Error GoTo errorBackEMF
    If (PhidgetMotorControl.BackEMFSensingState((motorIndex))) Then
        backEMFCheckBox.Value = 1
        backEMFF.Text = PhidgetMotorControl.BackEMF((motorIndex))
    Else
        backEMFCheckBox.Value = 0
        backEMFF.Text = "Unknown"
    End If
    
    On Error GoTo errorSupplyVoltage
    voltageF.Text = PhidgetMotorControl.SupplyVoltage
   
    accelerationSlider.Max = PhidgetMotorControl.AccelerationMax(motorIndex)
    
    'ensure Slider.min is a valid whole number
    accelerationSlider.Min = Ceiling(PhidgetMotorControl.AccelerationMin(motorIndex))
    velocitySlider.Value = Ceiling(PhidgetMotorControl.Velocity(motorIndex))
    targetVelocityF.Text = velocitySlider.Value
    accelerationSlider.Value = PhidgetMotorControl.Acceleration(motorIndex)
    
    On Error GoTo errorBraking
    brakingSlider.Value = PhidgetMotorControl.Braking(motorIndex)
    Exit Sub

errorBraking:
    brakingF.Text = "Unknown"
    
errorCurrent:
    currentF.Text = "Unknown"
    Resume Next
    
errorBackEMF:
    backEMFCheckBox.Value = 0
    backEMFF.Text = "Unknown"
    brakingSlider.Value = 0
    brakingSlider.Enabled = False
    Resume Next
    
errorSupplyVoltage:
    voltageF.Text = "Unknown"
    Resume Next
End Sub

Private Sub DisplayDigitalInputData()
    Dim i As Integer
    For i = 0 To PhidgetMotorControl.InputCount - 1
        If (i >= digitalInput.Count) Then
            Load digitalInput(i)
        End If
        
        With digitalInput(i)
            .Visible = True
            .Left = 360 + i * 600
            .Caption = i
            If (PhidgetMotorControl.InputState(i)) Then
                .Value = 1
            Else
                .Value = 0
            End If
        End With
    Next i
End Sub

Private Sub DisplayEncoderData()
    Dim i As Integer
    For i = 0 To PhidgetMotorControl.EncoderCount - 1
        If (i >= encoderPositionL.Count) Then
            Load encoderPositionL(i)
            Load encoderPositionF(i)
        End If
        
        With encoderPositionL(i)
            .Visible = True
            .Left = 360 + i * 2000
            .Caption = "Position:"
        End With
        
        With encoderPositionF(i)
            .Visible = True
            .Left = 1050 + i * 2000
            .Text = PhidgetMotorControl.EncoderPosition(i)
        End With
    Next i
End Sub

Private Sub DisplaySensorData()
    Dim i As Integer
    For i = 0 To PhidgetMotorControl.SensorCount - 1
        If (i >= sensorValueL.Count) Then
            Load sensorValueL(i)
            Load sensorValueF(i)
        End If
        
        With sensorValueL(i)
            .Visible = True
            .Left = 360 + i * 1350
            .Caption = i
        End With
        
        With sensorValueF(i)
            .Visible = True
            .Left = 600 + i * 1350
            .Text = PhidgetMotorControl.SensorValue(i)
        End With
    Next i
  
    If (PhidgetMotorControl.Ratiometric) Then
        ratiometricCheckBox.Value = 1
    Else
        ratiometricCheckBox.Value = 0
    End If
    
End Sub

Private Sub PhidgetMotorControl_OnEncoderPositionChange(ByVal Index As Long, ByVal Time As Long, ByVal PositionChange As Long)
   encoderPositionF(Index).Text = PhidgetMotorControl.EncoderPosition(Index)
End Sub

Private Sub PhidgetMotorControl_OnInputChange(ByVal Index As Long, ByVal NewState As Boolean)
    If (NewState) Then
        digitalInput(Index).Value = 1
    Else
        digitalInput(Index).Value = 0
    End If
End Sub

Private Sub PhidgetMotorControl_OnSensorUpdate(ByVal Index As Long, ByVal SensorValue As Long)
    sensorValueF(Index).Text = SensorValue
End Sub

Private Sub PhidgetMotorControl_OnVelocityChange(ByVal Index As Long, ByVal newVal As Double)
    If (Index = motorIndex) Then
        currentVelocityF.Text = newVal
    End If
End Sub

Private Sub ratiometricCheckBox_Click()
    If (ratiometricCheckBox.Value = 1) Then
        PhidgetMotorControl.Ratiometric = True
    Else
        PhidgetMotorControl.Ratiometric = False
    End If
End Sub

Private Sub backEMFCheckBox_Click()
        If (backEMFCheckBox.Value = 0) Then
            PhidgetMotorControl.BackEMFSensingState(motorIndex) = False
        Else
            PhidgetMotorControl.BackEMFSensingState(motorIndex) = True
        End If
End Sub

Private Sub resetCmd_Click()
    Dim i As Long
    For i = 0 To PhidgetMotorControl.EncoderCount - 1
        PhidgetMotorControl.EncoderPosition(i) = 0
        encoderPositionF(i).Text = 0
    Next i
End Sub

Private Sub velocitySlider_Scroll()
    PhidgetMotorControl.Velocity(motorIndex) = velocitySlider.Value
    targetVelocityF.Text = velocitySlider.Value
End Sub

Private Sub accelerationSlider_Scroll()
    PhidgetMotorControl.Acceleration(motorIndex) = accelerationSlider.Value
    accelerationF.Text = accelerationSlider.Value
End Sub

Private Sub brakingSlider_Scroll()
    PhidgetMotorControl.Braking(motorIndex) = brakingSlider.Value
    brakingF.Text = brakingSlider.Value
End Sub

Private Sub motorIndex_Click()
    DisplayMotorData
End Sub

'returns the ceiling
Function Ceiling(Num As Double) As Long
    Ceiling = Int(Num + 0.9)
  
End Function

