VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   8100
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   13215
   LinkTopic       =   "Form1"
   ScaleHeight     =   8100
   ScaleWidth      =   13215
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox Text4 
      Height          =   495
      Left            =   120
      TabIndex        =   14
      Text            =   "False"
      Top             =   600
      Width           =   4455
   End
   Begin VB.CommandButton Command7 
      Caption         =   "Transmit LastLearnedCode"
      Height          =   735
      Left            =   8880
      TabIndex        =   9
      Top             =   7080
      Width           =   1575
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Transmit Apple Volume Down"
      Height          =   735
      Left            =   120
      TabIndex        =   8
      Top             =   7080
      Width           =   1215
   End
   Begin VB.CommandButton Command2 
      Caption         =   "GetRawData"
      Height          =   735
      Left            =   1440
      TabIndex        =   7
      Top             =   7080
      Width           =   1215
   End
   Begin VB.CommandButton Command3 
      Caption         =   "TransmitRepeat"
      Height          =   735
      Left            =   2760
      TabIndex        =   6
      Top             =   7080
      Width           =   1335
   End
   Begin VB.CommandButton Command4 
      Caption         =   "TransmitRaw"
      Height          =   735
      Left            =   4200
      TabIndex        =   5
      Top             =   7080
      Width           =   1335
   End
   Begin VB.CommandButton Command5 
      Caption         =   "GetLastCode"
      Height          =   735
      Left            =   5640
      TabIndex        =   4
      Top             =   7080
      Width           =   1215
   End
   Begin VB.CommandButton Command6 
      Caption         =   "GetLastLearnedCode"
      Height          =   735
      Left            =   6960
      TabIndex        =   3
      Top             =   7080
      Width           =   1815
   End
   Begin VB.TextBox Text1 
      Height          =   1095
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   2
      Top             =   1560
      Width           =   4455
   End
   Begin VB.TextBox Text2 
      Height          =   6255
      Left            =   4800
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   600
      Width           =   8175
   End
   Begin VB.TextBox Text3 
      Height          =   3855
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   3000
      Width           =   4455
   End
   Begin VB.Label Label4 
      Caption         =   "Attached:"
      Height          =   495
      Left            =   120
      TabIndex        =   13
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label Label3 
      Caption         =   "Raw Data:"
      Height          =   495
      Left            =   4800
      TabIndex        =   12
      Top             =   360
      Width           =   1215
   End
   Begin VB.Label Label2 
      Caption         =   "Learn:"
      Height          =   495
      Left            =   120
      TabIndex        =   11
      Top             =   2760
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "Code:"
      Height          =   495
      Left            =   120
      TabIndex        =   10
      Top             =   1320
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     ir-simple

' Description:
' -This example:
'    o displays code information as received by the PhidgetIR
'    o displays the codeInfo structure once the PhidgetIR learns a code
'    o displays raw data as received by the PhidgetIR
'    o provides an example of how to use the transmit and transmitRaw functions(transmitting a Volume Down signal to a Mac)
'    o lets a user transmit the last learned code
'    o is somewhat robust about ignoring other Phidgets that are attached
'

Option Explicit
Dim WithEvents PhidgetIR1 As PhidgetIR
Attribute PhidgetIR1.VB_VarHelpID = -1

Private Sub Command2_Click()
    Dim I As Long
    Dim rawData(16) As Long
    Dim dataLength As Long
    dataLength = 16
    PhidgetIR1.getRawData rawData, dataLength
    
    For I = 0 To dataLength - 1 Step 1
        If rawData(I) > 1000000 Then
            Text2.Text = Text2.Text & vbNewLine & "LONG" & vbNewLine
        Else
            Text2.Text = Text2.Text & rawData(I) & " "
        End If
    Next I
End Sub

Private Sub Command3_Click()
PhidgetIR1.TransmitRepeat
End Sub

Private Sub Command4_Click()
Dim intArray(70) As Long

'Apple Volume Up
intArray(0) = 9040
intArray(1) = 4590
intArray(2) = 540
intArray(3) = 630
intArray(4) = 550
intArray(5) = 1740
intArray(6) = 550
intArray(7) = 1750
intArray(8) = 550
intArray(9) = 1740

intArray(10) = 550
intArray(11) = 620
intArray(12) = 550
intArray(13) = 1750
intArray(14) = 550
intArray(15) = 1740
intArray(16) = 550
intArray(17) = 1750
intArray(18) = 550
intArray(19) = 1740

intArray(20) = 550
intArray(21) = 1740
intArray(22) = 560
intArray(23) = 1740
intArray(24) = 540
intArray(25) = 630
intArray(26) = 550
intArray(27) = 620
intArray(28) = 440
intArray(29) = 620

intArray(30) = 540
intArray(31) = 630
intArray(32) = 550
intArray(33) = 1750
intArray(34) = 550
intArray(35) = 1750
intArray(36) = 560
intArray(37) = 1740
intArray(38) = 550
intArray(39) = 620

intArray(40) = 550
intArray(41) = 1740
intArray(42) = 550
intArray(43) = 620
intArray(44) = 550
intArray(45) = 620
intArray(46) = 560
intArray(47) = 610
intArray(48) = 550
intArray(49) = 620

intArray(50) = 550
intArray(51) = 1750
intArray(52) = 550
intArray(53) = 1740
intArray(54) = 550
intArray(55) = 620
intArray(56) = 550
intArray(57) = 1740
intArray(58) = 550
intArray(59) = 1750

intArray(60) = 550
intArray(61) = 620
intArray(62) = 550
intArray(63) = 620
intArray(64) = 550
intArray(65) = 620
intArray(66) = 540
  
Dim length, carrierFrequency, dutyCycle, gap As Long
length = 67
carrierFrequency = 0
dutyCycle = 0
gap = 0

PhidgetIR1.TransmitRaw intArray, length, carrierFrequency, dutyCycle, gap
End Sub

Private Sub Command5_Click()
Dim I As Long
Dim byteArray(16) As Byte
Dim dataLength As Long
Dim bitCount As Long
dataLength = 16

PhidgetIR1.getLastCode byteArray, dataLength, bitCount

Text1.Text = "Last IR Code Received: 0x"
For I = 0 To dataLength - 1 Step 1
      Text1.Text = Text1.Text & Hex$(byteArray(I))
Next I
Text1.Text = Text1.Text & vbNewLine
Text1.Text = Text1.Text & "Data Length:" & Str(dataLength) & vbNewLine
Text1.Text = Text1.Text & "Bit Length:" & Str(bitCount) & vbNewLine

End Sub

Private Sub Command6_Click()
Dim I As Long
Dim byteArray(16) As Byte
Dim dataLength As Long
Dim pCodeInfo As PhidgetIR_CodeInfo
dataLength = 16

PhidgetIR1.getLastLearnedCode byteArray, dataLength, pCodeInfo

Text3.Text = "Last Learned IR Code" & vbNewLine
Text3.Text = Text3.Text & "Code: 0x"
For I = 0 To dataLength - 1 Step 1
    Text3.Text = Text3.Text & Hex$(byteArray(I))
Next I
Text3.Text = Text3.Text & vbNewLine

Text3.Text = Text3.Text & "Bit Length: " & pCodeInfo.bitCount & vbNewLine
Text3.Text = Text3.Text & "Carrier Frequency: " & pCodeInfo.carrierFrequency & vbNewLine
Text3.Text = Text3.Text & "Encoding: " & pCodeInfo.encoding & vbNewLine
Text3.Text = Text3.Text & "Gap: " & pCodeInfo.gap & vbNewLine
Text3.Text = Text3.Text & "Header: " & pCodeInfo.header(0) & " " & pCodeInfo.header(1) & vbNewLine
Text3.Text = Text3.Text & "Length: " & pCodeInfo.length & vbNewLine
Text3.Text = Text3.Text & "Min Repeat: " & pCodeInfo.min_repeat & vbNewLine
Text3.Text = Text3.Text & "One: " & pCodeInfo.one(0) & " " & pCodeInfo.one(1) & vbNewLine

Text3.Text = Text3.Text & "Repeat: "
For I = 0 To 25 Step 1
    If pCodeInfo.repeat(I) <> 0 Then
    Text3.Text = Text3.Text & pCodeInfo.repeat(I) & ", "
    End If
Next I
Text3.Text = Text3.Text & vbNewLine

Text3.Text = Text3.Text & "Toggle Mask: 0x"
For I = 0 To 15 Step 1
    Text3.Text = Text3.Text & Hex(pCodeInfo.toggle_mask(I))
Next I
Text3.Text = Text3.Text & vbNewLine

Text3.Text = Text3.Text & "Trail: " & pCodeInfo.trail & vbNewLine
Text3.Text = Text3.Text & "Zero: " & pCodeInfo.zero(0) & " " & pCodeInfo.zero(1) & vbNewLine
End Sub

Private Sub Command7_Click()

Dim byteArray(16) As Byte
Dim dataLength As Long
Dim codeInfo As PhidgetIR_CodeInfo
dataLength = 16
PhidgetIR1.getLastLearnedCode byteArray, dataLength, codeInfo
PhidgetIR1.Transmit byteArray, codeInfo
End Sub

Private Sub Form_Load()
Set PhidgetIR1 = Controls.Add("Phidget21COM.PhidgetIR", "PhidgetIR1")   'Get the phidget manager going
Call PhidgetIR1.Open
End Sub

Private Sub Form_Unload(Cancel As Integer)
DoEvents
PhidgetIR1.Close
End Sub

Private Sub PhidgetIR1_OnAttach()
Text4.Text = "True"
End Sub


Private Sub PhidgetIR1_OnDetach()
Text1.Text = ""
Text2.Text = ""
Text3.Text = ""
Text4.Text = "False"
End Sub

Private Sub Command1_Click()
Dim byteArray(4) As Byte
Dim codeInfo As PhidgetIR_CodeInfo

'We are setting the code to that of a Apple Volume Down
byteArray(0) = 119
byteArray(1) = 225
byteArray(2) = 176
byteArray(3) = 216

'Apple Volume Up
'byteArray(0) = 119
'byteArray(1) = 225
'byteArray(2) = 208
'byteArray(3) = 216

codeInfo.bitCount = 32

Call PhidgetIR1.Transmit(byteArray, codeInfo)
   
End Sub

Private Sub PhidgetIR1_OnCode(data() As Byte, ByVal dataLength As Long, ByVal bitCount As Long, ByVal repeat As Boolean)
Dim I As Long

Text1.Text = "IR Code: 0x"
For I = 0 To dataLength - 1 Step 1
      Text1.Text = Text1.Text & Hex$(data(I))
Next I
Text1.Text = Text1.Text & vbNewLine
Text1.Text = Text1.Text & "Data Length:" & Str(dataLength) & vbNewLine
Text1.Text = Text1.Text & "Bit Length:" & Str(bitCount) & vbNewLine
Text1.Text = Text1.Text & "Repeat Count:" & Str(repeat) & vbNewLine

End Sub


Private Sub PhidgetIR1_OnLearn(data() As Byte, ByVal dataLength As Long, pCodeInfo As Phidget21COMCtl.PhidgetIR_CodeInfo)

Dim I As Long
Text3.Text = "New Code has been learnt " & vbNewLine
Text3.Text = Text3.Text & "IR Code: 0x"

For I = 0 To dataLength - 1 Step 1
    Text3.Text = Text3.Text & Hex$(data(I))
Next I
Text3.Text = Text3.Text & vbNewLine

Text3.Text = Text3.Text & "Bit Length: " & pCodeInfo.bitCount & vbNewLine
Text3.Text = Text3.Text & "Carrier Frequency: " & pCodeInfo.carrierFrequency & vbNewLine
Text3.Text = Text3.Text & "Encoding: " & pCodeInfo.encoding & vbNewLine
Text3.Text = Text3.Text & "Gap: " & pCodeInfo.gap & vbNewLine
Text3.Text = Text3.Text & "Header: " & pCodeInfo.header(0) & " " & pCodeInfo.header(1) & vbNewLine
Text3.Text = Text3.Text & "Length: " & pCodeInfo.length & vbNewLine
Text3.Text = Text3.Text & "Min Repeat: " & pCodeInfo.min_repeat & vbNewLine
Text3.Text = Text3.Text & "One: " & pCodeInfo.one(0) & " " & pCodeInfo.one(1) & vbNewLine

Text3.Text = Text3.Text & "Repeat: "
For I = 0 To 25 Step 1
    If pCodeInfo.repeat(I) <> 0 Then
    Text3.Text = Text3.Text & pCodeInfo.repeat(I) & ", "
    End If
Next I
Text3.Text = Text3.Text & vbNewLine

Text3.Text = Text3.Text & "Toggle Mask: 0x"
For I = 0 To 15 Step 1
    Text3.Text = Text3.Text & Hex(pCodeInfo.toggle_mask(I))
Next I
Text3.Text = Text3.Text & vbNewLine

Text3.Text = Text3.Text & "Trail: " & pCodeInfo.trail & vbNewLine
Text3.Text = Text3.Text & "Zero: " & pCodeInfo.zero(0) & " " & pCodeInfo.zero(1) & vbNewLine

End Sub

Private Sub PhidgetIR1_OnRawData(data() As Long, ByVal dataLength As Long)
Dim I As Long
For I = 0 To dataLength - 1 Step 1
    If data(I) > 1000000 Then
        Text2.Text = "LONG" & vbNewLine
    Else
        Text2.Text = Text2.Text & data(I) & " "
    End If
Next I
End Sub

