VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   5790
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4845
   LinkTopic       =   "Form1"
   ScaleHeight     =   5790
   ScaleWidth      =   4845
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox dataRateF 
      BackColor       =   &H8000000F&
      Height          =   285
      Left            =   3720
      TabIndex        =   20
      Top             =   5070
      Width           =   576
   End
   Begin VB.Frame bridgeData 
      Caption         =   "Bridge Data"
      Height          =   2415
      Left            =   175
      TabIndex        =   12
      Top             =   3240
      Width           =   4455
      Begin VB.ComboBox gain 
         Height          =   315
         Left            =   3000
         Locked          =   -1  'True
         TabIndex        =   22
         Top             =   840
         Width           =   1095
      End
      Begin MSComctlLib.Slider dataRateSlider 
         Height          =   495
         Left            =   1200
         TabIndex        =   19
         Top             =   1680
         Width           =   2295
         _ExtentX        =   4048
         _ExtentY        =   873
         _Version        =   393216
         LargeChange     =   8
         SmallChange     =   8
         TickStyle       =   3
         TickFrequency   =   8
      End
      Begin VB.TextBox bridgeValueF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1920
         TabIndex        =   17
         Top             =   1320
         Width           =   2175
      End
      Begin VB.CheckBox enabledState 
         Caption         =   "Enabled"
         Height          =   555
         Left            =   360
         TabIndex        =   15
         Top             =   720
         Width           =   975
      End
      Begin VB.ComboBox bridgeIndex 
         Height          =   315
         ItemData        =   "Form1.frx":0000
         Left            =   2280
         List            =   "Form1.frx":0002
         Locked          =   -1  'True
         TabIndex        =   14
         Top             =   348
         Width           =   975
      End
      Begin VB.Label Label10 
         Caption         =   "Gain:"
         Height          =   255
         Left            =   2520
         TabIndex        =   21
         Top             =   885
         Width           =   855
      End
      Begin VB.Label Label9 
         Caption         =   "Data Rate:"
         Height          =   375
         Left            =   360
         TabIndex        =   18
         Top             =   1800
         Width           =   975
      End
      Begin VB.Label Label8 
         Caption         =   "Bridge Value (mV/V):"
         Height          =   255
         Left            =   360
         TabIndex        =   16
         Top             =   1320
         Width           =   1575
      End
      Begin VB.Label Label7 
         Caption         =   "Choose Bridge:"
         Height          =   255
         Left            =   1080
         TabIndex        =   13
         Top             =   365
         Width           =   1095
      End
   End
   Begin VB.Frame details 
      Caption         =   "Bridge Details"
      Height          =   3015
      Left            =   175
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      Begin VB.TextBox numBridgesF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   11
         Top             =   2400
         Width           =   2500
      End
      Begin VB.TextBox versionF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   9
         Top             =   2030
         Width           =   2500
      End
      Begin VB.TextBox serialF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   7
         Top             =   1645
         Width           =   2500
      End
      Begin VB.TextBox nameF 
         BackColor       =   &H8000000F&
         Height          =   800
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   5
         Top             =   745
         Width           =   2500
      End
      Begin VB.TextBox attachF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   2
         Top             =   360
         Width           =   2500
      End
      Begin VB.Label Label6 
         Caption         =   "# Bridges:"
         Height          =   285
         Left            =   360
         TabIndex        =   10
         Top             =   2400
         Width           =   855
      End
      Begin VB.Label Label5 
         Caption         =   "Version:"
         Height          =   285
         Left            =   360
         TabIndex        =   8
         Top             =   2030
         Width           =   735
      End
      Begin VB.Label Label4 
         Caption         =   "Serial No:"
         Height          =   285
         Left            =   360
         TabIndex        =   6
         Top             =   1645
         Width           =   735
      End
      Begin VB.Label Label3 
         Caption         =   "Name:"
         Height          =   285
         Left            =   360
         TabIndex        =   4
         Top             =   745
         Width           =   731
      End
      Begin VB.Label Label2 
         Caption         =   "Label2"
         Height          =   15
         Left            =   480
         TabIndex        =   3
         Top             =   720
         Width           =   2895
      End
      Begin VB.Label Label1 
         Caption         =   "Attached:"
         Height          =   285
         Left            =   360
         TabIndex        =   1
         Top             =   360
         Width           =   855
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     Bridge-full

' Description:
' -This example:
'    o displays all the information it can about the PhidgetBridge.
'    o allows user to change enable states, gain, and data rate.

Option Explicit
Dim WithEvents PhidgetBridge As PhidgetBridge
Attribute PhidgetBridge.VB_VarHelpID = -1

Private Sub Form_Load()
    Set PhidgetBridge = Controls.Add("Phidget21COM.PhidgetBridge", "phidgetBridge")
    PhidgetBridge.Open
    attachF.Text = PhidgetBridge.IsAttached
    enabledState.Enabled = False
    
End Sub

Private Sub PhidgetBridge_OnAttach()
    
    Dim i As Long
    
    enabledState.Enabled = True
    bridgeIndex.Enabled = True
    bridgeIndex.Locked = False
    gain.Enabled = True
    gain.Locked = False
    
    DisplayDetails
    
    For i = 0 To PhidgetBridge.InputCount - 1
        bridgeIndex.AddItem (i)
    Next i
   
   bridgeIndex = 0
    
   If (PhidgetBridge.Enabled(bridgeIndex)) Then
        enabledState.Value = 1
   Else
        enabledState.Value = 0
   End If
   
   gain.AddItem (1)
   gain.AddItem (8)
   gain.AddItem (16)
   gain.AddItem (32)
   gain.AddItem (64)
   gain.AddItem (128)
   gain = 1
   
   dataRateSlider.Min = PhidgetBridge.DataRateMax / 8
   dataRateSlider.Max = PhidgetBridge.DataRateMin / 8
   dataRateSlider.Value = PhidgetBridge.DataRate / 8
   dataRateF.Text = PhidgetBridge.DataRate
   
End Sub

Private Sub PhidgetBridge_OnBridgeData(ByVal Index As Long, ByVal Value As Double)
    bridgeValueF.Text = PhidgetBridge.BridgeValue(bridgeIndex)
End Sub

Private Sub PhidgetBridge_OnDetach()
    attachF.Text = "False"
    nameF.Text = ""
    serialF.Text = ""
    versionF.Text = ""
    numBridgesF.Text = ""
    enabledState.Value = 0
    enabledState.Enabled = False
    bridgeIndex.Clear
    gain.Clear
    bridgeValueF.Text = ""
    dataRateF.Text = ""
End Sub


Private Sub bridgeIndex_Click()
   If (PhidgetBridge.Enabled(bridgeIndex)) Then
        enabledState.Value = 1
   Else
        enabledState.Value = 0
   End If
   
    Select Case PhidgetBridge.gain(bridgeIndex)
        Case PHIDGETCOM_BRIDGE_GAIN_1:
            gain = 1
        Case PHIDGETCOM_BRIDGE_GAIN_1:
            gain = 8:
            Case PHIDGETCOM_BRIDGE_GAIN_16:
            gain = 16
        Case PHIDGETCOM_BRIDGE_GAIN_32:
            gain = 32:
            Case PHIDGETCOM_BRIDGE_GAIN_64:
            gain = 64
        Case PHIDGETCOM_BRIDGE_GAIN_128:
            gain = 128:
    End Select
End Sub

Private Sub dataRateSlider_Change()
    PhidgetBridge.DataRate = dataRateSlider.Value * 8
    dataRateF.Text = dataRateSlider.Value * 8
End Sub

Private Sub enabledState_Click()

    If (enabledState.Value = 0) Then
        PhidgetBridge.Enabled(bridgeIndex) = False
    Else
        PhidgetBridge.Enabled(bridgeIndex) = True
    End If
End Sub

Private Sub Gain_Click()
    Select Case gain
        Case 1: PhidgetBridge.gain(bridgeIndex) = PHIDGETCOM_BRIDGE_GAIN_1
        Case 8: PhidgetBridge.gain(bridgeIndex) = PHIDGETCOM_BRIDGE_GAIN_8
        Case 16: PhidgetBridge.gain(bridgeIndex) = PHIDGETCOM_BRIDGE_GAIN_16
        Case 32: PhidgetBridge.gain(bridgeIndex) = PHIDGETCOM_BRIDGE_GAIN_32
        Case 64: PhidgetBridge.gain(bridgeIndex) = PHIDGETCOM_BRIDGE_GAIN_64
        Case 128: PhidgetBridge.gain(bridgeIndex) = PHIDGETCOM_BRIDGE_GAIN_128
    End Select
End Sub

'Display the properties of the device
Private Sub DisplayDetails()
    Dim i As Integer
    attachF.Text = PhidgetBridge.IsAttached
    nameF.Text = PhidgetBridge.DeviceName
    serialF.Text = PhidgetBridge.SerialNumber
    versionF.Text = PhidgetBridge.DeviceVersion
    numBridgesF.Text = PhidgetBridge.InputCount
    
End Sub


