VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "StepperSlider: Example of a PhidgetStepper program"
   ClientHeight    =   6510
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6870
   LinkTopic       =   "Form1"
   ScaleHeight     =   6510
   ScaleWidth      =   6870
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Motor 0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5055
      Left            =   120
      TabIndex        =   6
      Top             =   1320
      Width           =   6615
      Begin VB.CommandButton resetPositionBtn 
         Caption         =   "Reset Position"
         Height          =   375
         Left            =   5040
         TabIndex        =   29
         Top             =   4440
         Width           =   1215
      End
      Begin VB.CheckBox input3Chk 
         Caption         =   "Input 3"
         Enabled         =   0   'False
         Height          =   255
         Left            =   3240
         TabIndex        =   28
         Top             =   4560
         Width           =   975
      End
      Begin VB.CheckBox input2Chk 
         Caption         =   "Input 2"
         Enabled         =   0   'False
         Height          =   255
         Left            =   2280
         TabIndex        =   27
         Top             =   4560
         Width           =   975
      End
      Begin VB.CheckBox input1Chk 
         Caption         =   "Input 1"
         Enabled         =   0   'False
         Height          =   255
         Left            =   1320
         TabIndex        =   26
         Top             =   4560
         Width           =   855
      End
      Begin VB.CheckBox input0Chk 
         Caption         =   "Input 0"
         Enabled         =   0   'False
         Height          =   255
         Left            =   360
         TabIndex        =   24
         Top             =   4560
         Width           =   975
      End
      Begin MSComctlLib.Slider CurrentLimSlider 
         Height          =   375
         Left            =   1320
         TabIndex        =   19
         Top             =   2280
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   661
         _Version        =   393216
      End
      Begin VB.CheckBox StoppedCheck 
         Caption         =   "Stopped"
         Enabled         =   0   'False
         Height          =   375
         Left            =   4320
         TabIndex        =   14
         Top             =   3840
         Width           =   975
      End
      Begin VB.CheckBox EngagedCheck 
         Caption         =   "Engaged"
         Height          =   375
         Left            =   4320
         TabIndex        =   13
         Top             =   3480
         Width           =   1215
      End
      Begin MSComctlLib.Slider PositionSlider 
         Height          =   495
         Left            =   1320
         TabIndex        =   12
         Top             =   1680
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   873
         _Version        =   393216
         LargeChange     =   1000
         Min             =   -20000
         Max             =   20000
         TickFrequency   =   1000
      End
      Begin MSComctlLib.Slider VelocitySlider 
         Height          =   495
         Left            =   1320
         TabIndex        =   7
         Top             =   480
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   873
         _Version        =   393216
         Max             =   1000000
         SelStart        =   90
         TickFrequency   =   100
         Value           =   90
      End
      Begin MSComctlLib.Slider AccelSlider 
         Height          =   495
         Left            =   1320
         TabIndex        =   8
         Top             =   1080
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   873
         _Version        =   393216
         Max             =   1000000
         SelStart        =   90
         TickFrequency   =   500
         Value           =   90
      End
      Begin VB.Label Label9 
         Caption         =   "Inputs:"
         Height          =   255
         Left            =   360
         TabIndex        =   25
         Top             =   4320
         Width           =   735
      End
      Begin VB.Label CurrentLimDispLbl 
         Height          =   255
         Left            =   240
         TabIndex        =   23
         Top             =   2520
         Width           =   975
      End
      Begin VB.Label CurrentDispLbl 
         Height          =   255
         Left            =   1920
         TabIndex        =   22
         Top             =   3960
         Width           =   1935
      End
      Begin VB.Label CurrentLbl 
         Caption         =   "Current:"
         Height          =   255
         Left            =   360
         TabIndex        =   21
         Top             =   3960
         Width           =   1215
      End
      Begin VB.Label CurrentLimLbl 
         Caption         =   "Current Limit:"
         Height          =   255
         Left            =   240
         TabIndex        =   20
         Top             =   2280
         Width           =   975
      End
      Begin VB.Label CurrentVelocity 
         Height          =   255
         Left            =   1920
         TabIndex        =   18
         Top             =   3600
         Width           =   1935
      End
      Begin VB.Label CurrentPosition 
         Height          =   255
         Left            =   1920
         TabIndex        =   17
         Top             =   3240
         Width           =   1935
      End
      Begin VB.Label Label8 
         Caption         =   "Current Velocity:"
         Height          =   255
         Left            =   360
         TabIndex        =   16
         Top             =   3600
         Width           =   1215
      End
      Begin VB.Label Label7 
         Caption         =   "Current Position:"
         Height          =   255
         Left            =   360
         TabIndex        =   15
         Top             =   3240
         Width           =   1215
      End
      Begin VB.Label Label6 
         Caption         =   "Position:"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   1680
         Width           =   975
      End
      Begin VB.Label Label5 
         Caption         =   "Acceleration:"
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   1080
         Width           =   1095
      End
      Begin VB.Label Label1 
         Caption         =   "Velocity Limit:"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   480
         Width           =   975
      End
   End
   Begin VB.Label lblSerialNumber 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   5
      Top             =   840
      Width           =   1935
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Serial Number:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   840
      Width           =   2055
   End
   Begin VB.Label lblNumMotors 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   3
      Top             =   480
      Width           =   1935
   End
   Begin VB.Label label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Number of Motors:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   480
      Width           =   2175
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Status:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   135
      TabIndex        =   1
      Top             =   120
      Width           =   2160
   End
   Begin VB.Label lblMessage 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   0
      Top             =   120
      Width           =   3720
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     MotorSlider

' Description:
' -This example:
'    o lets a user interactively adjust the angle of all motors through a slider
'    o displays all the information it can about the PhidgetMotorControl.
'    o is somewhat robust about ignoring other PhidgetMotorControls that are attached
'

Option Explicit
Dim WithEvents Stepper As PhidgetStepper
Attribute Stepper.VB_VarHelpID = -1

Private Sub AccelSlider_Click()
    Stepper.Acceleration(0) = AccelSlider.Value
End Sub

Private Sub EngagedCheck_Click()
    Stepper.Engaged(0) = EngagedCheck.Value
End Sub

Private Sub Form_Load()
    lblMessage.Caption = "Attach a PhidgetStepper"
    Set Stepper = Controls.Add("Phidget21COM.PhidgetStepper", "Stepper")
    Stepper.EnableVerboseErrors True
    Stepper.Open
    
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Stepper.Engaged(0) = False
    Stepper.Close
End Sub

Private Sub PositionSlider_Click()
    Stepper.TargetPosition(0) = PositionSlider.Value
End Sub

Private Sub resetPositionBtn_Click()
    Stepper.CurrentPosition(0) = 0
End Sub

Private Sub Stepper_OnAttach()
    'Show the current Motor information
    lblMessage.Caption = "PhidgetStepper Attached"
    lblNumMotors.Caption = Stepper.MotorCount
    lblSerialNumber.Caption = Stepper.SerialNumber
    
    VelocitySlider.Min = Stepper.VelocityMin(0)
    VelocitySlider.Max = Stepper.VelocityMax(0)
    VelocitySlider.TickFrequency = Stepper.VelocityMax(0) / 64
    VelocitySlider.LargeChange = Stepper.VelocityMax(0) / 64
    
    AccelSlider.Min = Stepper.AccelerationMin(0)
    AccelSlider.Max = Stepper.AccelerationMax(0)
    AccelSlider.TickFrequency = Stepper.AccelerationMin(0) * 4
    AccelSlider.LargeChange = Stepper.AccelerationMin(0)
    
    PositionSlider.Min = -20000
    PositionSlider.Max = 20000
    PositionSlider.TickFrequency = 1000
    PositionSlider.LargeChange = 250
    
    If Stepper.DeviceName <> "Phidget Bipolar Stepper Controller 1-motor" Then
        CurrentLimSlider.Visible = False
        CurrentLimLbl.Visible = False
        CurrentLimSlider.Enabled = False
        
        CurrentLbl.Visible = False
        CurrentDispLbl.Caption = ""
        CurrentDispLbl.Visible = False
        
        Label9.Visible = False
        input0Chk.Visible = False
        input1Chk.Visible = False
        input2Chk.Visible = False
        input3Chk.Visible = False
    Else
        CurrentLimSlider.Visible = True
        CurrentLimLbl.Visible = True
        CurrentLimSlider.Enabled = True
        
        CurrentLbl.Visible = True
        CurrentDispLbl.Caption = ""
        CurrentDispLbl.Visible = True
        CurrentLimDispLbl.Caption = ""
        CurrentLimDispLbl.Visible = True
        
        CurrentLimSlider.Min = Stepper.CurrentMin(0) * 100
        CurrentLimSlider.Max = Stepper.CurrentMax(0) * 100
        CurrentLimSlider.TickFrequency = 5
        CurrentLimSlider.LargeChange = 1
        CurrentLimSlider.Value = Stepper.CurrentMin(0) * 100
        CurrentLimDispLbl.Caption = Stepper.CurrentMin(0)
        Stepper.CurrentLimit(0) = Stepper.CurrentMin(0)
        
        Label9.Visible = True
        input0Chk.Visible = True
        input1Chk.Visible = True
        input2Chk.Visible = True
        input3Chk.Visible = True
    End If
End Sub

Private Sub Stepper_OnCurrentChange(ByVal Index As Long, ByVal newVal As Double)
    CurrentDispLbl.Caption = newVal
End Sub

Private Sub Stepper_OnDetach()
    'Show the current Motor information
    lblMessage.Caption = "Attach a PhidgetStepper"
    lblNumMotors.Caption = ""
    lblSerialNumber.Caption = ""
End Sub

Private Sub Stepper_OnInputChange(ByVal Index As Long, ByVal NewState As Boolean)
    If NewState = True Then
        If Index = 0 Then input0Chk.Value = 1
        If Index = 1 Then input1Chk.Value = 1
        If Index = 2 Then input2Chk.Value = 1
        If Index = 3 Then input3Chk.Value = 1
    Else
        If Index = 0 Then input0Chk.Value = 0
        If Index = 1 Then input1Chk.Value = 0
        If Index = 2 Then input2Chk.Value = 0
        If Index = 3 Then input3Chk.Value = 0
    End If
End Sub

Private Sub Stepper_OnPositionChange(ByVal Index As Long, ByVal newVal As Long)
    If Index = 0 Then
        CurrentPosition.Caption = newVal
        If Stepper.Stopped(0) = True Then
            StoppedCheck.Value = 1
        Else
            StoppedCheck.Value = 0
        End If
    End If
End Sub

Private Sub Stepper_OnVelocityChange(ByVal Index As Long, ByVal newVal As Double)
    If Index = 0 Then
        CurrentVelocity.Caption = newVal
        If Stepper.Stopped(0) = True Then
            StoppedCheck.Value = 1
        Else
            StoppedCheck.Value = 0
        End If
    End If
End Sub

Private Sub VelocitySlider_Click()
    Stepper.VelocityLimit(0) = VelocitySlider.Value
End Sub

Private Sub CurrentLimSlider_Click()
    Dim Current As Double
    Current = CurrentLimSlider.Value / 100
    If Current < Stepper.CurrentMin(0) Then
        Current = Stepper.CurrentMin(0)
    End If
    If Current > Stepper.CurrentMax(0) Then
        Current = Stepper.CurrentMax(0)
    End If
    
    Stepper.CurrentLimit(0) = Current
    CurrentLimDispLbl.Caption = Current
End Sub
