VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Spatial Example"
   ClientHeight    =   7950
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5790
   LinkTopic       =   "Form1"
   ScaleHeight     =   7950
   ScaleWidth      =   5790
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton zeroGyroBtn 
      Caption         =   "Zero Gyro"
      Height          =   375
      Left            =   2400
      TabIndex        =   23
      Top             =   4920
      Width           =   855
   End
   Begin VB.PictureBox AccelGraph 
      Height          =   3615
      Left            =   120
      ScaleHeight     =   3555
      ScaleWidth      =   5475
      TabIndex        =   22
      Top             =   480
      Width           =   5535
   End
   Begin VB.Frame Frame1 
      Caption         =   "Compass Data"
      Height          =   1455
      Left            =   120
      TabIndex        =   9
      Top             =   6360
      Width           =   5535
      Begin VB.TextBox bearingTxt 
         Height          =   285
         Left            =   3600
         TabIndex        =   21
         Top             =   960
         Width           =   1815
      End
      Begin VB.TextBox rollAngleTxt 
         Height          =   285
         Left            =   3600
         TabIndex        =   17
         Top             =   600
         Width           =   1815
      End
      Begin VB.TextBox pitchAngleTxt 
         Height          =   285
         Left            =   3600
         TabIndex        =   16
         Top             =   240
         Width           =   1815
      End
      Begin VB.TextBox compassZ 
         Height          =   285
         Left            =   360
         TabIndex        =   15
         Top             =   960
         Width           =   1695
      End
      Begin VB.TextBox compassY 
         Height          =   285
         Left            =   360
         TabIndex        =   14
         Top             =   600
         Width           =   1695
      End
      Begin VB.TextBox compassX 
         Height          =   285
         Left            =   360
         TabIndex        =   13
         Top             =   240
         Width           =   1695
      End
      Begin VB.Label Label9 
         Caption         =   "Bearing:"
         Height          =   255
         Left            =   2520
         TabIndex        =   20
         Top             =   960
         Width           =   855
      End
      Begin VB.Label Label8 
         Caption         =   "Roll Angle:"
         Height          =   255
         Left            =   2520
         TabIndex        =   19
         Top             =   600
         Width           =   975
      End
      Begin VB.Label Label7 
         Caption         =   "Pitch Angle:"
         Height          =   255
         Left            =   2520
         TabIndex        =   18
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label6 
         Caption         =   "Z:"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   960
         Width           =   255
      End
      Begin VB.Label Label5 
         Caption         =   "Y:"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   600
         Width           =   255
      End
      Begin VB.Label Label4 
         Caption         =   "X:"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   240
         Width           =   255
      End
   End
   Begin VB.Frame gyroData 
      Caption         =   "Gyro Data"
      Height          =   1455
      Left            =   120
      TabIndex        =   2
      Top             =   4800
      Width           =   2175
      Begin VB.TextBox gyroZ 
         Height          =   285
         Left            =   480
         TabIndex        =   8
         Top             =   960
         Width           =   1575
      End
      Begin VB.TextBox gyroY 
         Height          =   285
         Left            =   480
         TabIndex        =   7
         Top             =   600
         Width           =   1575
      End
      Begin VB.TextBox gyroX 
         Height          =   285
         Left            =   480
         TabIndex        =   6
         Top             =   240
         Width           =   1575
      End
      Begin VB.Label Label3 
         Caption         =   "Z:"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   960
         Width           =   255
      End
      Begin VB.Label Label2 
         Caption         =   "Y:"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   600
         Width           =   255
      End
      Begin VB.Label Label1 
         Caption         =   "X:"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   240
         Width           =   255
      End
   End
   Begin VB.Label lblSerialNumber 
      Caption         =   "Serial Number"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   4200
      Width           =   3135
   End
   Begin VB.Label lblMessage 
      Caption         =   "Message"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3015
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     Spatial_Simple

' Description:
' -This example:
'    o displays all the information it can about the PhidgetSpatial.
'
' Does some very simple filtering
' Displays the X and Y acceleration as a vector
' The circle displays the limits of a 1g acceleration vector.

Option Explicit
Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Dim WithEvents spatial As PhidgetSpatial
Attribute spatial.VB_VarHelpID = -1
Dim XFilt(6), YFilt(6), RFilt(6) As Double
Dim XOut, YOut, ROut As Double
Dim X1Old, Y1Old As Integer
Dim XCenter, YCenter As Integer
Dim lastMsCount(3) As Double
Dim gyroHeading(3) As Double
Dim lastMsCountGood(3) As Boolean
Dim compassBearing As Double
Dim lastBearing As Double
Dim compassBearingFilterSize As Integer
Dim compassBearingFilter As New Collection
Dim pi As Double


Private Sub Form_Load()
    Set spatial = Controls.Add("Phidget21COM.PhidgetSpatial", "spatial")
    lblMessage.Caption = "Attach a PhidgetSpatial"
    Call spatial.Open
    pi = 4 * Atn(1)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    DoEvents
    Call spatial.Close
End Sub

Private Sub spatial_OnAttach()
    AccelGraph.DrawWidth = 2
    XCenter = AccelGraph.ScaleWidth / 2
    YCenter = AccelGraph.ScaleHeight / 2
    X1Old = XCenter
    Y1Old = YCenter
    'Show the current information
    lblMessage.Caption = "PhidgetSpatial Attached"
    lblSerialNumber.Caption = "SerialNumber : " & spatial.SerialNumber
    lastMsCountGood(0) = False
    lastMsCountGood(1) = False
    lastMsCountGood(2) = False
    lastMsCount(0) = 0
    lastMsCount(1) = 0
    lastMsCount(2) = 0
    gyroHeading(0) = 0
    gyroHeading(1) = 0
    gyroHeading(2) = 0
    lastBearing = 0
    compassBearing = 0
    compassBearingFilterSize = 10
End Sub

Private Sub spatial_OnDetach()
    lblMessage.Caption = "Attach a PhidgetSpatial "
    lblSerialNumber.Caption = ""
End Sub

Private Sub spatial_OnSpatialData(data() As Phidget21COMCtl.PhidgetSpatial_SpatialEventData, ByVal dataCount As Long)
    Dim I As Integer
    
    If spatial.AccelerationAxisCount > 0 Then
        ' Erase the old line
        AccelGraph.Line (XCenter, YCenter)-(X1Old, Y1Old), &H8000000F
        If ROut > 0 Then
            AccelGraph.Circle (XCenter, YCenter), ROut * 1000, &H8000000F
        ElseIf ROut < 0 Then
            AccelGraph.Circle (XCenter, YCenter), -ROut * 1000, &H8000000F
        End If
        
        ' We are performing a very simple low pass filter here.
        ' You don't have to use this, but for measuring things that
        ' change slowly, it's nice to filter the data a little more.
        XOut = 0
        XFilt(6) = data(0).Acceleration(0)
        For I = 0 To 5
            XFilt(I) = XFilt(I + 1)
            XOut = XOut + XFilt(I)
        Next I
        XOut = XOut / 6
        
        YOut = 0
        YFilt(6) = data(0).Acceleration(1)
        For I = 0 To 5
            YFilt(I) = YFilt(I + 1)
            YOut = YOut + YFilt(I)
        Next I
        YOut = YOut / 6
        
        ROut = 0
        RFilt(6) = data(0).Acceleration(2)
        For I = 0 To 5
            RFilt(I) = RFilt(I + 1)
            ROut = ROut + RFilt(I)
        Next I
        ROut = ROut / 6
        
        'Calculate the coordinates for the line
        'In the next event, we will erase this line.
        X1Old = XCenter - XOut * 1000
        Y1Old = YCenter + YOut * 1000
        AccelGraph.Line (XCenter, YCenter)-(X1Old, Y1Old)
        
        AccelGraph.Circle (XCenter, YCenter), 1000, vbBlue
        
        If ROut > 0 Then
            AccelGraph.Circle (XCenter, YCenter), ROut * 1000, vbRed
        ElseIf ROut < 0 Then
            AccelGraph.Circle (XCenter, YCenter), -ROut * 1000, vbGreen
        End If
    End If
    
    If spatial.GyroAxisCount > 0 Then
        calculateGyroHeading data, dataCount, 0
        calculateGyroHeading data, dataCount, 1
        calculateGyroHeading data, dataCount, 2
        
        gyroX.Text = FormatNumber(gyroHeading(0), 3, vbTrue, vbFalse, vbFalse) + ""
        gyroY.Text = FormatNumber(gyroHeading(1), 3, vbTrue, vbFalse, vbFalse) + ""
        gyroZ.Text = FormatNumber(gyroHeading(2), 3, vbTrue, vbFalse, vbFalse) + ""
    End If
    
    If spatial.CompassAxisCount > 0 And ((UBound(data(0).magneticField) - LBound(data(0).magneticField)) > 0) Then
        compassX.Text = FormatNumber(spatial.magneticField(0), 3, vbTrue, vbFalse, vbFalse)
        compassY.Text = FormatNumber(spatial.magneticField(1), 3, vbTrue, vbFalse, vbFalse)
        compassZ.Text = FormatNumber(spatial.magneticField(2), 3, vbTrue, vbFalse, vbFalse)
        
        calculateCompassBearing
    End If
End Sub

Private Sub calculateGyroHeading(data() As Phidget21COMCtl.PhidgetSpatial_SpatialEventData, dataCount As Long, index As Integer)
    Dim gyro As Double
    Dim timeChange As Double
    Dim timeChangeSeconds As Double
    Dim I As Integer
    
    gyro = 0
    
    For I = 0 To (dataCount - 1)
        gyro = data(I).angularRate(index)
        
        If lastMsCountGood(index) Then
            timeChange = (data(I).time_seconds * 1000) + (data(I).time_microseconds / 1000) - lastMsCount(index)
            timeChangeSeconds = timeChange / 1000
            
            gyroHeading(index) = gyroHeading(index) + (timeChangeSeconds * gyro)
        End If
        
        lastMsCount(index) = (data(I).time_seconds * 1000) + (data(I).time_microseconds / 1000)
        lastMsCountGood(index) = True
    Next I
End Sub

Private Sub calculateCompassBearing()
    Dim I As Integer
    Dim J As Integer
    
    Dim Xh As Double
    Dim Yh As Double
    
    Dim accelerationVector(3) As Double
    Dim gravityVector(3) As Double
    Dim pitchAngle As Double
    Dim rollAngle As Double
    Dim accelerationVectorLength As Double
    
    Dim xRotMatrix(3, 3) As Double
    Dim zRotMatrix(3, 3) As Double
    Dim rotMatrix(3, 3) As Double
    
    Dim dataVector(3) As Double
    Dim correctedDataVector(3) As Double
    
    Dim bearing As Double
    Dim Rads360 As Double
    
    Dim compassFilterElement As FilterElement
    Dim stuff As FilterElement
    
    Xh = 0
    Yh = 0
    
    accelerationVector(0) = spatial.Acceleration(0)
    accelerationVector(1) = spatial.Acceleration(1)
    accelerationVector(2) = spatial.Acceleration(2)
    
    accelerationVectorLength = Sqr((accelerationVector(0) * accelerationVector(0)) + (accelerationVector(1) * accelerationVector(1)) + (accelerationVector(2) * accelerationVector(2)))
    
    gravityVector(0) = accelerationVector(0) / accelerationVectorLength
    gravityVector(1) = accelerationVector(1) / accelerationVectorLength
    gravityVector(2) = accelerationVector(2) / accelerationVectorLength
    
    pitchAngle = ArcSin(gravityVector(0))
    rollAngle = ArcSin(gravityVector(1))
    
    If gravityVector(2) < 0 Then
        pitchAngle = -pitchAngle
        rollAngle = -rollAngle
    End If
        
    xRotMatrix(0, 0) = Cos(pitchAngle)
    xRotMatrix(1, 0) = -Sin(pitchAngle)
    xRotMatrix(2, 0) = 0
    xRotMatrix(0, 1) = Sin(pitchAngle)
    xRotMatrix(1, 1) = Cos(pitchAngle)
    xRotMatrix(2, 1) = 0
    xRotMatrix(0, 2) = 0
    xRotMatrix(1, 2) = 0
    xRotMatrix(2, 2) = 1
    
    zRotMatrix(0, 0) = 1
    zRotMatrix(1, 0) = 0
    zRotMatrix(2, 0) = 0
    zRotMatrix(0, 1) = 0
    zRotMatrix(1, 1) = Cos(rollAngle)
    zRotMatrix(2, 1) = -Sin(rollAngle)
    zRotMatrix(0, 2) = 0
    zRotMatrix(1, 2) = Sin(rollAngle)
    zRotMatrix(2, 2) = Cos(rollAngle)
    
    For I = 0 To 3
        For J = 0 To 3
            rotMatrix(I, J) = (zRotMatrix(I, 0) * xRotMatrix(0, J)) + (zRotMatrix(I, 1) * xRotMatrix(1, J)) + (zRotMatrix(I, 2) * xRotMatrix(2, J))
        Next J
    Next I
    
    dataVector(0) = spatial.magneticField(0)
    dataVector(1) = spatial.magneticField(2)
    dataVector(2) = -spatial.magneticField(1)
    
    correctedDataVector(0) = (rotMatrix(0, 0) * dataVector(0)) + (rotMatrix(1, 0) * dataVector(1)) + (rotMatrix(2, 0) * dataVector(2))
    correctedDataVector(1) = (rotMatrix(0, 1) * dataVector(0)) + (rotMatrix(1, 1) * dataVector(1)) + (rotMatrix(2, 1) * dataVector(2))
    correctedDataVector(2) = (rotMatrix(0, 2) * dataVector(0)) + (rotMatrix(1, 2) * dataVector(1)) + (rotMatrix(2, 2) * dataVector(2))
    
    Xh = -correctedDataVector(2)
    Yh = -correctedDataVector(0)
    
    bearing = 0
    Rads360 = 360 * pi / 180
    
    If Xh < 0 Then
        bearing = pi - Atn(Yh / Xh)
    ElseIf Xh > 0 And Yh < 0 Then
        bearing = -Atn(Yh / Xh)
    ElseIf Xh > 0 And Yh > 0 Then
        bearing = pi * 2 - Atn(Yh / Xh)
    ElseIf Xh = 0 And Yh < 0 Then
        bearing = pi / 2
    ElseIf Xh = 0 And Yh > 0 Then
        bearing = pi * 1.5
    End If
    
    If gravityVector(1) < 0 Then
        bearing = Abs(bearing - Rads360)
    End If
    
    'Passing the 0 <-> 360 point, need to make sure the filter never contains both values near 0 and values near 360 at the same time.
    If Abs(bearing - lastBearing) > 2 Then
        If bearing > lastBearing Then
            For Each stuff In compassBearingFilter
                stuff.bearing = stuff.bearing + Rads360
            Next stuff
        Else
            For Each stuff In compassBearingFilter
                stuff.bearing = stuff.bearing - Rads360
            Next stuff
        End If
    End If
    
    Set compassFilterElement = New FilterElement
    compassFilterElement.bearing = bearing
    compassFilterElement.pitchAngle = pitchAngle
    compassFilterElement.rollAngle = rollAngle
    
    compassBearingFilter.Add compassFilterElement
    If compassBearingFilter.Count > compassBearingFilterSize Then
        compassBearingFilter.Remove (1)
    End If
    
    bearing = 0
    pitchAngle = 0
    rollAngle = 0
    
    For Each stuff In compassBearingFilter
        bearing = bearing + stuff.bearing
        pitchAngle = pitchAngle + stuff.pitchAngle
        rollAngle = rollAngle + stuff.rollAngle
    Next stuff
    
    bearing = bearing / compassBearingFilter.Count
    pitchAngle = pitchAngle / compassBearingFilter.Count
    rollAngle = rollAngle / compassBearingFilter.Count
    
    compassBearing = bearing * (180 / pi)
    lastBearing = bearing
    
    pitchAngleTxt.Text = FormatNumber((pitchAngle * (180 / pi)), 2, vbTrue, vbFalse, vbFalse) + ""
    rollAngleTxt.Text = FormatNumber((rollAngle * (180 / pi)), 2, vbTrue, vbFalse, vbFalse) + ""
    bearingTxt.Text = FormatNumber((bearing * (180 / pi)), 2, vbTrue, vbFalse, vbFalse) + ""
End Sub

Private Sub zeroGyroBtn_Click()
    Call spatial.zeroGyro
    Sleep 100
    gyroHeading(0) = 0
    gyroHeading(1) = 0
    gyroHeading(2) = 0
End Sub

Function ArcSin(X As Double) As Double
    ArcSin = Atn(X / Sqr(-X * X + 1))
End Function

Function ArcCos(X As Double) As Double
    ArcCos = Atn(-X / Sqr(-X * X + 1)) + 2 * Atn(1)
End Function

Private Sub Pause(ByVal Delay As Single)
   Delay = Timer + Delay
   If Delay > 86400 Then 'more than number of seconds in a day
      Delay = Delay - 86400
      Do
          DoEvents ' to process events.
          Sleep 1 ' to not eat cpu
      Loop Until Timer < 1
   End If
   Do
       DoEvents ' to process events.
       Sleep 1 ' to not eat cpu
   Loop While Delay > Timer
End Sub
