VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "PH Sensor - A very simple example"
   ClientHeight    =   1875
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5070
   LinkTopic       =   "Form1"
   ScaleHeight     =   1875
   ScaleWidth      =   5070
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.Slider sldrPH 
      Height          =   615
      Left            =   240
      TabIndex        =   1
      Top             =   480
      Width           =   4695
      _ExtentX        =   8281
      _ExtentY        =   1085
      _Version        =   393216
      Min             =   -1
      Max             =   15
      TickFrequency   =   10
   End
   Begin VB.Label Label4 
      Caption         =   "0"
      Height          =   255
      Left            =   1920
      TabIndex        =   5
      Top             =   1560
      Width           =   2055
   End
   Begin VB.Label Label3 
      Caption         =   "Potential (milliVolts):"
      Height          =   255
      Left            =   360
      TabIndex        =   4
      Top             =   1560
      Width           =   1575
   End
   Begin VB.Label Label2 
      Caption         =   "PH:"
      Height          =   255
      Left            =   360
      TabIndex        =   3
      Top             =   1200
      Width           =   375
   End
   Begin VB.Label Label1 
      Caption         =   "0"
      Height          =   255
      Left            =   1920
      TabIndex        =   2
      Top             =   1200
      Width           =   855
   End
   Begin VB.Label lblMessage 
      Caption         =   "Attach a PhidgetPHSensor"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   2535
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     PHSensor-Simple

' Description:
' -This simple example controls a slider using the feedback
'  from a PhidgetPHSensor

Option Explicit

Dim WithEvents PHSensor As PhidgetPHSensor
Attribute PHSensor.VB_VarHelpID = -1


Dim WFilt(0 To 6) As Double

Dim XOut As Double



Private Sub Form_Load()

    Set PHSensor = Controls.Add("Phidget21COM.PhidgetPHSensor", "PHSensor")        'Get the phidget manager going

    lblMessage.Caption = "Attach a PhidgetPHSensor"

    sldrPH.Value = 0

    PHSensor.Open

End Sub





'Phidget is ATTACHING

Private Sub PHSensor_OnAttach()

    lblMessage.Caption = "PhidgetPHSensor Attached"

    PHSensor.PHChangeTrigger = 0.01

End Sub



'Phidget is DETACHING: Clean up

Private Sub PHSensor_OnDetach()

    lblMessage.Caption = "Attach a PhidgetPHSensor "

End Sub



Private Sub PHSensor_OnPHChange(ByVal PH As Double)

    Dim I As Integer

    

    ' We are performing a very simple low pass filter here.

    ' You don't have to use this, but for measuring things that

    ' change slowly, it's nice to filter the data a little more.

    XOut = 0

    WFilt(6) = PH
    

    For I = 0 To 5

        WFilt(I) = WFilt(I + 1)

        XOut = XOut + WFilt(I)

    Next I

    XOut = XOut / 6



    sldrPH.Value = XOut

    Label1.Caption = Round(XOut, 3)
    
    Label4.Caption = (PHSensor.Potential * 1000)

End Sub

