VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "InterfaceKit -Simple example"
   ClientHeight    =   5325
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6015
   LinkTopic       =   "Form1"
   ScaleHeight     =   5325
   ScaleWidth      =   6015
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox chkOn 
      Caption         =   "Turn on all outputs"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   4800
      Width           =   1935
   End
   Begin VB.TextBox Text1 
      Height          =   4335
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   360
      Width           =   5655
   End
   Begin VB.Label Label2 
      Caption         =   "Log of input, output and sensor event"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   120
      Width           =   4455
   End
   Begin VB.Label Label1 
      Caption         =   "Label1"
      Height          =   135
      Left            =   2880
      TabIndex        =   1
      Top             =   960
      Width           =   15
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     InterfaceKit-Simple

' Description:
' - Lets you turn on all digital outputs
' - Displays as an event log all input/output/sensor events.
Option Explicit
Dim WithEvents phidgetIFK As PhidgetInterfaceKit
Attribute phidgetIFK.VB_VarHelpID = -1

Private Sub Form_Load()
    Set phidgetIFK = Controls.Add("Phidget21COM.PhidgetInterfaceKit", "phidgetIFK")   'Get the phidget manager going
    chkOn.Enabled = False         'interactive only when the phidget is attached
    phidgetIFK.Open
End Sub

'Toggle all outputs on or off.
Private Sub chkOn_Click()
    Dim I As Long
    Dim state As Boolean
    If chkOn.Value = Checked Then state = True Else state = False
    For I = 0 To phidgetIFK.OutputCount - 1
        phidgetIFK.OutputState(I) = state
    Next I
End Sub

'An InterfaceKit was found. Start everything up
Private Sub phidgetIFK_OnAttach()
    Dim I As Long
    'make the sensors less sensitive so that we don't get flooded with events
    For I = 0 To phidgetIFK.SensorCount - 1
        phidgetIFK.SensorChangeTrigger(I) = 30
    Next I
    chkOn.Enabled = True
End Sub

'The Interface kit was detached. Clean up, and stop polling.
Private Sub phidgetIFK_OnDetach()
    chkOn.Enabled = False
End Sub

'Report the value of the input whenever it changes
Private Sub phidgetIFK_OnInputChange(ByVal Index As Long, ByVal NewState As Boolean)
    Display " Input " & Index & " = " & NewState
End Sub

'Report the value of the output whenever it changes
Private Sub phidgetIFK_OnOutputChange(ByVal Index As Long, ByVal NewState As Boolean)
    Display "Output " & Index & " = " & NewState
End Sub

'Report the value of the sensor whenever it changes
Private Sub phidgetIFK_OnSensorChange(ByVal Index As Long, ByVal SensorValue As Long)
    Display "Sensor " & Index & " = " & SensorValue
End Sub

Private Sub Display(Entry As String)
    Text1.Text = Entry & vbCrLf & Text1.Text
End Sub


