VERSION 5.00
Object = "{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}#1.1#0"; "shdocvw.dll"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6435
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   14355
   LinkTopic       =   "Form1"
   ScaleHeight     =   6435
   ScaleWidth      =   14355
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame2 
      Caption         =   "Map"
      Height          =   6135
      Left            =   4800
      TabIndex        =   26
      Top             =   120
      Width           =   9375
      Begin SHDocVwCtl.WebBrowser WebBrowser1 
         Height          =   5055
         Left            =   360
         TabIndex        =   28
         Top             =   960
         Width           =   8655
         ExtentX         =   15266
         ExtentY         =   8916
         ViewMode        =   0
         Offline         =   0
         Silent          =   0
         RegisterAsBrowser=   0
         RegisterAsDropTarget=   1
         AutoArrange     =   0   'False
         NoClientEdge    =   0   'False
         AlignLeft       =   0   'False
         NoWebView       =   0   'False
         HideFileNames   =   0   'False
         SingleClick     =   0   'False
         SingleSelection =   0   'False
         NoFolders       =   0   'False
         Transparent     =   0   'False
         ViewID          =   "{0057D0E0-3573-11CF-AE69-08002B2E1262}"
         Location        =   "http:///"
      End
      Begin VB.CommandButton Command1 
         Caption         =   "Show Current Location on Map(Requires IE7 or higher)"
         Height          =   495
         Left            =   360
         TabIndex        =   27
         Top             =   360
         Width           =   2415
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "GPS Data"
      Height          =   3495
      Left            =   175
      TabIndex        =   10
      Top             =   2760
      Width           =   4455
      Begin VB.TextBox dateF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   25
         Top             =   3015
         Width           =   2500
      End
      Begin VB.TextBox timeF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   23
         Top             =   2630
         Width           =   2500
      End
      Begin VB.TextBox velocityF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   21
         Top             =   2245
         Width           =   2500
      End
      Begin VB.TextBox headingF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   20
         Top             =   1860
         Width           =   2500
      End
      Begin VB.CheckBox fixCheckBox 
         Caption         =   "Fix Acquired"
         Height          =   255
         Left            =   360
         TabIndex        =   17
         Top             =   360
         Width           =   1455
      End
      Begin VB.TextBox altitudeF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   16
         Top             =   1475
         Width           =   2500
      End
      Begin VB.TextBox longitudeF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         TabIndex        =   14
         Top             =   1090
         Width           =   2500
      End
      Begin VB.TextBox latitudeF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   12
         Top             =   705
         Width           =   2500
      End
      Begin VB.Label Label11 
         Caption         =   "Date:"
         Height          =   255
         Left            =   360
         TabIndex        =   24
         Top             =   3015
         Width           =   735
      End
      Begin VB.Label Label10 
         Caption         =   "Time(UTC):"
         Height          =   255
         Left            =   360
         TabIndex        =   22
         Top             =   2625
         Width           =   975
      End
      Begin VB.Label Velocity 
         Caption         =   "Velocity(km/h):"
         Height          =   255
         Left            =   360
         TabIndex        =   19
         Top             =   2250
         Width           =   1095
      End
      Begin VB.Label Label9 
         Caption         =   "Heading:"
         Height          =   375
         Left            =   360
         TabIndex        =   18
         Top             =   1860
         Width           =   855
      End
      Begin VB.Label Label8 
         Caption         =   "Altitude(m):"
         Height          =   255
         Left            =   360
         TabIndex        =   15
         Top             =   1475
         Width           =   855
      End
      Begin VB.Label Label7 
         Caption         =   "Longitude:"
         Height          =   375
         Left            =   360
         TabIndex        =   13
         Top             =   1090
         Width           =   855
      End
      Begin VB.Label Label6 
         Caption         =   "Latitude:"
         Height          =   255
         Left            =   360
         TabIndex        =   11
         Top             =   705
         Width           =   1215
      End
   End
   Begin VB.Frame Details 
      Caption         =   "GPS Details"
      Height          =   2535
      Left            =   175
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      Begin VB.TextBox versionF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   4
         Top             =   2030
         Width           =   2500
      End
      Begin VB.TextBox serialF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   3
         Top             =   1645
         Width           =   2500
      End
      Begin VB.TextBox nameF 
         BackColor       =   &H8000000F&
         Height          =   800
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   2
         Top             =   745
         Width           =   2500
      End
      Begin VB.TextBox attachF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   1
         Top             =   360
         Width           =   2500
      End
      Begin VB.Label Label5 
         Caption         =   "Version:"
         Height          =   285
         Left            =   360
         TabIndex        =   9
         Top             =   2030
         Width           =   735
      End
      Begin VB.Label Label4 
         Caption         =   "Serial No:"
         Height          =   285
         Left            =   360
         TabIndex        =   8
         Top             =   1645
         Width           =   735
      End
      Begin VB.Label Label3 
         Caption         =   "Name:"
         Height          =   285
         Left            =   360
         TabIndex        =   7
         Top             =   745
         Width           =   731
      End
      Begin VB.Label Label2 
         Caption         =   "Label2"
         Height          =   15
         Left            =   480
         TabIndex        =   6
         Top             =   720
         Width           =   2895
      End
      Begin VB.Label Label1 
         Caption         =   "Attached:"
         Height          =   285
         Left            =   360
         TabIndex        =   5
         Top             =   360
         Width           =   855
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     GPS-full

' Description:
' -This example:
'    o displays information about the PhidgetGPS
'    o GPS Data is updated everytime the position is changed
'    o shows the current location(as seen by the PhidgetGPS) on Google Maps(requires the Microsoft Internet Controls Component and an Internet connnection)

Option Explicit
Dim WithEvents PhidgetGPS As PhidgetGPS
Attribute PhidgetGPS.VB_VarHelpID = -1

Private Sub Form_Load()
    Set PhidgetGPS = Controls.Add("Phidget21COM.PhidgetGPS", "phidgetGPS")
    PhidgetGPS.Open
    attachF.Text = PhidgetGPS.IsAttached
    
    'initialize map URL
    WebBrowser1.Navigate "http://maps.google.com/maps?q=0%2C0&output=embed"
 
End Sub

Private Sub PhidgetGPS_OnAttach()
    DisplayDetails
    DisplayGPSData
End Sub

Private Sub PhidgetGPS_OnDetach()
    attachF.Text = "False"
    nameF.Text = ""
    serialF.Text = ""
    versionF.Text = ""
    latitudeF.Text = ""
    longitudeF.Text = ""
    altitudeF.Text = ""
    headingF.Text = ""
    velocityF.Text = ""
    timeF.Text = ""
    dateF.Text = ""
    fixCheckBox.Value = 0
    WebBrowser1.Navigate "http://maps.google.com/maps?q=0%2C0&output=embed"
  
End Sub

Private Sub Command1_Click()
     'refresh the map if the PhidgetGPS is attached
     If (PhidgetGPS.IsAttached) Then
             DisplayMap
     End If

End Sub

'Display the properties of the device
Private Sub DisplayDetails()
    attachF.Text = PhidgetGPS.IsAttached
    nameF.Text = PhidgetGPS.DeviceName
    serialF.Text = PhidgetGPS.SerialNumber
    versionF.Text = PhidgetGPS.DeviceVersion
End Sub

Private Sub DisplayGPSData()
    latitudeF.Text = PhidgetGPS.Latitude
    longitudeF.Text = PhidgetGPS.Longitude
    altitudeF.Text = PhidgetGPS.Altitude
    headingF.Text = PhidgetGPS.Heading
    velocityF.Text = PhidgetGPS.Velocity
    timeF.Text = PhidgetGPS.Time.tm_hour & ":" & PhidgetGPS.Time.tm_min & ":" & PhidgetGPS.Time.tm_sec & ":" & PhidgetGPS.Time.tm_ms
    dateF.Text = PhidgetGPS.Date.tm_mday & "/" & PhidgetGPS.Date.tm_mon & "/" & PhidgetGPS.Date.tm_year
End Sub

Private Sub DisplayMap()
    WebBrowser1.Navigate parseQuery
End Sub

'parses the URL
Private Function parseQuery()
    parseQuery = "http://maps.google.com/maps?q="
    parseQuery = parseQuery & PhidgetGPS.Latitude & "%2C" & PhidgetGPS.Longitude
    parseQuery = parseQuery & "&output=embed"
End Function

Private Sub PhidgetGPS_OnPositionChange(ByVal Latitude As Double, ByVal Longitude As Double, ByVal Altitude As Double)
    DisplayGPSData
End Sub


Private Sub PhidgetGPS_OnPositionFixStatusChange(ByVal fixStatus As Boolean)
    If (fixStatus) Then
        fixCheckBox.Value = 1
    Else
        fixCheckBox.Value = 0
    End If
End Sub
