VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   7560
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4995
   LinkTopic       =   "Form1"
   ScaleHeight     =   7560
   ScaleWidth      =   4995
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame2 
      Caption         =   "Frequency Data"
      Height          =   4095
      Left            =   175
      TabIndex        =   12
      Top             =   3240
      Width           =   4635
      Begin VB.CommandButton setTimeoutCmd 
         Caption         =   "Set Timeout"
         Enabled         =   0   'False
         Height          =   285
         Left            =   3240
         TabIndex        =   32
         Top             =   1140
         Width           =   1215
      End
      Begin VB.CommandButton resetCmd 
         Caption         =   "Reset Total Count and Time"
         Enabled         =   0   'False
         Height          =   735
         Left            =   2400
         TabIndex        =   31
         Top             =   3240
         Width           =   1935
      End
      Begin VB.TextBox timeoutF 
         Enabled         =   0   'False
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   30
         Top             =   1140
         Width           =   1425
      End
      Begin VB.TextBox totalTimeF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   28
         Top             =   2820
         Width           =   2500
      End
      Begin VB.TextBox totalCountF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   27
         Top             =   2400
         Width           =   2500
      End
      Begin VB.TextBox frequencyF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   26
         Top             =   1980
         Width           =   2500
      End
      Begin VB.TextBox pulseEventF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   3240
         Locked          =   -1  'True
         TabIndex        =   21
         Top             =   1560
         Width           =   800
      End
      Begin VB.TextBox countEventF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   19
         Top             =   1560
         Width           =   800
      End
      Begin VB.ComboBox filterType 
         Enabled         =   0   'False
         Height          =   315
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   17
         Top             =   720
         Width           =   2500
      End
      Begin VB.CheckBox enabledState 
         Caption         =   "Enabled"
         Enabled         =   0   'False
         Height          =   375
         Left            =   3120
         TabIndex        =   15
         Top             =   290
         Width           =   1095
      End
      Begin VB.ComboBox channelIndex 
         Enabled         =   0   'False
         Height          =   315
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   14
         Top             =   300
         Width           =   1100
      End
      Begin VB.Label Label15 
         Caption         =   "Timeout(ms)"
         Height          =   255
         Left            =   360
         TabIndex        =   29
         Top             =   1140
         Width           =   975
      End
      Begin VB.Label Label14 
         Caption         =   "Total Time (ms):"
         Height          =   495
         Left            =   360
         TabIndex        =   25
         Top             =   2820
         Width           =   1335
      End
      Begin VB.Label Label13 
         Caption         =   "Total Count:"
         Height          =   375
         Left            =   360
         TabIndex        =   24
         Top             =   2400
         Width           =   975
      End
      Begin VB.Label Label12 
         Caption         =   "Frquency (Hz):"
         Height          =   255
         Left            =   360
         TabIndex        =   23
         Top             =   1980
         Width           =   1095
      End
      Begin VB.Label Label11 
         Caption         =   "ms"
         Height          =   285
         Left            =   4080
         TabIndex        =   22
         Top             =   1605
         Width           =   360
      End
      Begin VB.Label Label10 
         Caption         =   "pulses in"
         Height          =   285
         Left            =   2520
         TabIndex        =   20
         Top             =   1610
         Width           =   735
      End
      Begin VB.Label Label9 
         Caption         =   "Count Events:"
         Height          =   375
         Left            =   360
         TabIndex        =   18
         Top             =   1560
         Width           =   1095
      End
      Begin VB.Label Label8 
         Caption         =   "Filter:"
         Height          =   255
         Left            =   360
         TabIndex        =   16
         Top             =   720
         Width           =   495
      End
      Begin VB.Label Label7 
         Caption         =   "Choose Channel:"
         Height          =   375
         Left            =   360
         TabIndex        =   13
         Top             =   360
         Width           =   1455
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Frequency Counter Details"
      Height          =   3015
      Left            =   175
      TabIndex        =   0
      Top             =   120
      Width           =   4635
      Begin VB.TextBox attachF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   5
         Top             =   360
         Width           =   2500
      End
      Begin VB.TextBox nameF 
         BackColor       =   &H8000000F&
         Height          =   800
         Left            =   1680
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   4
         Top             =   745
         Width           =   2500
      End
      Begin VB.TextBox serialF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   3
         Top             =   1645
         Width           =   2500
      End
      Begin VB.TextBox versionF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   2
         Top             =   2030
         Width           =   2500
      End
      Begin VB.TextBox numChannelsF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1680
         Locked          =   -1  'True
         TabIndex        =   1
         Top             =   2400
         Width           =   2500
      End
      Begin VB.Label Label1 
         Caption         =   "Attached:"
         Height          =   285
         Left            =   360
         TabIndex        =   11
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "Label2"
         Height          =   15
         Left            =   480
         TabIndex        =   10
         Top             =   720
         Width           =   2895
      End
      Begin VB.Label Label3 
         Caption         =   "Name:"
         Height          =   285
         Left            =   360
         TabIndex        =   9
         Top             =   745
         Width           =   731
      End
      Begin VB.Label Label4 
         Caption         =   "Serial No:"
         Height          =   285
         Left            =   360
         TabIndex        =   8
         Top             =   1645
         Width           =   735
      End
      Begin VB.Label Label5 
         Caption         =   "Version:"
         Height          =   285
         Left            =   360
         TabIndex        =   7
         Top             =   2030
         Width           =   735
      End
      Begin VB.Label Label6 
         Caption         =   "# Channels:"
         Height          =   285
         Left            =   360
         TabIndex        =   6
         Top             =   2400
         Width           =   855
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     FrequencyCounter-full

' Description:
' -This example:
'    o displays information about the PhidgetFrequencyCounter.
'    o allows user to choose between zero crossing and logic level filters.
'    o allows user to set timeout and reset total count/time

Option Explicit
Dim WithEvents PhidgetFrequencyCounter As PhidgetFrequencyCounter
Attribute PhidgetFrequencyCounter.VB_VarHelpID = -1

Private Sub Form_Load()
    Set PhidgetFrequencyCounter = Controls.Add("Phidget21COM.PhidgetFrequencyCounter", "phidgetFrequencyCounter")
    PhidgetFrequencyCounter.Open
    attachF.Text = PhidgetFrequencyCounter.IsAttached
End Sub

Private Sub PhidgetFrequencyCounter_OnAttach()
    
    Dim i As Long
    
    enabledState.Enabled = True
    channelIndex.Enabled = True
    channelIndex.Locked = False
    filterType.Locked = False
    timeoutF.Locked = False
  
    DisplayDetails
    
    For i = 0 To PhidgetFrequencyCounter.FrequencyInputCount - 1
        channelIndex.AddItem (i)
    Next i
    
    channelIndex = 0
    
    If (PhidgetFrequencyCounter.Enabled(channelIndex)) Then
        enabledState.Value = 1
    Else
        enabledState.Value = 0
    End If
   
    filterType.AddItem ("ZERO_CROSSING")
    filterType.AddItem ("LOGIC_LEVEL")
    
    filterType = "ZERO_CROSSING"

    PhidgetFrequencyCounter.Filter(channelIndex) = PHIDGETCOM_FREQUENCYCOUNTER_FILTERTYPE_ZERO_CROSSING
    
    timeoutF.Text = PhidgetFrequencyCounter.Timeout(channelIndex) / 1000
    
    frequencyF.Text = PhidgetFrequencyCounter.Frequency(channelIndex)
    totalCountF.Text = PhidgetFrequencyCounter.TotalCount(channelIndex)
    totalTimeF.Text = PhidgetFrequencyCounter.TotalTime(channelIndex)
  
       If (enabledState.Value = 0) Then
        PhidgetFrequencyCounter.Enabled(channelIndex) = False
        filterType.Enabled = False
        setTimeoutCmd.Enabled = False
        resetCmd.Enabled = False
          timeoutF.Enabled = False
    Else
        PhidgetFrequencyCounter.Enabled(channelIndex) = True
        filterType.Enabled = True
        setTimeoutCmd.Enabled = True
        resetCmd.Enabled = True
          timeoutF.Enabled = True
    End If
End Sub

Private Sub PhidgetFrequencyCounter_OnDetach()
    attachF.Text = "False"
    nameF.Text = ""
    serialF.Text = ""
    versionF.Text = ""
    numChannelsF.Text = ""
    enabledState.Value = 0
    enabledState.Enabled = False
    channelIndex.Clear
    filterType.Clear
    timeoutF.Text = ""
    setTimeoutCmd.Enabled = False
    countEventF.Text = ""
    pulseEventF.Text = ""
    frequencyF.Text = ""
    totalCountF.Text = ""
    totalTimeF.Text = ""
    resetCmd.Enabled = False
End Sub

Private Sub PhidgetFrequencyCounter_OnCount(ByVal Index As Long, ByVal Time As Long, ByVal Counts As Long)
    If (channelIndex = Index) Then
        countEventF.Text = Counts
        pulseEventF.Text = Time / 1000
        frequencyF.Text = PhidgetFrequencyCounter.Frequency(channelIndex)
        totalCountF.Text = PhidgetFrequencyCounter.TotalCount(channelIndex)
        totalTimeF.Text = PhidgetFrequencyCounter.TotalTime(channelIndex)
    End If
End Sub

Private Sub channelIndex_Click()
   If (PhidgetFrequencyCounter.Enabled(channelIndex)) Then
        enabledState.Value = 1
   Else
        enabledState.Value = 0
   End If
   
 Select Case PhidgetFrequencyCounter.Filter(channelIndex)
        Case PHIDGETCOM_FREQUENCYCOUNTER_FILTERTYPE_ZERO_CROSSING:
            filterType = "ZERO_CROSSING"
        Case PHIDGETCOM_FREQUENCYCOUNTER_FILTERTYPE_LOGIC_LEVEL:
            filterType = "LOGIC_LEVEL":
    End Select
       
   timeoutF.Text = PhidgetFrequencyCounter.Timeout(channelIndex) / 1000
   countEventF.Text = "0"
   pulseEventF.Text = "0"
   frequencyF.Text = PhidgetFrequencyCounter.Frequency(channelIndex)
   totalCountF.Text = PhidgetFrequencyCounter.TotalCount(channelIndex)
   totalTimeF.Text = PhidgetFrequencyCounter.TotalTime(channelIndex)
      
End Sub

Private Sub resetCmd_Click()
    PhidgetFrequencyCounter.Reset (channelIndex)
    totalCountF.Text = 0
    totalTimeF.Text = 0
End Sub

Private Sub enabledState_Click()
   If (enabledState.Value = 0) Then
        PhidgetFrequencyCounter.Enabled(channelIndex) = False
        filterType.Enabled = False
        setTimeoutCmd.Enabled = False
        resetCmd.Enabled = False
        timeoutF.Enabled = False
    Else
        PhidgetFrequencyCounter.Enabled(channelIndex) = True
        filterType.Enabled = True
        setTimeoutCmd.Enabled = True
        resetCmd.Enabled = True
        timeoutF.Enabled = True
    End If
End Sub

Private Sub filterType_Click()
   Select Case filterType
        Case "ZERO_CROSSING":
            PhidgetFrequencyCounter.Filter(channelIndex) = PHIDGETCOM_FREQUENCYCOUNTER_FILTERTYPE_ZERO_CROSSING
        Case "LOGIC_LEVEL":
            PhidgetFrequencyCounter.Filter(channelIndex) = PHIDGETCOM_FREQUENCYCOUNTER_FILTERTYPE_LOGIC_LEVEL
    End Select
End Sub

'Display the properties of the device
Private Sub DisplayDetails()
    Dim i As Integer
    attachF.Text = PhidgetFrequencyCounter.IsAttached
    nameF.Text = PhidgetFrequencyCounter.DeviceName
    serialF.Text = PhidgetFrequencyCounter.SerialNumber
    versionF.Text = PhidgetFrequencyCounter.DeviceVersion
    numChannelsF.Text = PhidgetFrequencyCounter.FrequencyInputCount
    
End Sub

Private Sub setTimeoutCmd_Click()
    On Error GoTo errorSetTimeout
        PhidgetFrequencyCounter.Timeout(channelIndex) = timeoutF.Text * 1000
    Exit Sub
errorSetTimeout:
        MsgBox ("Please set a value between 100-100000 milliseconds")
 

End Sub
