VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4860
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4875
   LinkTopic       =   "Form1"
   ScaleHeight     =   4860
   ScaleWidth      =   4875
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame channelOutput 
      Caption         =   "Channel Output"
      Height          =   1455
      Left            =   175
      TabIndex        =   12
      Top             =   3240
      Width           =   4455
      Begin VB.CheckBox enable 
         Height          =   375
         Index           =   0
         Left            =   3800
         TabIndex        =   17
         Top             =   850
         Width           =   375
      End
      Begin VB.TextBox voltageF 
         BackColor       =   &H8000000F&
         Height          =   285
         Index           =   0
         Left            =   2780
         Locked          =   -1  'True
         TabIndex        =   16
         Text            =   "0"
         Top             =   850
         Width           =   600
      End
      Begin MSComctlLib.Slider voltageSlider 
         Height          =   675
         Index           =   0
         Left            =   360
         TabIndex        =   15
         Top             =   720
         Width           =   2055
         _ExtentX        =   3625
         _ExtentY        =   1191
         _Version        =   393216
         TickFrequency   =   500
      End
      Begin VB.Label channelNumL 
         Caption         =   "Channel 1"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   18
         Top             =   460
         Width           =   1665
      End
      Begin VB.Label Label9 
         Caption         =   "Enabled"
         Height          =   255
         Left            =   3600
         TabIndex        =   14
         Top             =   460
         Width           =   735
      End
      Begin VB.Label Label8 
         Caption         =   "Voltage(V)"
         Height          =   375
         Left            =   2640
         TabIndex        =   13
         Top             =   460
         Width           =   855
      End
   End
   Begin VB.Frame Details 
      Caption         =   "Analog Details"
      Height          =   3015
      Left            =   175
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      Begin VB.TextBox attachF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   5
         Top             =   360
         Width           =   2500
      End
      Begin VB.TextBox nameF 
         BackColor       =   &H8000000F&
         Height          =   800
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   4
         Top             =   745
         Width           =   2500
      End
      Begin VB.TextBox serialF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   3
         Top             =   1645
         Width           =   2500
      End
      Begin VB.TextBox versionF 
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000007&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   2
         Top             =   2030
         Width           =   2500
      End
      Begin VB.TextBox numChannelsF 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   1560
         Locked          =   -1  'True
         TabIndex        =   1
         Top             =   2400
         Width           =   2500
      End
      Begin VB.Label Label1 
         Caption         =   "Attached:"
         Height          =   285
         Left            =   360
         TabIndex        =   11
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "Label2"
         Height          =   15
         Left            =   480
         TabIndex        =   10
         Top             =   720
         Width           =   2895
      End
      Begin VB.Label Label3 
         Caption         =   "Name:"
         Height          =   285
         Left            =   360
         TabIndex        =   9
         Top             =   745
         Width           =   731
      End
      Begin VB.Label Label4 
         Caption         =   "Serial No:"
         Height          =   285
         Left            =   360
         TabIndex        =   8
         Top             =   1645
         Width           =   735
      End
      Begin VB.Label Label5 
         Caption         =   "Version:"
         Height          =   285
         Left            =   360
         TabIndex        =   7
         Top             =   2030
         Width           =   735
      End
      Begin VB.Label Label6 
         Caption         =   "# Channels:"
         Height          =   285
         Left            =   360
         TabIndex        =   6
         Top             =   2400
         Width           =   855
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     Analog-full

' Description:
' -This example:
'    o displays information about the PhidgetAnalog
'    o allows user to change enable states and voltages

Option Explicit
Dim WithEvents PhidgetAnalog As PhidgetAnalog
Attribute PhidgetAnalog.VB_VarHelpID = -1

Private Sub Form_Load()
    Set PhidgetAnalog = Controls.Add("Phidget21COM.PhidgetAnalog", "phidgetAnalog")
    PhidgetAnalog.Open
    attachF.Text = PhidgetAnalog.IsAttached
 
End Sub

Private Sub PhidgetAnalog_OnAttach()
    
    'verifying if the the form and frame height needs to be adjusted
    If (channelNumL.Count < PhidgetAnalog.OutputCount) Then
        AdjustForm
        AdjustFrame
    End If
    
    DisplayDetails
    DisplayChannelOutput
    
End Sub

Private Sub PhidgetAnalog_OnDetach()
    Dim I As Long
    attachF.Text = "False"
    nameF.Text = ""
    serialF.Text = ""
    versionF.Text = ""
    numChannelsF.Text = ""

    For I = 0 To voltageSlider.Count - 1
        voltageSlider(I).Value = 0
        voltageSlider(I).Enabled = False
        voltageF(I).Text = 0
        voltageF(I).Enabled = False
        enable(I).Value = 0
        enable(I).Enabled = False
    Next I

End Sub

Private Sub enable_Click(Index As Integer)
If (enable(Index).Value = 0) Then
        PhidgetAnalog.Enabled((Index)) = False
    Else
        PhidgetAnalog.Enabled((Index)) = True
    End If
    
End Sub

Private Sub voltageSlider_MouseMove(Index As Integer, Button As Integer, Shift As Integer, x As Single, y As Single)
    PhidgetAnalog.Voltage(Index) = voltageSlider(Index).Value / 100
    voltageF(Index).Text = voltageSlider(Index).Value / 100
End Sub

'Display the properties of the device
Private Sub DisplayDetails()
    Dim I As Integer
    attachF.Text = PhidgetAnalog.IsAttached
    nameF.Text = PhidgetAnalog.DeviceName
    serialF.Text = PhidgetAnalog.SerialNumber
    versionF.Text = PhidgetAnalog.DeviceVersion
    numChannelsF.Text = PhidgetAnalog.OutputCount
End Sub

Private Sub DisplayChannelOutput()
    Dim I As Long
    For I = 0 To PhidgetAnalog.OutputCount - 1
        
        'load the control if it does not exist
        If (I >= channelNumL.Count) Then
            Load channelNumL(I)
            Load voltageSlider(I)
            Load voltageF(I)
            Load enable(I)
        End If
        
        With channelNumL(I)
             .Visible = True
             .Caption = "Channel " & (I + 1)
             .Top = 460 + I * 1000
        End With

        With voltageSlider(I)
             .Enabled = True
             .Visible = True
             .Value = 0
             .Top = 720 + I * 1000
             .Max = PhidgetAnalog.VoltageMax(I) * 100
             .Min = PhidgetAnalog.VoltageMin(I) * 100
             .Value = PhidgetAnalog.Voltage(I) * 100
        End With
      
        With voltageF(I)
             .Enabled = True
             .Visible = True
             .Text = 0
             .Top = 720 + I * 1000
             .Text = PhidgetAnalog.Voltage(I)
        End With
        
        With enable(I)
             .Enabled = True
             .Visible = True
             .Value = 0
             .Top = 720 + I * 1000
             If (PhidgetAnalog.Enabled(I)) Then
                .Value = 1
            Else
                .Value = 0
            End If
        End With
    
    Next I
End Sub

Private Sub AdjustForm()
    Form1.Height = Form1.Height + (PhidgetAnalog.OutputCount - 1) * 1000
End Sub

Private Sub AdjustFrame()
    channelOutput.Height = channelOutput.Height + (PhidgetAnalog.OutputCount - 1) * 1000
End Sub
