VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "StepperSlider: Example of a PhidgetStepper program"
   ClientHeight    =   5055
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6870
   LinkTopic       =   "Form1"
   ScaleHeight     =   5055
   ScaleWidth      =   6870
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Motor 0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3615
      Left            =   120
      TabIndex        =   6
      Top             =   1320
      Width           =   6615
      Begin VB.CheckBox StoppedCheck 
         Caption         =   "Stopped"
         Enabled         =   0   'False
         Height          =   375
         Left            =   4560
         TabIndex        =   14
         Top             =   3000
         Width           =   975
      End
      Begin VB.CheckBox EngagedCheck 
         Caption         =   "Engaged"
         Height          =   375
         Left            =   480
         TabIndex        =   13
         Top             =   2280
         Width           =   1215
      End
      Begin MSComctlLib.Slider PositionSlider 
         Height          =   495
         Left            =   1320
         TabIndex        =   12
         Top             =   1680
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   873
         _Version        =   393216
         LargeChange     =   1000
         Min             =   -20000
         Max             =   20000
         TickFrequency   =   1000
      End
      Begin MSComctlLib.Slider VelocitySlider 
         Height          =   495
         Left            =   1320
         TabIndex        =   7
         Top             =   480
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   873
         _Version        =   393216
         Min             =   -23
         Max             =   200
         SelStart        =   90
         TickFrequency   =   100
         Value           =   90
      End
      Begin MSComctlLib.Slider AccelSlider 
         Height          =   495
         Left            =   1320
         TabIndex        =   8
         Top             =   1080
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   873
         _Version        =   393216
         Min             =   -23
         Max             =   200
         SelStart        =   90
         TickFrequency   =   500
         Value           =   90
      End
      Begin VB.Label CurrentVelocity 
         Height          =   255
         Left            =   1920
         TabIndex        =   18
         Top             =   3240
         Width           =   1935
      End
      Begin VB.Label CurrentPosition 
         Height          =   255
         Left            =   1920
         TabIndex        =   17
         Top             =   2880
         Width           =   1935
      End
      Begin VB.Label Label8 
         Caption         =   "Current Velocity:"
         Height          =   255
         Left            =   360
         TabIndex        =   16
         Top             =   3240
         Width           =   1215
      End
      Begin VB.Label Label7 
         Caption         =   "Current Position:"
         Height          =   255
         Left            =   360
         TabIndex        =   15
         Top             =   2880
         Width           =   1215
      End
      Begin VB.Label Label6 
         Caption         =   "Position:"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   1680
         Width           =   975
      End
      Begin VB.Label Label5 
         Caption         =   "Acceleration:"
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   1080
         Width           =   1095
      End
      Begin VB.Label Label1 
         Caption         =   "Velocity Limit:"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   480
         Width           =   975
      End
   End
   Begin VB.Label lblSerialNumber 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   5
      Top             =   840
      Width           =   1935
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Serial Number:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   840
      Width           =   2055
   End
   Begin VB.Label lblNumMotors 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   3
      Top             =   480
      Width           =   1935
   End
   Begin VB.Label label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Number of Motors:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   480
      Width           =   2175
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Status:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   135
      TabIndex        =   1
      Top             =   120
      Width           =   2160
   End
   Begin VB.Label lblMessage 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   0
      Top             =   120
      Width           =   3720
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     MotorSlider

' Description:
' -This example:
'    o lets a user interactively adjust the angle of all motors through a slider
'    o displays all the information it can about the PhidgetMotorControl.
'    o is somewhat robust about ignoring other PhidgetMotorControls that are attached
'

Option Explicit
Dim WithEvents Stepper As PhidgetStepper
Attribute Stepper.VB_VarHelpID = -1

Private Sub AccelSlider_Click()
    Stepper.Acceleration(0) = AccelSlider.Value
End Sub

Private Sub EngagedCheck_Click()
    Stepper.Engaged(0) = EngagedCheck.Value
End Sub

Private Sub Form_Load()
    lblMessage.Caption = "Attach a PhidgetStepper"
    Set Stepper = New PhidgetStepper
    Stepper.Open
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Stepper.Engaged(0) = False
End Sub

Private Sub PositionSlider_Click()
    Stepper.TargetPosition(0) = PositionSlider.Value
End Sub

Private Sub Stepper_OnAttach()
    'Show the current Motor information
    lblMessage.Caption = "PhidgetStepper Attached"
    lblNumMotors.Caption = Stepper.MotorCount
    lblSerialNumber.Caption = Stepper.SerialNumber
    
    VelocitySlider.Min = Stepper.VelocityMin(0)
    VelocitySlider.Max = Stepper.VelocityMax(0)
    AccelSlider.Min = Stepper.AccelerationMin(0)
    AccelSlider.Max = Stepper.AccelerationMax(0)
End Sub

Private Sub Stepper_OnDetach()
    'Show the current Motor information
    lblMessage.Caption = "Attach a PhidgetStepper"
    lblNumMotors.Caption = ""
    lblSerialNumber.Caption = ""
End Sub

Private Sub Stepper_OnPositionChange(ByVal Index As Long, ByVal newVal As Long)
    If Index = 0 Then
        CurrentPosition.Caption = newVal
        If Stepper.Stopped(0) = True Then
            StoppedCheck.Value = 1
        Else
            StoppedCheck.Value = 0
        End If
    End If
End Sub

Private Sub Stepper_OnVelocityChange(ByVal Index As Long, ByVal newVal As Double)
    If Index = 0 Then
        CurrentVelocity.Caption = newVal
        If Stepper.Stopped(0) = True Then
            StoppedCheck.Value = 1
        Else
            StoppedCheck.Value = 0
        End If
    End If
End Sub

Private Sub VelocitySlider_Click()
    Stepper.VelocityLimit(0) = VelocitySlider.Value
End Sub
