VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "MotorSlider: Example of a PhidgetMotorControl program"
   ClientHeight    =   6510
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6960
   LinkTopic       =   "Form1"
   ScaleHeight     =   6510
   ScaleWidth      =   6960
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "ReverseDirection"
      Height          =   615
      Left            =   120
      TabIndex        =   17
      Top             =   5760
      Width           =   2535
   End
   Begin VB.Frame Frame2 
      Caption         =   "Set accel of all motors using the slider"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   120
      TabIndex        =   15
      Top             =   4440
      Width           =   5415
      Begin MSComctlLib.Slider sldrAccel 
         Height          =   495
         Left            =   270
         TabIndex        =   16
         Top             =   360
         Width           =   4935
         _ExtentX        =   8705
         _ExtentY        =   873
         _Version        =   393216
         Min             =   -23
         Max             =   200
         SelStart        =   90
         TickFrequency   =   20
         Value           =   90
      End
   End
   Begin VB.Frame frmDigitalInput 
      Caption         =   "Inputs"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Index           =   1
      Left            =   120
      TabIndex        =   10
      Top             =   3480
      Width           =   3135
      Begin VB.Label lblInputDigital 
         Caption         =   "Off"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   1
         Left            =   960
         TabIndex        =   14
         Top             =   360
         Width           =   675
      End
      Begin VB.Label lblInputDigital 
         Caption         =   "Off"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   2
         Left            =   1680
         TabIndex        =   13
         Top             =   360
         Width           =   675
      End
      Begin VB.Label lblInputDigital 
         Caption         =   "Off"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   3
         Left            =   2400
         TabIndex        =   12
         Top             =   360
         Width           =   675
      End
      Begin VB.Label lblInputDigital 
         Caption         =   "Off"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   11
         Top             =   360
         Width           =   675
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Set speed of all motors using the slider"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   120
      TabIndex        =   8
      Top             =   120
      Width           =   5415
      Begin MSComctlLib.Slider sldrSpeed 
         Height          =   495
         Left            =   270
         TabIndex        =   9
         Top             =   480
         Width           =   4935
         _ExtentX        =   8705
         _ExtentY        =   873
         _Version        =   393216
         Min             =   -23
         Max             =   200
         SelStart        =   90
         TickFrequency   =   20
         Value           =   90
      End
   End
   Begin VB.Label lblError 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2400
      TabIndex        =   19
      Top             =   2880
      Width           =   3255
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Latest Error:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   720
      TabIndex        =   18
      Top             =   2880
      Width           =   1575
   End
   Begin VB.Label lblSerialNumber 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   7
      Top             =   2520
      Width           =   1935
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Serial Number:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   135
      TabIndex        =   6
      Top             =   2520
      Width           =   2175
   End
   Begin VB.Label lblNumMotors 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   5
      Top             =   2160
      Width           =   1935
   End
   Begin VB.Label label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Number of Motors:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   135
      TabIndex        =   4
      Top             =   2160
      Width           =   2175
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Status:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   735
      TabIndex        =   3
      Top             =   1440
      Width           =   1575
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Current Speed %:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   375
      TabIndex        =   2
      Top             =   1800
      Width           =   1935
   End
   Begin VB.Label lblMessage 
      Caption         =   "x"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   1
      Top             =   1440
      Width           =   3720
   End
   Begin VB.Label lblSpeed 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   0
      Top             =   1800
      Width           =   1935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     MotorSlider

' Description:
' -This example:
'    o lets a user interactively adjust the angle of all motors through a slider
'    o displays all the information it can about the PhidgetMotorControl.
'    o is somewhat robust about ignoring other PhidgetMotorControls that are attached
'

Option Explicit
Dim WithEvents Motor As PhidgetMotorControl
Attribute Motor.VB_VarHelpID = -1

Private Sub Command1_Click()
sldrSpeed.Value = -1 * sldrSpeed.Value
Call sldrSpeed_Scroll
End Sub

Private Sub Form_Load()
    
    lblMessage.Caption = "Attach a PhidgetMotorControl"
    Frame1.Visible = False
    sldrSpeed.Min = -100
    sldrSpeed.Max = 100
    sldrSpeed.TickFrequency = 10
    Frame2.Visible = False
    sldrAccel.Min = 0
    sldrAccel.Max = 100
    sldrAccel.TickFrequency = 10
    
    Set Motor = New PhidgetMotorControl
    Motor.Open

End Sub


Private Sub Form_Unload(Cancel As Integer)
    Motor.MotorSpeed(0) = 0
    Motor.MotorSpeed(1) = 0
    
End Sub

Private Sub Motor_OnError(ByVal Description As String, ByVal SCODE As Long)
    lblError.Caption = Description
    
End Sub

'MOTOR ATTACHING
Private Sub Motor_OnAttach()
        
    'Set up the slider
    Frame1.Visible = True
    Frame2.Visible = True
    sldrSpeed.Value = 0
    sldrAccel.Value = 50
    sldrSpeed_Scroll 'Will rotate the motors to angle 0
    sldrAccel_Scroll
    
    'Show the current Motor information
    lblMessage.Caption = "PhidgetMotorControl Attached"
    lblNumMotors.Caption = Motor.MotorCount
    lblSerialNumber.Caption = Motor.SerialNumber
    
End Sub

'MOTOR DETACHING: Clean up.
Private Sub PhidgetManager_OnDetach()
    'Show the current Motor information
    lblMessage.Caption = "Attach a PhidgetMotorControl "
    lblNumMotors.Caption = ""
    lblSerialNumber.Caption = ""
    Frame1.Visible = False
End Sub

Private Sub Motor_OnVelocityChange(ByVal Index As Long, ByVal newVal As Double)
        If (Index = 0) Then
            lblSpeed.Caption = newVal
        End If
End Sub

Private Sub sldrSpeed_Scroll()
    Dim Index As Long
    For Index = 0 To Motor.MotorCount - 1
        Motor.Velocity(Index) = sldrSpeed.Value
    Next Index
End Sub


'Report the value of the input whenever it changes
Private Sub Motor_OnInputChange(ByVal Index As Long, ByVal NewState As Boolean)
    If (Index >= lblInputDigital.Count) Then Exit Sub
    
    If NewState Then
        lblInputDigital(Index).Caption = "On"
    Else
        lblInputDigital(Index).Caption = "Off"
    End If
End Sub
Private Sub sldrAccel_Scroll()
    Dim Index As Long
    For Index = 0 To Motor.MotorCount - 1
        Motor.Acceleration(Index) = sldrAccel.Value
    Next Index
End Sub


