VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Accelerometer Example"
   ClientHeight    =   5970
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5790
   LinkTopic       =   "Form1"
   ScaleHeight     =   5970
   ScaleWidth      =   5790
   StartUpPosition =   3  'Windows Default
   Begin VB.Label lblSerialNumber 
      Caption         =   "Serial Number"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   4200
      Width           =   3135
   End
   Begin VB.Label lblMessage 
      Caption         =   "Message"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3015
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     Accel_Simple

' Description:
' -This example:
'    o displays all the information it can about the PhidgetAccelerometer.
'    o is somewhat robust about ignoring other Phidgets that are attached
'
' Does some very simple filtering
' Displays the X and Y acceleration as a vector
' The circle displays the limits of a 1g acceleration vector.

Option Explicit
Dim WithEvents phidgetAccel As PhidgetAccelerometer
Attribute phidgetAccel.VB_VarHelpID = -1
Dim XFilt(0 To 6), YFilt(0 To 6), RFilt(0 To 6) As Double
Dim XOut, YOut, ROut As Double
Dim X1Old, Y1Old As Integer
Dim XCenter, YCenter As Integer


Private Sub phidgetAccel_OnAccelerationChange(ByVal Index As Long, ByVal Acceleration As Double)
    Dim I As Integer

    ' Erase the old line
    Form1.Line (XCenter, YCenter)-(X1Old, Y1Old), &H8000000F
    If phidgetAccel.AxisCount = 3 And ROut > 0 Then
        Form1.Circle (XCenter, YCenter), ROut * 1000, &H8000000F
    ElseIf phidgetAccel.AxisCount = 3 And ROut < 0 Then
        Form1.Circle (XCenter, YCenter), -ROut * 1000, &H8000000F
    End If
    
    ' We are performing a very simple low pass filter here.
    ' You don't have to use this, but for measuring things that
    ' change slowly, it's nice to filter the data a little more.
    If Index = 0 Then
        XOut = 0
        XFilt(6) = Acceleration
        For I = 0 To 5
            XFilt(I) = XFilt(I + 1)
            XOut = XOut + XFilt(I)
        Next I
        XOut = XOut / 6
    End If
    If Index = 1 Then
        YOut = 0
        YFilt(6) = Acceleration
        For I = 0 To 5
            YFilt(I) = YFilt(I + 1)
            YOut = YOut + YFilt(I)
        Next I
        YOut = YOut / 6
    End If
    If Index = 2 Then
        ROut = 0
        RFilt(6) = Acceleration
        For I = 0 To 5
            RFilt(I) = RFilt(I + 1)
            ROut = ROut + RFilt(I)
        Next I
        ROut = ROut / 6
    End If
    
    'Calculate the coordinates for the line
    'In the next event, we will erase this line.
    X1Old = XCenter - XOut * 1000
    Y1Old = YCenter + YOut * 1000
    Form1.Line (XCenter, YCenter)-(X1Old, Y1Old)
    Form1.Circle (XCenter, YCenter), 1000, vbBlue
    If phidgetAccel.AxisCount = 3 And ROut > 0 Then
        Form1.Circle (XCenter, YCenter), ROut * 1000, vbRed
    ElseIf phidgetAccel.AxisCount = 3 And ROut < 0 Then
        Form1.Circle (XCenter, YCenter), -ROut * 1000, vbGreen
    End If
    

End Sub

Private Sub phidgetAccel_OnDetach()
    lblMessage.Caption = "Attach a PhidgetAccelerometer "
    lblSerialNumber.Caption = ""
End Sub

Private Sub Form_Load()
    Set phidgetAccel = New PhidgetAccelerometer
    lblMessage.Caption = "Attach a PhidgetAccelerometer"
    Call phidgetAccel.Open
End Sub


'ACCELEROMETER ATTACHING
Private Sub phidgetAccel_OnAttach()

    Form1.DrawWidth = 2
    phidgetAccel.AccelerationChangeTrigger(0) = 0
    phidgetAccel.AccelerationChangeTrigger(1) = 0
    XCenter = Form1.ScaleWidth / 2
    YCenter = Form1.ScaleHeight / 2
    X1Old = XCenter
    Y1Old = YCenter
    'Show the current information
    lblMessage.Caption = "PhidgetAccelerometer Attached"
    lblSerialNumber.Caption = "SerialNumber : " & phidgetAccel.SerialNumber

End Sub

