VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "Phidget Dictionary"
   ClientHeight    =   4050
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5535
   LinkTopic       =   "Form1"
   ScaleHeight     =   4050
   ScaleWidth      =   5535
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.ListView lvStatus 
      Height          =   2595
      Left            =   0
      TabIndex        =   0
      Top             =   360
      Width           =   5535
      _ExtentX        =   9763
      _ExtentY        =   4577
      View            =   3
      Sorted          =   -1  'True
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      GridLines       =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.Label addressLabel 
      Height          =   255
      Left            =   840
      TabIndex        =   5
      Top             =   3120
      Width           =   2655
   End
   Begin VB.Label Label2 
      Caption         =   "Address:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   3120
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Attached:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   0
      TabIndex        =   3
      Top             =   0
      Width           =   975
   End
   Begin VB.Label statusLabel 
      Height          =   255
      Left            =   1080
      TabIndex        =   2
      Top             =   0
      Width           =   855
   End
   Begin VB.Label lblStatus 
      Caption         =   "Attached:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


Option Explicit
Private WithEvents Dict As Phidget21COM.PhidgetDictionary
Attribute Dict.VB_VarHelpID = -1
Private WithEvents Listener As Phidget21COM.PhidgetKeyListener
Attribute Listener.VB_VarHelpID = -1

Private Sub Dict_OnError(ByVal Description As String, ByVal SCODE As Long)

        MsgBox Description
        Unload Form1
        End
End Sub

Private Sub Form_Load()
    DisplayInitialize
    Dim res As Integer
    
    'Get the phidget manager going
    Set Dict = New Phidget21COM.PhidgetDictionary
    Set Listener = New Phidget21COM.PhidgetKeyListener
    
    Dict.OpenRemoteIP "mine.local", 5001
    
    If (Dict.IsAttached = False) Then
        MsgBox "Couldn't Connect to Dictionary Server"
        Unload Form1
        End
    End If
    
    Listener.Start Dict, ".*"
    
    statusLabel = Dict.IsAttached
    addressLabel = Dict.Address & ":" & Dict.Port
    
End Sub


Private Sub DisplayInitialize()
    Dim Divisions As Integer
   
    'Initialize the listview and properties (we could do this in the properties window instead)
    lvStatus.Sorted = True
    lvStatus.SortKey = 0
    lvStatus.SortOrder = lvwAscending
    lvStatus.View = lvwReport
    lvStatus.GridLines = True
   
    'Initialize the listview headers and column widths
    Divisions = 4
    lvStatus.ColumnHeaders.Add 1, , "Key", 3 * (lvStatus.Width / Divisions)
    lvStatus.ColumnHeaders.Add 2, , "Value", 1 * (lvStatus.Width / Divisions)
End Sub

'Add or change a row in the listview to describe the phidget state
Private Sub DisplayKey(Key As String, Value As String, added As Boolean)
    Dim L As ListItem
    Dim i
    Dim Found As Boolean
    
    i = 1
    Found = False                        'Is this particular phidget already in the list?
    For Each L In lvStatus.ListItems
        If L.Text = Key Then
            If added = False Then
                lvStatus.ListItems.Remove i
            Else
                L.SubItems(1) = CStr(Value)
            End If
            Found = True                 'Yup, it is.
            Exit For
        End If
        i = i + 1
    Next L
    
    'If this particular phidget is not in the list, add it.
    If Found = False Then
        Set L = lvStatus.ListItems.Add(1, , Key)
        L.SubItems(1) = CStr(Value)
    End If
End Sub


Private Sub Listener_OnKeyChange(ByVal Key As String, ByVal Value As String)
    DisplayKey Key, Value, True
End Sub

Private Sub Listener_OnKeyRemoval(ByVal Key As String, ByVal Value As String)
    DisplayKey Key, Value, False
End Sub

