unit RFID;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleCtrls, Phidget21COM_TLB;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    PhidgetRFID1: TPhidgetRFID;
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure PhidgetRFID1Attach(Sender: TObject);
    procedure PhidgetRFID1Detach(Sender: TObject);
    procedure PhidgetRFID1TagLost(ASender: TObject;
      const TagNumber: WideString);
    procedure FormCreate(Sender: TObject);
    procedure PhidgetRFID1Tag(ASender: TObject;
      const TagNumber: WideString);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  PhidgetRFID1.Open(-1);

  memo1.Clear;
  memo2.Clear;
  CheckBox1.Enabled := false;
  CheckBox2.Enabled := false;
  CheckBox3.Enabled := false;
  CheckBox4.Enabled := false;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if(CheckBox1.Checked) then begin
    PhidgetRFID1.AntennaOn := true; end
  else begin
    PhidgetRFID1.AntennaOn := false; end;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  if(CheckBox2.Checked) then begin
    PhidgetRFID1.LEDOn := true; end
  else begin
    PhidgetRFID1.LEDOn := false; end;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  if(CheckBox3.Checked) then begin
    PhidgetRFID1.OutputState[0] := true; end
  else begin
    PhidgetRFID1.OutputState[0] := false; end;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  if(CheckBox4.Checked) then begin
    PhidgetRFID1.OutputState[1] := true; end
  else begin
    PhidgetRFID1.OutputState[1] := false; end;
end;

procedure TForm1.PhidgetRFID1Attach(Sender: TObject);
begin
  memo1.lines.add(PhidgetRFID1.DeviceType+' Connected. Serial #'+IntToStr(PhidgetRFID1.SerialNumber));
    PhidgetRFID1.AntennaOn := false;
    PhidgetRFID1.LEDOn := false;
    PhidgetRFID1.OutputState[1] := false;
    PhidgetRFID1.OutputState[0] := false;
    CheckBox1.Checked := false;
    CheckBox2.Checked := false;
    CheckBox3.Checked := false;
    CheckBox4.Checked := false;
    CheckBox1.Enabled := true;
    CheckBox2.Enabled := true;
    CheckBox3.Enabled := true;
    CheckBox4.Enabled := true;
end;

procedure TForm1.PhidgetRFID1Detach(Sender: TObject);
begin
   memo1.lines.add(PhidgetRFID1.DeviceType+' Disconnected. Serial #'+inttostr(PhidgetRFID1.SerialNumber));
    CheckBox1.Enabled := false;
    CheckBox2.Enabled := false;
    CheckBox3.Enabled := false;
    CheckBox4.Enabled := false;
end;

procedure TForm1.PhidgetRFID1Tag(ASender: TObject;
  const TagNumber: WideString);
begin
  memo2.lines.add('Tag: '+TagNumber);
end;

procedure TForm1.PhidgetRFID1TagLost(ASender: TObject;
  const TagNumber: WideString);
begin
  memo2.lines.add('Lost: '+TagNumber);
end;

end.
