unit IR_simple;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, Phidget21COM_TLB, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    attachedTxt: TEdit;
    Label2: TLabel;
    codeTxt: TMemo;
    PhidgetIR1: TPhidgetIR;
    procedure PhidgetIR1Code(ASender: TObject; var data: OleVariant; dataLength,
      bitCount: Integer; repeat_: WordBool);
    procedure PhidgetIR1Detach(Sender: TObject);
    procedure PhidgetIR1Attach(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  attachedTxt.Text := 'False';
  codeTxt.Text := '';
  PhidgetIR1.Open(-1);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  attachedTxt.Text := 'False';
  codeTxt.Text := '';
  PhidgetIR1.Close;
end;

procedure TForm1.PhidgetIR1Attach(Sender: TObject);
begin
  attachedTxt.Text := 'True';
  codeTxt.Text := '';
end;

procedure TForm1.PhidgetIR1Detach(Sender: TObject);
begin
  attachedTxt.Text := 'False';
  codeTxt.Text := '';
end;

procedure TForm1.PhidgetIR1Code(ASender: TObject; var data: OleVariant;
  dataLength, bitCount: Integer; repeat_: WordBool);
type
  TByteArray = Array of Byte;
const
  hexLookup = '0123456789ABCDEF';
var
  I : LongInt;
  codeData :  TByteArray;
begin
  codeTxt.Text := 'IR Code: 0x';

  DynArrayFromVariant(Pointer(codeData), data, TypeInfo(TByteArray));

  for I := 0 to (dataLength - 1) do
  begin
    codeTxt.Text := codeTxt.Text + hexLookup[1 + codeData[I] shr 4];
    codeTxt.Text := codeTxt.Text + hexLookup[1 + codeData[I] and $0F];
  end;

  codeTxt.Text := codeTxt.Text + sLineBreak;
  codeTxt.Text := codeTxt.Text + 'Data Length: ' + IntToStr(dataLength) + sLineBreak;
  codeTxt.Text := codeTxt.Text + 'Bit Length: ' + IntToStr(bitCount) + sLineBreak;
  codeTxt.Text := codeTxt.Text + 'Repeat Count: ' + BoolToStr(repeat_) + sLineBreak;
end;

end.
