unit AdvancedServo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, Phidget21COM_TLB, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Memo1: TMemo;
    TrackBar1: TTrackBar;
    CheckBox1: TCheckBox;
    PhidgetAdvancedServo1: TPhidgetAdvancedServo;
    procedure TrackBar1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure PhidgetAdvancedServo1Attach(Sender: TObject);
    procedure PhidgetAdvancedServo1Detach(Sender: TObject);
    procedure PhidgetAdvancedServo1PositionChange(ASender: TObject;
      Index: Integer; Position: Double);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  //move servo 1 according to the trackbar position
  PhidgetAdvancedServo1.Position[0]:=TrackBar1.Position;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  label1.Caption := '';
  TrackBar1.Enabled:=FALSE;
  memo1.Clear;

  PhidgetAdvancedServo1.Open(-1);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  PhidgetAdvancedServo1.Engaged[0]:=CheckBox1.Checked;
end;

procedure TForm1.PhidgetAdvancedServo1Attach(Sender: TObject);
begin
  //Enable the trackbar if an advanced servo is connected
  memo1.lines.add(PhidgetAdvancedServo1.DeviceType+' Connected. Serial #'+IntToStr(PhidgetAdvancedServo1.SerialNumber));
  TrackBar1.Enabled:=True;
end;

procedure TForm1.PhidgetAdvancedServo1Detach(Sender: TObject);
begin
  //disable the trackbar if an advanced servo is disconnected
  memo1.lines.add(PhidgetAdvancedServo1.DeviceType+' Disconnected. Serial #'+inttostr(PhidgetAdvancedServo1.SerialNumber));
  TrackBar1.Enabled:=FALSE;
end;

procedure TForm1.PhidgetAdvancedServo1PositionChange(ASender: TObject;
  Index: Integer; Position: Double);
begin
  label1.Caption := 'Position: ' + floattostr(Position);
end;

end.
