unit servo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, OleServer,Phidget21COMEvents, Phidget21COM_TLB ;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Label1: TLabel;
    TrackBar1: TTrackBar;
    Phidget21COMIPhidgetAdvancedServoEvents1: TPhidget21COMIPhidgetAdvancedServoEvents;
    CheckBox1: TCheckBox;
    procedure Phidget21COMIPhidgetAdvancedServoEvents1PositionChange(Sender: TObject;
      Index: Integer; NewState: Double);
    procedure Phidget21COMIPhidgetAdvancedServoEvents1Detach(Sender: TObject);
    procedure Phidget21COMIPhidgetAdvancedServoEvents1Attach(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Servo1 : IPhidgetAdvancedServo;
  MyManager : IPhidgetManager;

implementation

{$R *.dfm}

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  //move servo 1 according to the trackbar position
  Servo1.Position[0]:=TrackBar1.Position;
  //
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    Servo1:=CoPhidgetAdvancedServo.Create;
    Phidget21COMIPhidgetAdvancedServoEvents1.Connect(Servo1);
  label1.Caption := '';
  TrackBar1.Enabled:=FALSE;
  memo1.Clear;
    Servo1.Open(-1);
end;

procedure TForm1.Phidget21COMIPhidgetAdvancedServoEvents1Attach(Sender: TObject);
begin
          memo1.lines.add(Servo1.DeviceType+' Connected. Serial #'+IntToStr(Servo1.SerialNumber));

    //create a new servo object and open the servo, according to its serial

    TrackBar1.Enabled:=True;         // Only allow the trackbar if we're a Servo!

end;

procedure TForm1.Phidget21COMIPhidgetAdvancedServoEvents1Detach(Sender: TObject);
begin
  //disable the trackbar if a servo is disconnected
  memo1.lines.add(Servo1.DeviceType+' Disconnected. Serial #'+inttostr(Servo1.SerialNumber));
  TrackBar1.Enabled:=FALSE;
end;

procedure TForm1.Phidget21COMIPhidgetAdvancedServoEvents1PositionChange(Sender: TObject;
  Index: Integer; NewState: Double);
begin
      label1.Caption := 'Position: ' + floattostr(NewState);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
Servo1.Engaged[0]:=CheckBox1.Checked;
end;

end.
