#ifdef __cplusplus
extern "C" {
#endif

typedef struct _CPhidget CPhidget, *CPhidgetHandle;

__declspec (dllimport)
     int __stdcall CPhidget_open (CPhidgetHandle phid, int serialNumber);
__declspec (dllimport)
     int __stdcall CPhidget_close (CPhidgetHandle phid);
__declspec (dllimport)
     int __stdcall CPhidget_delete (CPhidgetHandle phid);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnDetach_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnAttach_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnServerConnect_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnServerDisconnect_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnError_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr, int errorCode, const char *errorString), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceName (CPhidgetHandle phid, const char **deviceName);
__declspec (dllimport)
     int __stdcall CPhidget_getSerialNumber (CPhidgetHandle phid, int *serialNumber);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceVersion (CPhidgetHandle phid, int *deviceVersion);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceStatus (CPhidgetHandle phid, int *deviceStatus);
__declspec (dllimport)
     int __stdcall CPhidget_getLibraryVersion (const char **libraryVersion);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceType (CPhidgetHandle phid, const char **deviceType);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceLabel (CPhidgetHandle phid, const char **deviceLabel);
__declspec (dllimport)
     int __stdcall CPhidget_setDeviceLabel (CPhidgetHandle phid, const char *deviceLabel);
__declspec (dllimport)
     int __stdcall CPhidget_getErrorDescription (int errorCode, const char **errorString);
__declspec (dllimport)
     int __stdcall CPhidget_waitForAttachment (CPhidgetHandle phid, int milliseconds);
__declspec (dllimport)
     int __stdcall CPhidget_getServerID (CPhidgetHandle phid, const char **serverID);
__declspec (dllimport)
     int __stdcall CPhidget_getServerAddress (CPhidgetHandle phid, const char **address, int *port);
__declspec (dllimport)
     int __stdcall CPhidget_getServerStatus (CPhidgetHandle phid, int *serverStatus);

     typedef enum
     {
      PHIDGET_DICTIONARY_VALUE_CHANGED = 1,
      PHIDGET_DICTIONARY_ENTRY_ADDED,
      PHIDGET_DICTIONARY_ENTRY_REMOVING,
      PHIDGET_DICTIONARY_CURRENT_VALUE
     } CPhidgetDictionary_keyChangeReason;

     typedef struct _CPhidgetDictionary *CPhidgetDictionaryHandle;
     typedef struct _CPhidgetDictionaryListener *CPhidgetDictionaryListenerHandle;

__declspec (dllimport)
     int __stdcall CPhidgetDictionary_create (CPhidgetDictionaryHandle * dict);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_close (CPhidgetDictionaryHandle dict);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_delete (CPhidgetDictionaryHandle dict);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnError_Handler (CPhidgetDictionaryHandle dict,
							   int (__stdcall * fptr) (CPhidgetDictionaryHandle, void *userPtr, int errorCode, const char *errorString), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_addKey (CPhidgetDictionaryHandle dict, const char *key, const char *value, int persistent);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_removeKey (CPhidgetDictionaryHandle dict, const char *pattern);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnKeyChange_Handler (CPhidgetDictionaryHandle dict, CPhidgetDictionaryListenerHandle * dictlistener, const char *pattern,
							       int (__stdcall * fptr) (CPhidgetDictionaryHandle dict, void *userPtr, const char *key, const char *value,
										       CPhidgetDictionary_keyChangeReason reason), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_remove_OnKeyChange_Handler (CPhidgetDictionaryListenerHandle keylistener);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getKey (CPhidgetDictionaryHandle dict, const char *key, const char *value, int valueSize);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnServerConnect_Handler (CPhidgetDictionaryHandle dict, int (__stdcall * fptr) (CPhidgetDictionaryHandle dict, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnServerDisconnect_Handler (CPhidgetDictionaryHandle dict, int (__stdcall * fptr) (CPhidgetDictionaryHandle dict, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getServerID (CPhidgetDictionaryHandle dict, const char **serverID);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getServerAddress (CPhidgetDictionaryHandle dict, const char **address, int *port);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getServerStatus (CPhidgetDictionaryHandle dict, int *serverStatus);

     typedef struct _CPhidgetManager *CPhidgetManagerHandle;

__declspec (dllimport)
     int __stdcall CPhidgetManager_create (CPhidgetManagerHandle * phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_open (CPhidgetManagerHandle phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_close (CPhidgetManagerHandle phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_delete (CPhidgetManagerHandle phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnAttach_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnDetach_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getAttachedDevices (CPhidgetManagerHandle phidm, CPhidgetHandle * phidArray[], int *count);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnError_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetManagerHandle phidm, void *userPtr, int errorCode, const char *errorString),
							void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnServerConnect_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetManagerHandle phidm, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnServerDisconnect_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetManagerHandle phidm, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getServerID (CPhidgetManagerHandle phidm, const char **serverID);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getServerAddress (CPhidgetManagerHandle phidm, const char **address, int *port);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getServerStatus (CPhidgetManagerHandle phidm, int *serverStatus);

__declspec (dllimport)
     int __stdcall CPhidget_openRemote (CPhidgetHandle phid, int serial, const char *serverID, const char *password);
__declspec (dllimport)
     int __stdcall CPhidget_openRemoteIP (CPhidgetHandle phid, int serial, const char *address, int port, const char *password);

__declspec (dllimport)
     int __stdcall CPhidgetManager_openRemoteIP (CPhidgetManagerHandle phidm, const char *address, int port, const char *password);
__declspec (dllimport)
     int __stdcall CPhidgetManager_openRemote (CPhidgetManagerHandle phidm, const char *serverID, const char *password);

__declspec (dllimport)
     int __stdcall CPhidgetDictionary_openRemoteIP (CPhidgetDictionaryHandle dict, const char *address, int port, const char *password);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_openRemote (CPhidgetDictionaryHandle dict, const char *serverID, const char *password);

     typedef enum
     {
      PHIDGET_LOG_CRITICAL = 1,
      PHIDGET_LOG_ERROR,
      PHIDGET_LOG_WARNING,
      PHIDGET_LOG_DEBUG,
      PHIDGET_LOG_INFO,
      PHIDGET_LOG_VERBOSE
     } CPhidgetLog_level;

__declspec (dllimport)
     int __stdcall CPhidget_enableLogging (CPhidgetLog_level level, const char *outputFile);
__declspec (dllimport)
     int __stdcall CPhidget_disableLogging ();
__declspec (dllimport)
     int __stdcall CPhidget_log (CPhidgetLog_level level, const char *id, const char *message, ...);

     typedef struct _CPhidgetAccelerometer *CPhidgetAccelerometerHandle;
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_create (CPhidgetAccelerometerHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAxisCount (CPhidgetAccelerometerHandle phid, int *count);

__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAcceleration (CPhidgetAccelerometerHandle phid, int index, double *acceleration);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAccelerationMax (CPhidgetAccelerometerHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAccelerationMin (CPhidgetAccelerometerHandle phid, int index, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_set_OnAccelerationChange_Handler (CPhidgetAccelerometerHandle phid,
									   int (__stdcall * fptr) (CPhidgetAccelerometerHandle phid, void *userPtr, int index, double acceleration), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAccelerationChangeTrigger (CPhidgetAccelerometerHandle phid, int index, double *trigger);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_setAccelerationChangeTrigger (CPhidgetAccelerometerHandle phid, int index, double trigger);

__declspec (deprecated ("Deprecated - use CPhidgetAccelerometer_getAxisCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetAccelerometer_getNumAxis (CPhidgetAccelerometerHandle, int *);

     typedef struct _CPhidgetAdvancedServo *
      CPhidgetAdvancedServoHandle;
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_create (CPhidgetAdvancedServoHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getMotorCount (CPhidgetAdvancedServoHandle phid, int *count);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getAcceleration (CPhidgetAdvancedServoHandle phid, int index, double *acceleration);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setAcceleration (CPhidgetAdvancedServoHandle phid, int index, double acceleration);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getAccelerationMax (CPhidgetAdvancedServoHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getAccelerationMin (CPhidgetAdvancedServoHandle phid, int index, double *min);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getVelocityLimit (CPhidgetAdvancedServoHandle phid, int index, double *imit);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setVelocityLimit (CPhidgetAdvancedServoHandle phid, int index, double limit);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getVelocity (CPhidgetAdvancedServoHandle phid, int index, double *velocity);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getVelocityMax (CPhidgetAdvancedServoHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getVelocityMin (CPhidgetAdvancedServoHandle phid, int index, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_set_OnVelocityChange_Handler (CPhidgetAdvancedServoHandle phid,
								       int (__stdcall * fptr) (CPhidgetAdvancedServoHandle phid, void *userPtr, int index, double velocity), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getPosition (CPhidgetAdvancedServoHandle phid, int index, double *position);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setPosition (CPhidgetAdvancedServoHandle phid, int index, double position);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getPositionMax (CPhidgetAdvancedServoHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setPositionMax (CPhidgetAdvancedServoHandle phid, int index, double max);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getPositionMin (CPhidgetAdvancedServoHandle phid, int index, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setPositionMin (CPhidgetAdvancedServoHandle phid, int index, double min);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_set_OnPositionChange_Handler (CPhidgetAdvancedServoHandle phid,
								       int (__stdcall * fptr) (CPhidgetAdvancedServoHandle phid, void *userPtr, int index, double position), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getCurrent (CPhidgetAdvancedServoHandle phid, int index, double *current);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_set_OnCurrentChange_Handler (CPhidgetAdvancedServoHandle phid,
								      int (__stdcall * fptr) (CPhidgetAdvancedServoHandle phid, void *userPtr, int index, double current), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getSpeedRampingOn (CPhidgetAdvancedServoHandle phid, int index, int *rampingState);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setSpeedRampingOn (CPhidgetAdvancedServoHandle phid, int index, int rampingState);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getEngaged (CPhidgetAdvancedServoHandle phid, int index, int *engagedState);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setEngaged (CPhidgetAdvancedServoHandle phid, int index, int engagedState);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getStopped (CPhidgetAdvancedServoHandle phid, int index, int *stoppedState);

     typedef struct _CPhidgetEncoder *CPhidgetEncoderHandle;
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_create (CPhidgetEncoderHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getInputCount (CPhidgetEncoderHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getInputState (CPhidgetEncoderHandle phid, int index, int *inputState);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_set_OnInputChange_Handler (CPhidgetEncoderHandle phid, int (__stdcall * fptr) (CPhidgetEncoderHandle phid, void *userPtr, int index, int inputState), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getEncoderCount (CPhidgetEncoderHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getPosition (CPhidgetEncoderHandle phid, int index, int *position);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_setPosition (CPhidgetEncoderHandle phid, int index, int position);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_set_OnPositionChange_Handler (CPhidgetEncoderHandle phid,
								 int (__stdcall * fptr) (CPhidgetEncoderHandle phid, void *userPtr, int index, int time, int positionChange), void *userPtr);

__declspec (deprecated ("Deprecated - use CPhidgetEncoder_getPosition")) __declspec (dllimport)
     int __stdcall
     CPhidgetEncoder_getEncoderPosition (CPhidgetEncoderHandle, int index, int *);
__declspec (deprecated ("Deprecated - use CPhidgetEncoder_setPosition")) __declspec (dllimport)
     int __stdcall
     CPhidgetEncoder_setEncoderPosition (CPhidgetEncoderHandle, int index, int);
__declspec (deprecated ("Deprecated - use CPhidgetEncoder_getInputCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetEncoder_getNumInputs (CPhidgetEncoderHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetEncoder_getEncoderCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetEncoder_getNumEncoders (CPhidgetEncoderHandle, int *);

     typedef struct _CPhidgetInterfaceKit *
      CPhidgetInterfaceKitHandle;
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_create (CPhidgetInterfaceKitHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getInputCount (CPhidgetInterfaceKitHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getInputState (CPhidgetInterfaceKitHandle phid, int index, int *inputState);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_set_OnInputChange_Handler (CPhidgetInterfaceKitHandle phid, int (__stdcall * fptr) (CPhidgetInterfaceKitHandle phid, void *userPtr, int index, int inputState),
								   void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getOutputCount (CPhidgetInterfaceKitHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getOutputState (CPhidgetInterfaceKitHandle phid, int index, int *outputState);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_setOutputState (CPhidgetInterfaceKitHandle phid, int index, int outputState);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_set_OnOutputChange_Handler (CPhidgetInterfaceKitHandle phid,
								    int (__stdcall * fptr) (CPhidgetInterfaceKitHandle phid, void *userPtr, int index, int outputState), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getSensorCount (CPhidgetInterfaceKitHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getSensorValue (CPhidgetInterfaceKitHandle phid, int index, int *sensorValue);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getSensorRawValue (CPhidgetInterfaceKitHandle phid, int index, int *sensorRawValue);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_set_OnSensorChange_Handler (CPhidgetInterfaceKitHandle phid,
								    int (__stdcall * fptr) (CPhidgetInterfaceKitHandle phid, void *userPtr, int index, int sensorValue), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getSensorChangeTrigger (CPhidgetInterfaceKitHandle phid, int index, int *trigger);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_setSensorChangeTrigger (CPhidgetInterfaceKitHandle phid, int index, int trigger);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getRatiometric (CPhidgetInterfaceKitHandle phid, int *ratiometric);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_setRatiometric (CPhidgetInterfaceKitHandle phid, int ratiometric);

__declspec (deprecated ("Deprecated - use CPhidgetInterfaceKit_getInputCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetInterfaceKit_getNumInputs (CPhidgetInterfaceKitHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetInterfaceKit_getOutputCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetInterfaceKit_getNumOutputs (CPhidgetInterfaceKitHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetInterfaceKit_getSensorCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetInterfaceKit_getNumSensors (CPhidgetInterfaceKitHandle, int *);

     typedef struct _CPhidgetLED *
      CPhidgetLEDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetLED_create (CPhidgetLEDHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetLED_getLEDCount (CPhidgetLEDHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetLED_getDiscreteLED (CPhidgetLEDHandle phid, int index, int *brightness);
__declspec (dllimport)
     int __stdcall CPhidgetLED_setDiscreteLED (CPhidgetLEDHandle phid, int index, int brightness);

__declspec (deprecated ("Deprecated - use CPhidgetLED_getLEDCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetLED_getNumLEDs (CPhidgetLEDHandle, int *);

     typedef struct _CPhidgetMotorControl *
      CPhidgetMotorControlHandle;
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_create (CPhidgetMotorControlHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getMotorCount (CPhidgetMotorControlHandle phid, int *count);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getVelocity (CPhidgetMotorControlHandle phid, int index, double *velocity);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_setVelocity (CPhidgetMotorControlHandle phid, int index, double velocity);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_set_OnVelocityChange_Handler (CPhidgetMotorControlHandle phid,
								      int (__stdcall * fptr) (CPhidgetMotorControlHandle phid, void *userPtr, int index, double velocity), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getAcceleration (CPhidgetMotorControlHandle phid, int index, double *acceleration);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_setAcceleration (CPhidgetMotorControlHandle phid, int index, double acceleration);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getAccelerationMax (CPhidgetMotorControlHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getAccelerationMin (CPhidgetMotorControlHandle phid, int index, double *min);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getCurrent (CPhidgetMotorControlHandle phid, int index, double *current);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_set_OnCurrentChange_Handler (CPhidgetMotorControlHandle phid,
								     int (__stdcall * fptr) (CPhidgetMotorControlHandle phid, void *userPtr, int index, double current), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getInputCount (CPhidgetMotorControlHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getInputState (CPhidgetMotorControlHandle phid, int index, int *inputState);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_set_OnInputChange_Handler (CPhidgetMotorControlHandle phid, int (__stdcall * fptr) (CPhidgetMotorControlHandle phid, void *userPtr, int index, int inputState),
								   void *userPtr);

__declspec (deprecated ("Deprecated - use CPhidgetMotorControl_getMotorCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetMotorControl_getNumMotors (CPhidgetMotorControlHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetMotorControl_getInputCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetMotorControl_getNumInputs (CPhidgetMotorControlHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetMotorControl_getVelocity")) __declspec (dllimport)
     int __stdcall
     CPhidgetMotorControl_getMotorSpeed (CPhidgetMotorControlHandle, int index, double *);
__declspec (deprecated ("Deprecated - use CPhidgetMotorControl_setVelocity")) __declspec (dllimport)
     int __stdcall
     CPhidgetMotorControl_setMotorSpeed (CPhidgetMotorControlHandle, int index, double);
__declspec (deprecated ("Deprecated - use CPhidgetMotorControl_set_OnVelocityChange_Handler")) __declspec (dllimport)
     int __stdcall
     CPhidgetMotorControl_set_OnMotorChange_Handler (CPhidgetMotorControlHandle, int (__stdcall * fptr) (CPhidgetMotorControlHandle, void *userPtr, int index, double motorSpeed), void *userPtr);

     typedef struct _CPhidgetPHSensor *
      CPhidgetPHSensorHandle;
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_create (CPhidgetPHSensorHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPH (CPhidgetPHSensorHandle phid, double *ph);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPHMax (CPhidgetPHSensorHandle phid, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPHMin (CPhidgetPHSensorHandle phid, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_set_OnPHChange_Handler (CPhidgetPHSensorHandle phid, int (__stdcall * fptr) (CPhidgetPHSensorHandle phid, void *userPtr, double ph), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPHChangeTrigger (CPhidgetPHSensorHandle phid, double *trigger);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_setPHChangeTrigger (CPhidgetPHSensorHandle phid, double trigger);

__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPotential (CPhidgetPHSensorHandle phid, double *potential);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPotentialMax (CPhidgetPHSensorHandle phid, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPotentialMin (CPhidgetPHSensorHandle phid, double *min);

__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_setTemperature (CPhidgetPHSensorHandle phid, double temperature);

     typedef struct _CPhidgetRFID *CPhidgetRFIDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetRFID_create (CPhidgetRFIDHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetRFID_getOutputCount (CPhidgetRFIDHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_getOutputState (CPhidgetRFIDHandle phid, int index, int *outputState);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_setOutputState (CPhidgetRFIDHandle phid, int index, int outputState);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_set_OnOutputChange_Handler (CPhidgetRFIDHandle phid, int (__stdcall * fptr) (CPhidgetRFIDHandle phid, void *userPtr, int index, int outputState), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetRFID_getAntennaOn (CPhidgetRFIDHandle phid, int *antennaState);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_setAntennaOn (CPhidgetRFIDHandle phid, int antennaState);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_getLEDOn (CPhidgetRFIDHandle phid, int *LEDState);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_setLEDOn (CPhidgetRFIDHandle phid, int LEDState);

__declspec (dllimport)
     int __stdcall CPhidgetRFID_getLastTag (CPhidgetRFIDHandle phid, unsigned char *tag);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_getTagStatus (CPhidgetRFIDHandle phid, int *status);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_set_OnTag_Handler (CPhidgetRFIDHandle phid, int (__stdcall * fptr) (CPhidgetRFIDHandle phid, void *userPtr, unsigned char *tag), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_set_OnTagLost_Handler (CPhidgetRFIDHandle phid, int (__stdcall * fptr) (CPhidgetRFIDHandle phid, void *userPtr, unsigned char *tag), void *userPtr);

__declspec (deprecated ("Deprecated - use CPhdigetRFID_getOutputCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetRFID_getNumOutputs (CPhidgetRFIDHandle, int *);

     typedef struct _CPhidgetServo *
      CPhidgetServoHandle;
__declspec (dllimport)
     int __stdcall CPhidgetServo_create (CPhidgetServoHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetServo_getMotorCount (CPhidgetServoHandle phid, int *count);

__declspec (dllimport)
     int __stdcall CPhidgetServo_getPosition (CPhidgetServoHandle phid, int index, double *position);
__declspec (dllimport)
     int __stdcall CPhidgetServo_setPosition (CPhidgetServoHandle phid, int index, double position);
__declspec (dllimport)
     int __stdcall CPhidgetServo_getPositionMax (CPhidgetServoHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetServo_getPositionMin (CPhidgetServoHandle phid, int index, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetServo_set_OnPositionChange_Handler (CPhidgetServoHandle phid, int (__stdcall * fptr) (CPhidgetServoHandle phid, void *userPtr, int index, double position), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetServo_getEngaged (CPhidgetServoHandle phid, int index, int *engagedState);
__declspec (dllimport)
     int __stdcall CPhidgetServo_setEngaged (CPhidgetServoHandle phid, int index, int engagedState);

__declspec (deprecated ("Deprecated - use CPhidgetServo_getMotorCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_getNumMotors (CPhidgetServoHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetServo_setPosition")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_setMotorPosition (CPhidgetServoHandle, int index, double);
__declspec (deprecated ("Deprecated - use CPhidgetServo_getPosition")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_getMotorPosition (CPhidgetServoHandle, int index, double *);
__declspec (deprecated ("Deprecated - use CPhidgetServo_getPositionMax")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_getMotorPositionMax (CPhidgetServoHandle, int index, double *);
__declspec (deprecated ("Deprecated - use CPhidgetServo_getPositionMin")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_getMotorPositionMin (CPhidgetServoHandle, int index, double *);
__declspec (deprecated ("Deprecated - use CPhidgetServo_set_OnPositionChange_Handler")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_set_OnMotorPositionChange_Handler (CPhidgetServoHandle, int (__stdcall * fptr) (CPhidgetServoHandle, void *userPtr, int index, double motorPosition), void *userPtr);
__declspec (deprecated ("Deprecated - use CPhidgetServo_setEngaged")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_setMotorOn (CPhidgetServoHandle, int index, int);
__declspec (deprecated ("Deprecated - use CPhidgetServo_getEngaged")) __declspec (dllimport)
     int __stdcall
     CPhidgetServo_getMotorOn (CPhidgetServoHandle, int index, int *);

     typedef struct _CPhidgetStepper *
      CPhidgetStepperHandle;
__declspec (dllimport)
     int __stdcall CPhidgetStepper_create (CPhidgetStepperHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getInputCount (CPhidgetStepperHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getInputState (CPhidgetStepperHandle phid, int index, int *inputState);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnInputChange_Handler (CPhidgetStepperHandle phid, int (__stdcall * fptr) (CPhidgetStepperHandle phid, void *userPtr, int index, int inputState), void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMotorCount (CPhidgetStepperHandle phid, int *count);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getAcceleration (CPhidgetStepperHandle phid, int index, double *acceleration);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setAcceleration (CPhidgetStepperHandle phid, int index, double acceleration);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getAccelerationMax (CPhidgetStepperHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getAccelerationMin (CPhidgetStepperHandle phid, int index, double *min);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getVelocityLimit (CPhidgetStepperHandle phid, int index, double *limit);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setVelocityLimit (CPhidgetStepperHandle phid, int index, double limit);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getVelocity (CPhidgetStepperHandle phid, int index, double *velocity);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getVelocityMax (CPhidgetStepperHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getVelocityMin (CPhidgetStepperHandle phid, int index, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnVelocityChange_Handler (CPhidgetStepperHandle phid, int (__stdcall * fptr) (CPhidgetStepperHandle phid, void *userPtr, int index, double velocity),
								 void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getTargetPosition (CPhidgetStepperHandle phid, int index, __int64 * position);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setTargetPosition (CPhidgetStepperHandle phid, int index, __int64 position);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getCurrentPosition (CPhidgetStepperHandle phid, int index, __int64 * positin);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setCurrentPosition (CPhidgetStepperHandle phid, int index, __int64 position);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getPositionMax (CPhidgetStepperHandle phid, int index, __int64 * max);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getPositionMin (CPhidgetStepperHandle phid, int index, __int64 * min);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnPositionChange_Handler (CPhidgetStepperHandle phid, int (__stdcall * fptr) (CPhidgetStepperHandle phid, void *userPtr, int index, __int64 position),
								 void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getCurrentLimit (CPhidgetStepperHandle phid, int index, double *limit);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setCurrentLimit (CPhidgetStepperHandle phid, int index, double limit);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getCurrent (CPhidgetStepperHandle phid, int index, double *current);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getCurrentMax (CPhidgetStepperHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getCurrentMin (CPhidgetStepperHandle phid, int index, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnCurrentChange_Handler (CPhidgetStepperHandle phid, int (__stdcall * fptr) (CPhidgetStepperHandle phid, void *userPtr, int index, double current),
								void *userPtr);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getEngaged (CPhidgetStepperHandle phid, int index, int *engagedState);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setEngaged (CPhidgetStepperHandle phid, int index, int engagedState);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getStopped (CPhidgetStepperHandle phid, int index, int *stopped);

     typedef struct _CPhidgetTemperatureSensor *CPhidgetTemperatureSensorHandle;
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_create (CPhidgetTemperatureSensorHandle * phid);

     typedef enum
     {
      PHIDGET_TEMPERATURE_SENSOR_K_TYPE = 1,
      PHIDGET_TEMPERATURE_SENSOR_J_TYPE,
      PHIDGET_TEMPERATURE_SENSOR_E_TYPE,
      PHIDGET_TEMPERATURE_SENSOR_T_TYPE
     } CPhidgetTemperatureSensor_ThermocoupleType;

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperatureInputCount (CPhidgetTemperatureSensorHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperature (CPhidgetTemperatureSensorHandle phid, int index, double *temperature);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperatureMax (CPhidgetTemperatureSensorHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperatureMin (CPhidgetTemperatureSensorHandle phid, int index, double *min);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_set_OnTemperatureChange_Handler (CPhidgetTemperatureSensorHandle phid,
									      int (__stdcall * fptr) (CPhidgetTemperatureSensorHandle phid, void *userPtr, int index, double temperature),
									      void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperatureChangeTrigger (CPhidgetTemperatureSensorHandle phid, int index, double *trigger);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_setTemperatureChangeTrigger (CPhidgetTemperatureSensorHandle phid, int index, double trigger);

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getPotential (CPhidgetTemperatureSensorHandle phid, int index, double *potential);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getPotentialMax (CPhidgetTemperatureSensorHandle phid, int index, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getPotentialMin (CPhidgetTemperatureSensorHandle phid, int index, double *min);

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getAmbientTemperature (CPhidgetTemperatureSensorHandle phid, double *ambient);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getAmbientTemperatureMax (CPhidgetTemperatureSensorHandle phid, double *max);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getAmbientTemperatureMin (CPhidgetTemperatureSensorHandle phid, double *min);

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getThermocoupleType (CPhidgetTemperatureSensorHandle phid, int index, CPhidgetTemperatureSensor_ThermocoupleType * type);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_setThermocoupleType (CPhidgetTemperatureSensorHandle phid, int index, CPhidgetTemperatureSensor_ThermocoupleType type);

__declspec (deprecated ("Deprecated - use CPhidgetTemepratureSensor_getTemperatureInputCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetTemperatureSensor_getNumTemperatureInputs (CPhidgetTemperatureSensorHandle, int *);

     typedef struct _CPhidgetTextLCD *
      CPhidgetTextLCDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_create (CPhidgetTextLCDHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getRowCount (CPhidgetTextLCDHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getColumnCount (CPhidgetTextLCDHandle phid, int *count);

__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getBacklight (CPhidgetTextLCDHandle phid, int *backlightState);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setBacklight (CPhidgetTextLCDHandle phid, int backlightState);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getContrast (CPhidgetTextLCDHandle phid, int *contrast);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setContrast (CPhidgetTextLCDHandle phid, int constrast);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getCursorOn (CPhidgetTextLCDHandle phid, int *cursorState);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setCursorOn (CPhidgetTextLCDHandle phid, int cursorState);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getCursorBlink (CPhidgetTextLCDHandle phid, int *cursorBlinkState);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setCursorBlink (CPhidgetTextLCDHandle phid, int cursorBlinkState);

__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setCustomCharacter (CPhidgetTextLCDHandle phid, int index, int var1, int var2);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setDisplayCharacter (CPhidgetTextLCDHandle phid, int index, int Column, unsigned char character);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setDisplayString (CPhidgetTextLCDHandle phid, int index, char *displayString);

__declspec (deprecated ("Deprecated - use CPhidgetTextLCD_getRowCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetTextLCD_getNumRows (CPhidgetTextLCDHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetTextLCD_getColumnCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetTextLCD_getNumColumns (CPhidgetTextLCDHandle, int *);

     typedef struct _CPhidgetTextLED *
      CPhidgetTextLEDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetTextLED_create (CPhidgetTextLEDHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetTextLED_getRowCount (CPhidgetTextLEDHandle phid, int *count);
__declspec (dllimport)
     int __stdcall CPhidgetTextLED_getColumnCount (CPhidgetTextLEDHandle phid, int *count);

__declspec (dllimport)
     int __stdcall CPhidgetTextLED_getBrightness (CPhidgetTextLEDHandle phid, int *brightness);
__declspec (dllimport)
     int __stdcall CPhidgetTextLED_setBrightness (CPhidgetTextLEDHandle phid, int brightness);

__declspec (dllimport)
     int __stdcall CPhidgetTextLED_setDisplayString (CPhidgetTextLEDHandle phid, int index, char *displayString);

__declspec (deprecated ("Deprecated - use CPhidgetTextLED_getRowCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetTextLED_getNumRows (CPhidgetTextLEDHandle, int *);
__declspec (deprecated ("Deprecated - use CPhidgetTextLED_getColumnCount")) __declspec (dllimport)
     int __stdcall
     CPhidgetTextLED_getNumColumns (CPhidgetTextLEDHandle, int *);

     typedef struct _CPhidgetWeightSensor *
      CPhidgetWeightSensorHandle;
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_create (CPhidgetWeightSensorHandle * phid);

__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_getWeight (CPhidgetWeightSensorHandle phid, double *weight);
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_set_OnWeightChange_Handler (CPhidgetWeightSensorHandle phid, int (__stdcall * fptr) (CPhidgetWeightSensorHandle phid, void *userPtr, double weight),
								    void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_getWeightChangeTrigger (CPhidgetWeightSensorHandle phid, double *trigger);
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_setWeightChangeTrigger (CPhidgetWeightSensorHandle phid, double trigger);
#ifndef CPHIDGET_CONSTANTS
#define CPHIDGET_CONSTANTS

/** \defgroup phidconst Phidget Constants 
 * @{
 */

/** @{ \name Phidget States
 * Returned by getStatus() functions
 */
#define PHIDGET_ATTACHED				0x1
#define PHIDGET_NOTATTACHED				0x0
/** @} */

/** @{ \name Phidget Error Codes
 * Returned by all C API calls
 */
#define	PHIDGET_ERROR_CODE_COUNT		18
#define EPHIDGET_OK						0
#define EPHIDGET_NOTFOUND				1
#define EPHIDGET_NOMEMORY				2
#define EPHIDGET_UNEXPECTED				3
#define EPHIDGET_INVALIDARG				4
#define EPHIDGET_NOTATTACHED			5
#define EPHIDGET_INTERRUPTED			6
#define EPHIDGET_INVALID				7
#define EPHIDGET_NETWORK				8
#define EPHIDGET_UNKNOWNVAL				9
#define EPHIDGET_BADPASSWORD			10
#define EPHIDGET_UNSUPPORTED			11
#define EPHIDGET_DUPLICATE				12
#define EPHIDGET_TIMEOUT				13
#define EPHIDGET_OUTOFBOUNDS			14
#define EPHIDGET_EVENT					15
#define EPHIDGET_NETWORK_NOTCONNECTED	16
#define EPHIDGET_WRONGDEVICE			17
/** @} */

/** @{ \name Phidget Unknown Constants
 * Returned for unknown values
 */
#define PUNK_BOOL	0x02 //(booleans only)
#define PUNK_INT	0x7FFFFFFF
#define PUNK_INT64	0x7FFFFFFFFFFFFFFFLL
#define PUNK_DBL	1e300
#define PUNK_FLT	1e30
/** @} */

#define PFALSE		0x00
#define PTRUE		0x01

/** @} */

#endif

#ifdef __cplusplus
}
#endif
