// TextLEDTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "..\phidget21.h"
#include <windows.h>

int __stdcall AttachHandler(CPhidgetHandle LED, void *userptr)
{
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall DetachHandler(CPhidgetHandle LED, void *userptr)
{
	printf("Detach handler ran!\n");
	return 0;
}

int __stdcall ErrorHandler(CPhidgetHandle LED, void *userptr, int ErrorCode, const char *unknown)
{
	printf("Error handler ran!\n");
	return 0;
}

void display_generic_properties(CPhidgetHandle phid)
{
	int sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType(phid, &deviceptr);
	CPhidget_getSerialNumber(phid, &sernum);
	CPhidget_getDeviceVersion(phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

int test_textlcd()
{
	int result;
	const char *err;

	int numRows, numColumns;
	int i;
	CPhidgetTextLEDHandle LED = 0;
	char myString[10];

	for(i=1;i<9;i++) myString[i]=7+i;
	myString[9]='\0';
	myString[0] = ' ';

	printf("ASDF\n");
	CPhidgetTextLED_create(&LED);

	CPhidget_set_OnAttach_Handler((CPhidgetHandle)LED, AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)LED, DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)LED, ErrorHandler, NULL);

	result = CPhidget_open((CPhidgetHandle)LED, -1);

	//Wait for 10 seconds, otherwise exit
	if(result = CPhidget_waitForAttachment((CPhidgetHandle)LED, 10000))
	{
		CPhidget_getErrorDescription(result, &err);
		printf("Problem waiting for attachment: %s\n", err);
		return 0;
	}

	display_generic_properties((CPhidgetHandle)LED);

	CPhidgetTextLED_getRowCount(LED, &numRows);
	CPhidgetTextLED_getColumnCount(LED, &numColumns);
	printf("Rows:%d Columns:%d\n", numRows, numColumns);	

	printf("Brightness set result = %d\n", CPhidgetTextLED_setBrightness(LED, 100));

	printf("Result from setDisplayString %d\n", CPhidgetTextLED_setDisplayString(LED, 0, "hi there"));
	printf("Result from setDisplayString %d\n", CPhidgetTextLED_setDisplayString(LED, 1, "HLODKSTE"));

	CPhidget_close((CPhidgetHandle)LED);
	CPhidget_delete((CPhidgetHandle )LED);

	return 0;
}

int main(int argc, char* argv[])
{
	test_textlcd();
	return 0;
}

