// TextLCDTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "..\phidget21.h"
#include <windows.h>

int __stdcall AttachHandler(CPhidgetHandle LCD, void *userptr)
{
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall DetachHandler(CPhidgetHandle LCD, void *userptr)
{
	printf("Detach handler ran!\n");
	return 0;
}

int __stdcall ErrorHandler(CPhidgetHandle LCD, void *userptr, int ErrorCode, const char *unknown)
{
	printf("Error handler ran!\n");
	return 0;
}

void display_generic_properties(CPhidgetHandle phid)
{
	int sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType(phid, &deviceptr);
	CPhidget_getSerialNumber(phid, &sernum);
	CPhidget_getDeviceVersion(phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

int test_textlcd()
{
	int result;
	const char *err;

	int numRows, numColumns;
	int i;
	CPhidgetTextLCDHandle LCD = 0;
	char myString[10];

	for(i=1;i<9;i++) myString[i]=7+i;
	myString[9]='\0';
	myString[0] = ' ';

	printf("ASDF\n");
	CPhidgetTextLCD_create(&LCD);

	CPhidget_set_OnAttach_Handler((CPhidgetHandle)LCD, AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)LCD, DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)LCD, ErrorHandler, NULL);

	CPhidget_open((CPhidgetHandle)LCD, -1);

	//Wait for 10 seconds, otherwise exit
	if(result = CPhidget_waitForAttachment((CPhidgetHandle)LCD, 10000))
	{
		CPhidget_getErrorDescription(result, &err);
		printf("Problem waiting for attachment: %s\n", err);
		return 0;
	}

	display_generic_properties((CPhidgetHandle)LCD);

	CPhidgetTextLCD_getRowCount(LCD, &numRows);
	CPhidgetTextLCD_getColumnCount(LCD, &numColumns);
	printf("Rows:%d Columns:%d\n", numRows, numColumns);	

	printf("Backlight result = %d\n", CPhidgetTextLCD_setBacklight(LCD, true));
	printf("CursorOn result = %d\n", CPhidgetTextLCD_setCursorOn(LCD, true));
	printf("CursorBlink result = %d\n", CPhidgetTextLCD_setCursorBlink(LCD, true));
	printf("Contrast result = %d\n", CPhidgetTextLCD_setContrast(LCD, 100));

	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 8, 10560, 476721));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 9, 0x0, 0xFFC00));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 10, 0x0, 0xFFFE0));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 11, 0x0, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 12, 0xF8000, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 13, 0xFFC00, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 14, 0xFFFE0, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 15, 0xFFFFF, 0xFFFFF));

	printf("Result from setDisplayString %d\n", CPhidgetTextLCD_setDisplayString(LCD, 0, "000000\"0000000"));
	printf("Result from setDisplayString %d\n", CPhidgetTextLCD_setDisplayString(LCD, 1, myString));

	CPhidget_close((CPhidgetHandle)LCD);
	CPhidget_delete((CPhidgetHandle )LCD);

	return 0;
}

int main(int argc, char* argv[])
{
	test_textlcd();
	return 0;
}

