// servoexample1.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "..\phidget21.h"
#include <Windows.h>


void display_generic_properties(CPhidgetHandle phid)
{
	int sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType((CPhidgetHandle)phid, &deviceptr);
	CPhidget_getSerialNumber((CPhidgetHandle)phid, &sernum);
	CPhidget_getDeviceVersion((CPhidgetHandle)phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

int __stdcall AttachHandler(CPhidgetHandle Servo, void *userptr)
{
	printf("Servo1 Attach: ");
	display_generic_properties(Servo);
	//while(1) Sleep(1000);
	return 0;
}

int __stdcall DetachHandler(CPhidgetHandle Servo, void *userptr)
{
	printf("Servo1 Detach: ");
	display_generic_properties(Servo);
	return 0;
}

int __stdcall ErrorHandler(CPhidgetHandle Servo, void *userptr, int ErrorCode, const char *unknown)
{
	printf("Error handler ran!\n");
	return 0;
}

int __stdcall SRV_MotorPositionChangeHandler(CPhidgetServoHandle IFK, void *userptr, int Index, double Value)
{
	printf("Motor Position %d is %lf\n", Index, Value);
	return 0;
}

int main(int argc, char* argv[])
{
	int result;
	const char *err;

	CPhidgetServoHandle Servo = 0;

	CPhidgetServo_create(&Servo);

	printf("long: %d, int: %d\n",sizeof(long), sizeof(int));

	CPhidget_set_OnAttach_Handler((CPhidgetHandle)Servo, AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)Servo, DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)Servo, ErrorHandler, NULL);
	CPhidgetServo_set_OnMotorPositionChange_Handler(Servo, SRV_MotorPositionChangeHandler, NULL);

	CPhidget_open((CPhidgetHandle)Servo, -1);

	while(1)Sleep(5000);
	//Wait for 10 seconds, otherwise exit
	if(result = CPhidget_waitForAttachment((CPhidgetHandle)Servo, 10000))
	{
		CPhidget_getErrorDescription(result, &err);
		printf("Problem waiting for attachment: %s\n", err);
		return 0;
	}

	display_generic_properties((CPhidgetHandle)Servo);

	result = CPhidgetServo_setMotorPosition(Servo, 0,-23.0);
	Sleep(500);
	result = CPhidgetServo_setMotorPosition(Servo, 0,40.0);
	Sleep(500);
	result = CPhidgetServo_setMotorPosition(Servo, 0,80.0);
	Sleep(500);
	result = CPhidgetServo_setMotorPosition(Servo, 0,120.0);
	Sleep(5000);

	CPhidget_close((CPhidgetHandle)Servo);
	CPhidget_delete((CPhidgetHandle)Servo);
	return 0;
}

