#ifdef __cplusplus
extern "C" {
#endif

typedef struct _CPhidget CPhidget, *CPhidgetHandle;

__declspec (dllimport)
     int __stdcall CPhidget_open (CPhidgetHandle phid, int serialNumber);
__declspec (dllimport)
     int __stdcall CPhidget_close (CPhidgetHandle phid);
__declspec (dllimport)
     int __stdcall CPhidget_delete (CPhidgetHandle phid);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnDetach_Handler (CPhidgetHandle, int (__stdcall * fptr) (CPhidgetHandle, void *), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnAttach_Handler (CPhidgetHandle, int (__stdcall * fptr) (CPhidgetHandle, void *), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnServerConnect_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnServerDisconnect_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_set_OnError_Handler (CPhidgetHandle phid, int (__stdcall * fptr) (CPhidgetHandle, void *, int, const char *), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceName (CPhidgetHandle phid, const char **buffer);
__declspec (dllimport)
     int __stdcall CPhidget_getSerialNumber (CPhidgetHandle phid, int *serialNumber);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceVersion (CPhidgetHandle phid, int *devVer);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceStatus (CPhidgetHandle phid, int *status);
__declspec (dllimport)
     int __stdcall CPhidget_getLibraryVersion (const char **buffer);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceType (CPhidgetHandle phid, const char **buffer);
__declspec (dllimport)
     int __stdcall CPhidget_getDeviceLabel (CPhidgetHandle phid, const char **buffer);
__declspec (dllimport)
     int __stdcall CPhidget_setDeviceLabel (CPhidgetHandle phid, const char *buffer);
__declspec (dllimport)
     int __stdcall CPhidget_getErrorDescription (int ErrorCode, const char **buf);
__declspec (dllimport)
     int __stdcall CPhidget_waitForAttachment (CPhidgetHandle phid, int milliseconds);
__declspec (dllimport)
     int __stdcall CPhidget_getServerID (CPhidgetHandle phid, const char **serverID);
__declspec (dllimport)
     int __stdcall CPhidget_getServerAddress (CPhidgetHandle phid, const char **address, int *port);
__declspec (dllimport)
     int __stdcall CPhidget_getServerStatus (CPhidgetHandle phid, int *status);

     typedef enum
     {
      PHIDGET_DICTIONARY_VALUE_CHANGED = 1,
      PHIDGET_DICTIONARY_ENTRY_ADDED,
      PHIDGET_DICTIONARY_ENTRY_REMOVING,
      PHIDGET_DICTIONARY_CURRENT_VALUE
     } CPhidgetDictionary_keyChangeReason;

     typedef struct _CPhidgetDictionary __CPhidgetDictionary;
     typedef __CPhidgetDictionary *CPhidgetDictionaryHandle;
     typedef struct _CPhidgetDictionaryListener __CPhidgetDictionaryListener;
     typedef __CPhidgetDictionaryListener *CPhidgetDictionaryListenerHandle;

__declspec (dllimport)
     int __stdcall CPhidgetDictionary_create (CPhidgetDictionaryHandle * dict);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_close (CPhidgetDictionaryHandle dict);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_delete (CPhidgetDictionaryHandle dict);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnError_Handler (CPhidgetDictionaryHandle dict, int (__stdcall * fptr) (CPhidgetDictionaryHandle, void *, int, const char *), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_addKey (CPhidgetDictionaryHandle dict, const char *key, const char *val, int persistent);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_removeKey (CPhidgetDictionaryHandle dict, const char *pattern);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnKeyChange_Handler (CPhidgetDictionaryHandle dict, CPhidgetDictionaryListenerHandle * dictlistener, const char *pattern,
							       int (__stdcall * fptr) (CPhidgetDictionaryHandle dict, void *userPtr, const char *key, const char *val,
										       CPhidgetDictionary_keyChangeReason reason), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_remove_OnKeyChange_Handler (CPhidgetDictionaryListenerHandle keylistener);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getKey (CPhidgetDictionaryHandle dict, const char *key, const char *val, int valsize);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnServerConnect_Handler (CPhidgetDictionaryHandle dict, int (__stdcall * fptr) (CPhidgetDictionaryHandle dict, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_set_OnServerDisconnect_Handler (CPhidgetDictionaryHandle dict, int (__stdcall * fptr) (CPhidgetDictionaryHandle dict, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getServerID (CPhidgetDictionaryHandle dict, const char **serverID);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getServerAddress (CPhidgetDictionaryHandle dict, const char **address, int *port);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_getServerStatus (CPhidgetDictionaryHandle dict, int *status);

     typedef struct _CPhidgetManager __CPhidgetManager;
     typedef __CPhidgetManager *CPhidgetManagerHandle;

__declspec (dllimport)
     int __stdcall CPhidgetManager_create (CPhidgetManagerHandle * phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_open (CPhidgetManagerHandle phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_close (CPhidgetManagerHandle phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_delete (CPhidgetManagerHandle phidm);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnAttach_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnDetach_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetHandle phid, void *userPtr), void *);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getAttachedDevices (CPhidgetManagerHandle phidm, CPhidgetHandle * phidArray[], int *count);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnError_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetManagerHandle, void *, int, const char *), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnServerConnect_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetManagerHandle phidm, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_set_OnServerDisconnect_Handler (CPhidgetManagerHandle phidm, int (__stdcall * fptr) (CPhidgetManagerHandle phidm, void *userPtr), void *userPtr);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getServerID (CPhidgetManagerHandle phidm, const char **serverID);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getServerAddress (CPhidgetManagerHandle phidm, const char **address, int *port);
__declspec (dllimport)
     int __stdcall CPhidgetManager_getServerStatus (CPhidgetManagerHandle phidm, int *status);

__declspec (dllimport)
     int __stdcall CPhidget_openRemote (CPhidgetHandle phid, int serial, const char *serverID, const char *passWord);
__declspec (dllimport)
     int __stdcall CPhidget_openRemoteIP (CPhidgetHandle phid, int serial, const char *addr, int port, const char *passWord);
__declspec (dllimport)
     int __stdcall CPhidgetManager_openRemoteIP (CPhidgetManagerHandle phidm, const char *address, int port, const char *password);
__declspec (dllimport)
     int __stdcall CPhidgetManager_openRemote (CPhidgetManagerHandle phidm, const char *serverID, const char *passWord);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_openRemoteIP (CPhidgetDictionaryHandle dict, const char *address, int port, const char *password);
__declspec (dllimport)
     int __stdcall CPhidgetDictionary_openRemote (CPhidgetDictionaryHandle dict, const char *serverID, const char *passWord);

     typedef enum
     {
      PHIDGET_LOG_CRITICAL = 1,
      PHIDGET_LOG_ERROR,
      PHIDGET_LOG_WARNING,
      PHIDGET_LOG_DEBUG,
      PHIDGET_LOG_INFO,
      PHIDGET_LOG_VERBOSE
     } CPhidgetLog_level;

__declspec (dllimport)
     int __stdcall CPhidget_enableLogging (CPhidgetLog_level level, const char *outputFile);
__declspec (dllimport)
     int __stdcall CPhidget_disableLogging ();
__declspec (dllimport)
     int __stdcall CPhidget_log (CPhidgetLog_level level, char *msg, const char *fmt, ...);

     typedef struct _CPhidgetAccelerometer __CPhidgetAccelerometer;
     typedef __CPhidgetAccelerometer *CPhidgetAccelerometerHandle;
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_create (CPhidgetAccelerometerHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getNumAxis (CPhidgetAccelerometerHandle, int *);

__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAcceleration (CPhidgetAccelerometerHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAccelerationMax (CPhidgetAccelerometerHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAccelerationMin (CPhidgetAccelerometerHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_set_OnAccelerationChange_Handler (CPhidgetAccelerometerHandle, int (__stdcall * fptr) (CPhidgetAccelerometerHandle, void *, int, double), void *);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_getAccelerationChangeTrigger (CPhidgetAccelerometerHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAccelerometer_setAccelerationChangeTrigger (CPhidgetAccelerometerHandle, int Index, double);

     typedef struct _CPhidgetAdvancedServo __CPhidgetAdvancedServo;
     typedef __CPhidgetAdvancedServo *CPhidgetAdvancedServoHandle;
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_create (CPhidgetAdvancedServoHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getNumMotors (CPhidgetAdvancedServoHandle, int *);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getAcceleration (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setAcceleration (CPhidgetAdvancedServoHandle, int Index, double);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getAccelerationMax (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getAccelerationMin (CPhidgetAdvancedServoHandle, int Index, double *);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getMaxVelocity (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setMaxVelocity (CPhidgetAdvancedServoHandle, int Index, double);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getVelocity (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getVelocityMax (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getVelocityMin (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_set_OnVelocityChange_Handler (CPhidgetAdvancedServoHandle, int (__stdcall * fptr) (CPhidgetAdvancedServoHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getMotorPosition (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setMotorPosition (CPhidgetAdvancedServoHandle, int Index, double);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getMotorPositionMax (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getMotorPositionMin (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_set_OnPositionChange_Handler (CPhidgetAdvancedServoHandle, int (__stdcall * fptr) (CPhidgetAdvancedServoHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getCurrent (CPhidgetAdvancedServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_set_OnCurrentChange_Handler (CPhidgetAdvancedServoHandle, int (__stdcall * fptr) (CPhidgetAdvancedServoHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getSpeedRampingOn (CPhidgetAdvancedServoHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setSpeedRampingOn (CPhidgetAdvancedServoHandle, int Index, int);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_getMotorOn (CPhidgetAdvancedServoHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetAdvancedServo_setMotorOn (CPhidgetAdvancedServoHandle, int Index, int);

     typedef struct _CPhidgetEncoder __CPhidgetEncoder;
     typedef __CPhidgetEncoder *CPhidgetEncoderHandle;
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_create (CPhidgetEncoderHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getNumInputs (CPhidgetEncoderHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getInputState (CPhidgetEncoderHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_set_OnInputChange_Handler (CPhidgetEncoderHandle, int (__stdcall * fptr) (CPhidgetEncoderHandle, void *, int, int), void *);

__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getNumEncoders (CPhidgetEncoderHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_getEncoderPosition (CPhidgetEncoderHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_setEncoderPosition (CPhidgetEncoderHandle, int Index, int);
__declspec (dllimport)
     int __stdcall CPhidgetEncoder_set_OnPositionChange_Handler (CPhidgetEncoderHandle, int (__stdcall * fptr) (CPhidgetEncoderHandle, void *, int, int, int), void *);

     typedef struct _CPhidgetInterfaceKit __CPhidgetInterfaceKit;
     typedef __CPhidgetInterfaceKit *CPhidgetInterfaceKitHandle;
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_create (CPhidgetInterfaceKitHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getNumInputs (CPhidgetInterfaceKitHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getInputState (CPhidgetInterfaceKitHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_set_OnInputChange_Handler (CPhidgetInterfaceKitHandle, int (__stdcall * fptr) (CPhidgetInterfaceKitHandle, void *, int, int), void *);

__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getNumOutputs (CPhidgetInterfaceKitHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getOutputState (CPhidgetInterfaceKitHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_setOutputState (CPhidgetInterfaceKitHandle, int Index, int);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_set_OnOutputChange_Handler (CPhidgetInterfaceKitHandle, int (__stdcall * fptr) (CPhidgetInterfaceKitHandle, void *, int, int), void *);

__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getNumSensors (CPhidgetInterfaceKitHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getSensorValue (CPhidgetInterfaceKitHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getSensorRawValue (CPhidgetInterfaceKitHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_set_OnSensorChange_Handler (CPhidgetInterfaceKitHandle, int (__stdcall * fptr) (CPhidgetInterfaceKitHandle, void *, int, int), void *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getSensorChangeTrigger (CPhidgetInterfaceKitHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_setSensorChangeTrigger (CPhidgetInterfaceKitHandle, int Index, int);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_getRatiometric (CPhidgetInterfaceKitHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetInterfaceKit_setRatiometric (CPhidgetInterfaceKitHandle, int);

     typedef struct _CPhidgetLED __CPhidgetLED;
     typedef __CPhidgetLED *CPhidgetLEDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetLED_create (CPhidgetLEDHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetLED_getNumLEDs (CPhidgetLEDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetLED_getDiscreteLED (CPhidgetLEDHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetLED_setDiscreteLED (CPhidgetLEDHandle, int Index, int);

     typedef struct _CPhidgetMotorControl __CPhidgetMotorControl;
     typedef __CPhidgetMotorControl *CPhidgetMotorControlHandle;
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_create (CPhidgetMotorControlHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getNumMotors (CPhidgetMotorControlHandle, int *);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getMotorSpeed (CPhidgetMotorControlHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_setMotorSpeed (CPhidgetMotorControlHandle, int Index, double);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_set_OnMotorChange_Handler (CPhidgetMotorControlHandle, int (__stdcall * fptr) (CPhidgetMotorControlHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getAcceleration (CPhidgetMotorControlHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_setAcceleration (CPhidgetMotorControlHandle, int Index, double);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getAccelerationMax (CPhidgetMotorControlHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getAccelerationMin (CPhidgetMotorControlHandle, int Index, double *);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getCurrent (CPhidgetMotorControlHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_set_OnCurrentChange_Handler (CPhidgetMotorControlHandle, int (__stdcall * fptr) (CPhidgetMotorControlHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getNumInputs (CPhidgetMotorControlHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_getInputState (CPhidgetMotorControlHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetMotorControl_set_OnInputChange_Handler (CPhidgetMotorControlHandle, int (__stdcall * fptr) (CPhidgetMotorControlHandle, void *, int, int), void *);

     typedef struct _CPhidgetPHSensor __CPhidgetPHSensor;
     typedef __CPhidgetPHSensor *CPhidgetPHSensorHandle;
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_create (CPhidgetPHSensorHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPH (CPhidgetPHSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPHMax (CPhidgetPHSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPHMin (CPhidgetPHSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_set_OnPHChange_Handler (CPhidgetPHSensorHandle, int (__stdcall * fptr) (CPhidgetPHSensorHandle, void *, double), void *);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPHChangeTrigger (CPhidgetPHSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_setPHChangeTrigger (CPhidgetPHSensorHandle, double);

__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPotential (CPhidgetPHSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPotentialMax (CPhidgetPHSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_getPotentialMin (CPhidgetPHSensorHandle, double *);

__declspec (dllimport)
     int __stdcall CPhidgetPHSensor_setTemperature (CPhidgetPHSensorHandle, double);

     typedef struct _CPhidgetRFID __CPhidgetRFID;
     typedef __CPhidgetRFID *CPhidgetRFIDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetRFID_create (CPhidgetRFIDHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetRFID_getNumOutputs (CPhidgetRFIDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_getOutputState (CPhidgetRFIDHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_setOutputState (CPhidgetRFIDHandle, int Index, int);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_set_OnOutputChange_Handler (CPhidgetRFIDHandle, int (__stdcall * fptr) (CPhidgetRFIDHandle, void *, int, int), void *);

__declspec (dllimport)
     int __stdcall CPhidgetRFID_getAntennaOn (CPhidgetRFIDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_setAntennaOn (CPhidgetRFIDHandle, int);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_getLEDOn (CPhidgetRFIDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_setLEDOn (CPhidgetRFIDHandle, int);

__declspec (dllimport)
     int __stdcall CPhidgetRFID_getLastTag (CPhidgetRFIDHandle, unsigned char *);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_getTagStatus (CPhidgetRFIDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_set_OnTag_Handler (CPhidgetRFIDHandle, int (__stdcall * fptr) (CPhidgetRFIDHandle, void *, unsigned char *), void *);
__declspec (dllimport)
     int __stdcall CPhidgetRFID_set_OnTagLost_Handler (CPhidgetRFIDHandle, int (__stdcall * fptr) (CPhidgetRFIDHandle, void *, unsigned char *), void *);

     typedef struct _CPhidgetServo __CPhidgetServo;
     typedef __CPhidgetServo *CPhidgetServoHandle;
__declspec (dllimport)
     int __stdcall CPhidgetServo_create (CPhidgetServoHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetServo_getNumMotors (CPhidgetServoHandle, int *);

__declspec (dllimport)
     int __stdcall CPhidgetServo_getMotorPosition (CPhidgetServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetServo_setMotorPosition (CPhidgetServoHandle, int Index, double);
__declspec (dllimport)
     int __stdcall CPhidgetServo_getMotorPositionMax (CPhidgetServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetServo_getMotorPositionMin (CPhidgetServoHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetServo_set_OnMotorPositionChange_Handler (CPhidgetServoHandle, int (__stdcall * fptr) (CPhidgetServoHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetServo_getMotorOn (CPhidgetServoHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetServo_setMotorOn (CPhidgetServoHandle, int Index, int);

     typedef struct _CPhidgetStepper __CPhidgetStepper;
     typedef __CPhidgetStepper *CPhidgetStepperHandle;
__declspec (dllimport)
     int __stdcall CPhidgetStepper_create (CPhidgetStepperHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getNumInputs (CPhidgetStepperHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getInputState (CPhidgetStepperHandle, int Index, int *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnInputChange_Handler (CPhidgetStepperHandle, int (__stdcall * fptr) (CPhidgetStepperHandle, void *, int, int), void *);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getNumMotors (CPhidgetStepperHandle, int *);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getAcceleration (CPhidgetStepperHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setAcceleration (CPhidgetStepperHandle, int Index, double);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getAccelerationMax (CPhidgetStepperHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getAccelerationMin (CPhidgetStepperHandle, int Index, double *);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMaxMotorSpeed (CPhidgetStepperHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setMaxMotorSpeed (CPhidgetStepperHandle, int Index, double);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMotorSpeed (CPhidgetStepperHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMotorSpeedMax (CPhidgetStepperHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMotorSpeedMin (CPhidgetStepperHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnSpeedChange_Handler (CPhidgetStepperHandle, int (__stdcall * fptr) (CPhidgetStepperHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMotorPosition (CPhidgetStepperHandle, int Index, long long *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_setMotorPosition (CPhidgetStepperHandle, int Index, long long);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMotorPositionMax (CPhidgetStepperHandle, int Index, long long *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_getMotorPositionMin (CPhidgetStepperHandle, int Index, long long *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnPositionChange_Handler (CPhidgetStepperHandle, int (__stdcall * fptr) (CPhidgetStepperHandle, void *, int, long long), void *);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_getCurrent (CPhidgetStepperHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetStepper_set_OnCurrentChange_Handler (CPhidgetStepperHandle, int (__stdcall * fptr) (CPhidgetStepperHandle, void *, int, double), void *);

__declspec (dllimport)
     int __stdcall CPhidgetStepper_setTorque (CPhidgetStepperHandle, int Index, double);

     typedef struct _CPhidgetTemperatureSensor __CPhidgetTemperatureSensor;
     typedef __CPhidgetTemperatureSensor *CPhidgetTemperatureSensorHandle;
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_create (CPhidgetTemperatureSensorHandle *);

     typedef enum
     {
      PHIDGET_TEMPERATURE_SENSOR_K_TYPE = 1,
      PHIDGET_TEMPERATURE_SENSOR_J_TYPE,
      PHIDGET_TEMPERATURE_SENSOR_E_TYPE,
      PHIDGET_TEMPERATURE_SENSOR_T_TYPE
     } CPhidgetTemperatureSensor_ThermocoupleType;

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getNumTemperatureInputs (CPhidgetTemperatureSensorHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperature (CPhidgetTemperatureSensorHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperatureMax (CPhidgetTemperatureSensorHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperatureMin (CPhidgetTemperatureSensorHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_set_OnTemperatureChange_Handler (CPhidgetTemperatureSensorHandle, int (__stdcall * fptr) (CPhidgetTemperatureSensorHandle, void *, int, double), void *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getTemperatureChangeTrigger (CPhidgetTemperatureSensorHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_setTemperatureChangeTrigger (CPhidgetTemperatureSensorHandle, int Index, double);

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getPotential (CPhidgetTemperatureSensorHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getPotentialMax (CPhidgetTemperatureSensorHandle, int Index, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getPotentialMin (CPhidgetTemperatureSensorHandle, int Index, double *);

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getAmbientTemperature (CPhidgetTemperatureSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getAmbientTemperatureMax (CPhidgetTemperatureSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getAmbientTemperatureMin (CPhidgetTemperatureSensorHandle, double *);

__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_getThermocoupleType (CPhidgetTemperatureSensorHandle, int Index, CPhidgetTemperatureSensor_ThermocoupleType *);
__declspec (dllimport)
     int __stdcall CPhidgetTemperatureSensor_setThermocoupleType (CPhidgetTemperatureSensorHandle, int Index, CPhidgetTemperatureSensor_ThermocoupleType);

     typedef struct _CPhidgetTextLCD __CPhidgetTextLCD;
     typedef __CPhidgetTextLCD *CPhidgetTextLCDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_create (CPhidgetTextLCDHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getNumRows (CPhidgetTextLCDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getNumColumns (CPhidgetTextLCDHandle, int *);

__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getBacklight (CPhidgetTextLCDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setBacklight (CPhidgetTextLCDHandle, int);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getContrast (CPhidgetTextLCDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setContrast (CPhidgetTextLCDHandle, int);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getCursorOn (CPhidgetTextLCDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setCursorOn (CPhidgetTextLCDHandle, int);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_getCursorBlink (CPhidgetTextLCDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setCursorBlink (CPhidgetTextLCDHandle, int);

__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setCustomCharacter (CPhidgetTextLCDHandle, int Index, int, int);
__declspec (dllimport)
     int __stdcall CPhidgetTextLCD_setDisplayString (CPhidgetTextLCDHandle, int Index, char *);

     typedef struct _CPhidgetTextLED __CPhidgetTextLED;
     typedef __CPhidgetTextLED *CPhidgetTextLEDHandle;
__declspec (dllimport)
     int __stdcall CPhidgetTextLED_create (CPhidgetTextLEDHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetTextLED_getNumRows (CPhidgetTextLEDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTextLED_getNumColumns (CPhidgetTextLEDHandle, int *);

__declspec (dllimport)
     int __stdcall CPhidgetTextLED_getBrightness (CPhidgetTextLEDHandle, int *);
__declspec (dllimport)
     int __stdcall CPhidgetTextLED_setBrightness (CPhidgetTextLEDHandle, int);

__declspec (dllimport)
     int __stdcall CPhidgetTextLED_setDisplayString (CPhidgetTextLEDHandle, int Index, char *);

     typedef struct _CPhidgetWeightSensor __CPhidgetWeightSensor;
     typedef __CPhidgetWeightSensor *CPhidgetWeightSensorHandle;
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_create (CPhidgetWeightSensorHandle *);

__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_getWeight (CPhidgetWeightSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_set_OnWeightChange_Handler (CPhidgetWeightSensorHandle, int (__stdcall * fptr) (CPhidgetWeightSensorHandle, void *, double), void *);
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_getWeightChangeTrigger (CPhidgetWeightSensorHandle, double *);
__declspec (dllimport)
     int __stdcall CPhidgetWeightSensor_setWeightChangeTrigger (CPhidgetWeightSensorHandle, double);
#ifndef CPHIDGET_CONSTANTS
#define CPHIDGET_CONSTANTS

/* states for the phidget / manager status variable */
//returned to outside world by getStatus()
#define PHIDGET_ATTACHED				0x1
#define PHIDGET_NOTATTACHED				0x0

/* Phidget Error Codes */
#define	PHIDGET_ERROR_CODE_COUNT		18
#define EPHIDGET_OK						0
#define EPHIDGET_NOTFOUND				1
#define EPHIDGET_NOMEMORY				2
#define EPHIDGET_UNEXPECTED				3
#define EPHIDGET_INVALIDARG				4
#define EPHIDGET_NOTATTACHED			5
#define EPHIDGET_INTERRUPTED			6
#define EPHIDGET_INVALID				7
#define EPHIDGET_NETWORK				8
#define EPHIDGET_UNKNOWNVAL				9
#define EPHIDGET_BADPASSWORD			10
#define EPHIDGET_UNSUPPORTED			11
#define EPHIDGET_DUPLICATE				12
#define EPHIDGET_TIMEOUT				13
#define EPHIDGET_OUTOFBOUNDS			14
#define EPHIDGET_EVENT					15
#define EPHIDGET_NETWORK_NOTCONNECTED	16
#define EPHIDGET_WRONGDEVICE			17

/* Returned for unknown values */
#define PUNK_BOOL	0x02 //(booleans only)
#define PUNK_INT	0x7FFFFFFF
#define PUNK_INT64	0x7FFFFFFFFFFFFFFFLL
#define PUNK_DBL	1e300
#define PUNK_FLT	1e30

#define PFALSE		0x00
#define PTRUE		0x01

#endif

#ifdef __cplusplus
}
#endif
