// RFIDTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "..\phidget21.h"

int __stdcall RFID_AttachHandler(CPhidgetHandle RFID, void *userptr)
{
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall RFID_DetachHandler(CPhidgetHandle RFID, void *userptr)
{
	printf("Detach handler ran!\n");
	return 0;
}

int __stdcall RFID_ErrorHandler(CPhidgetHandle RFID, void *userptr, int ErrorCode, const char *unknown)
{
	printf("Error handler ran!\n");
	return 0;
}

void display_generic_properties(CPhidgetHandle phid)
{
	int sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType((CPhidgetHandle)phid, &deviceptr);
	CPhidget_getSerialNumber((CPhidgetHandle)phid, &sernum);
	CPhidget_getDeviceVersion((CPhidgetHandle)phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

//This makes sure that the same tag is reported by all readers...
void fix_tag(CPhidgetRFIDHandle RFID, unsigned char *buf)
{
	int version;
	CPhidget_getDeviceVersion((CPhidgetHandle)RFID, &version);

	switch(version)
	{
		//All of these report the wrong tag - the real tag cannot be recovered
		//The top byte has been ORed with the top byte shifted left 
	case 202:
	case 203:
	case 204:
		break;
		//Convert the real tag that these report into the wrong tag that the 'bad' readers report
	default:
		{
			unsigned char byte1 = buf[0] & 0xf0;
			unsigned char byte2 = (buf[0] << 1) & 0xe0;
			//compute the partiy bit
			byte2 |= (((byte1 >> 3) ^ (byte1 >> 2) ^ (byte1 >> 1) ^ byte1) & 0x10);

			buf[0] = (buf[0] & 0x0f) | ((byte1 | byte2) & 0xf0);
		}
		break;
	}
}

int __stdcall RFID_Handler(CPhidgetRFIDHandle RFID, void *userptr, unsigned char *buf)
{
	//Tag is represented as a 10-digit hex number - array or 5 unsigned bytes
	//Here we tell printf to display two characters for each byte - ie 0x00 - 0xFF
	//the '0' in the '%02x' just makese it display any leading zeros.

	//fix_tag(RFID, buf);

	printf("Got:  %02x%02x%02x%02x%02x\n", buf[0], buf[1], buf[2], buf[3], buf[4]);

	return 0;
}

int __stdcall RFIDLost_Handler(CPhidgetRFIDHandle RFID, void *userptr, unsigned char *buf)
{
	printf("Lost: %02x%02x%02x%02x%02x\n", buf[0], buf[1], buf[2], buf[3], buf[4]);

	return 0;
}

int __stdcall RFID_OutputChange_Handler(CPhidgetRFIDHandle RFID, void *userptr, int index, int val)
{
	printf("Output %d changed to %d\n",index, val);
	return 0;
}

int test_rfid()
{
	int NumOutputs, result;
	const char *err;

	CPhidgetRFIDHandle RFID = 0;

	CPhidgetRFID_create(&RFID);

	CPhidget_set_OnAttach_Handler((CPhidgetHandle)RFID, RFID_AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)RFID, RFID_DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)RFID, RFID_ErrorHandler, NULL);
	CPhidgetRFID_set_OnTag_Handler(RFID, RFID_Handler, NULL);
	CPhidgetRFID_set_OnTagLost_Handler(RFID, RFIDLost_Handler, NULL);
	CPhidgetRFID_set_OnOutputChange_Handler(RFID, RFID_OutputChange_Handler, NULL);

	CPhidget_open((CPhidgetHandle)RFID, -1);

	//Wait for 10 seconds, otherwise exit
	if(result = CPhidget_waitForAttachment((CPhidgetHandle)RFID, 10000))
	{
		CPhidget_getErrorDescription(result, &err);
		printf("Problem waiting for attachment: %s\n", err);
		return 0;
	}

	display_generic_properties((CPhidgetHandle)RFID);

	CPhidgetRFID_setAntennaOn(RFID, true);
	CPhidgetRFID_setLEDOn(RFID, true);

	CPhidgetRFID_getNumOutputs(RFID, &NumOutputs);
	printf("Number of Digital Outputs = %d\n", NumOutputs);

	while(1)
		Sleep(1000);

	CPhidget_close((CPhidgetHandle)RFID);
	CPhidget_delete((CPhidgetHandle)RFID);
	return 0;
}

int main(int argc, char* argv[])
{
	test_rfid();
	return 0;
}

