// LEDTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "..\phidget21.h"

int __stdcall AttachHandler(CPhidgetHandle IFK, void *userptr)
{
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall DetachHandler(CPhidgetHandle IFK, void *userptr)
{
	printf("Detach handler ran!\n");
	return 0;
}

int __stdcall ErrorHandler(CPhidgetHandle IFK, void *userptr, int ErrorCode, const char *unknown)
{
	printf("Error handler ran!\n");
	return 0;
}

void display_generic_properties(CPhidgetHandle phid)
{
	int sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType(phid, &deviceptr);
	CPhidget_getSerialNumber(phid, &sernum);
	CPhidget_getDeviceVersion(phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

int test_led()
{
	int result, i;
	const char *err;

	CPhidgetLEDHandle led = 0;

	CPhidgetLED_create(&led);

	CPhidget_set_OnAttach_Handler((CPhidgetHandle)led, AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)led, DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)led, ErrorHandler, NULL);

	CPhidget_open((CPhidgetHandle)led, -1);

	//Wait for 10 seconds, otherwise exit
	if(result = CPhidget_waitForAttachment((CPhidgetHandle)led, 10000))
	{
		CPhidget_getErrorDescription(result, &err);
		printf("Problem waiting for attachment: %s\n", err);
		return 0;
	}

	display_generic_properties((CPhidgetHandle) led);

	for (i = 0; i<64; i++)
		if (result = CPhidgetLED_setDiscreteLED(led, i,i))
			printf("Error result is %d\n", result);

	CPhidget_close((CPhidgetHandle)led);
	CPhidget_delete((CPhidgetHandle)led);
	return 0;
}

int main(int argc, char* argv[])
{
	test_led();
	return 0;
}

