// - LED simple -
// This simple example creates a LED handle, hooks the event handlers, then opens and waits for a LED Phidget to be attached.
// Once on has been attaced it will cycle through  few leds and turn their brightness from 0 to 100 and then turn them off
// before terminating the program after user input.
// For a more detailed example, please see the LED-full example.
//
// Please note that this example was designed to work with only one Phidget LED connected. For an example using multiple Phidget LEDs
// please see a "multiple" example in the LED Examples folder.
//
// Copyright 2007 Phidgets Inc.  All rights reserved.


#include "stdafx.h"
#include "..\..\..\phidget21.h"

int __stdcall AttachHandler(CPhidgetHandle LED, void *userptr)
{
	int serialNo;
	const char *name;

	CPhidget_getDeviceName (LED, &name);
	CPhidget_getSerialNumber(LED, &serialNo);
	printf("%s %10d attached!\n", name, serialNo);

	return 0;
}

int __stdcall DetachHandler(CPhidgetHandle LED, void *userptr)
{
	int serialNo;
	const char *name;

	CPhidget_getDeviceName (LED, &name);
	CPhidget_getSerialNumber(LED, &serialNo);
	printf("%s %10d detached!\n", name, serialNo);

	return 0;
}

int __stdcall ErrorHandler(CPhidgetHandle LED, void *userptr, int ErrorCode, const char *unknown)
{
	printf("Error handled. %i - %S\n", ErrorCode, unknown);
	return 0;
}

//Display the properties of the attached phidget to the screen.  We will be displaying the name, serial number and version of the attached device.
//We will also display the total number of available LEDs
int display_properties(CPhidgetLEDHandle phid)
{
	int serialNo, version, numLED;
	const char* ptr;

	CPhidget_getDeviceType((CPhidgetHandle)phid, &ptr);
	CPhidget_getSerialNumber((CPhidgetHandle)phid, &serialNo);
	CPhidget_getDeviceVersion((CPhidgetHandle)phid, &version);
	CPhidgetLED_getNumLEDs(phid, &numLED);

	printf("%s\n", ptr);
	printf("Serial Number: %10d\nVersion: %8d\n", serialNo, version);
	printf("# LEDs: %d\n", numLED);

	return 0;
}

int LED_simple()
{
	int result, i;
	const char *err;

	//Declare an LED handle
	CPhidgetLEDHandle led = 0;

	//create the accelerometer object
	CPhidgetLED_create(&led);

	//Set the handlers to be run when the device is plugged in or opened from software, unplugged or closed from software, or generates an error.
	CPhidget_set_OnAttach_Handler((CPhidgetHandle)led, AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)led, DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)led, ErrorHandler, NULL);

	//open the LED for device connections
	CPhidget_open((CPhidgetHandle)led, -1);

	//get the program to wait for an LED device to be attached
	printf("Waiting for LED to be attached....");
	if(result = CPhidget_waitForAttachment((CPhidgetHandle)led, 10000))
	{
		CPhidget_getErrorDescription(result, &err);
		printf("Problem waiting for attachment: %s\n", err);
		return 0;
	}

	//Display the properties of the attached accelerometer device
	display_properties(led);

	//read led event data
	printf("Reading.....\n");

	//keep displaying LED event data until user input is read
	printf("Press any key to continue\n");
	getchar();

	//turn on the leds one at a time.
	//This example assumes LED's plugged into locations 0-9
	for(i = 0; i < 10; i++)
	{
		CPhidgetLED_setDiscreteLED(led, i, 100); //maximum brightness is 100, 0 is off.  Can set this value to anything including and inbetween these values.
	}

	//keep displaying LED event data until user input is read
	printf("Press any key to continue\n");
	getchar();

	//turn off the LEDs one at a a time
	//This example assumes LED's plugged into locations 0-9
	for(i = 0; i < 10; i++)
	{
		CPhidgetLED_setDiscreteLED(led, i, 0); //maximum brightness is 100, 0 is off.  Can set this value to anything including and inbetween these values.
	}

	printf("Press any key to end\n");
	getchar();

	//since user input has been read, this is a signal to terminate the program so we will close the phidget and delete the object we created
	printf("Closing...\n");
	CPhidget_close((CPhidgetHandle)led);
	CPhidget_delete((CPhidgetHandle)led);

	//all done, exit
	return 0;
}

int _tmain(int argc, _TCHAR* argv[])
{
	LED_simple();
	return 0;
}

