function getSensorValues(block)
% Level-2 M file S-Function demonstrating getSensorValue
  setup(block);
  
%endfunction

function setup(block)

  %% Register number of input and output ports
  block.NumInputPorts  = 0;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompOutPortInfoToDynamic;
 
  
  block.OutputPort(1).Dimensions = 8;  %needs to reflect the number of analog sensors on the board
    
  %since there are no inputs to this block, sampling mode needs to
  %explicitly change from inherited to sample
  block.OutputPort(1).SamplingMode = 'sample'; 
      
  %% Set block sample time to inherited sample time
  block.SampleTimes = [-1 0]; 
      
  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions); 
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
  
%endfunction

function DoPostPropSetup(block)

  % Setup Dwork
  block.NumDworks = 1;
  block.Dwork(1).Name = 'sensorValues'; 
  block.Dwork(1).Dimensions      = 8;
  block.Dwork(1).DatatypeID      = 0;
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

%endfunction

function InitConditions(block)
     for i = 0:7
             % Initialize Dwork
             block.Dwork(1).Data(i+1) = 0;
     end    
%endfunction

function Output(block)

  dataptr = libpointer('int32Ptr',0);
    global handle;

    for i = 0:7
        if (calllib('phidget21', 'CPhidgetInterfaceKit_getSensorValue', handle, i, dataptr) == 0)
  
            block.OutputPort(1).Data(i+1) = block.Dwork(1).Data(i+1);
        end
    end

  
%endfunction

function Update(block)
 dataptr = libpointer('int32Ptr',0);
    global handle;
    
    for i = 0:7
        if (calllib('phidget21', 'CPhidgetInterfaceKit_getSensorValue', handle, i, dataptr) == 0)
             % updating Dwork
             block.Dwork(1).Data(i+1) = get(dataptr, 'Value');  
         end
    end
  
%endfunction

