function analogin(n)
%analogin.h - polls interface kit for analog data on given sensor number

loadlibrary phidget21 phidget21Matlab.h;

ptr = libpointer('int32Ptr',0);

calllib('phidget21', 'CPhidgetInterfaceKit_create', ptr);

handle = get(ptr, 'Value');

calllib('phidget21', 'CPhidget_open', handle, -1);

if calllib('phidget21', 'CPhidget_waitForAttachment', handle, 2500) == 0
    disp('Opened InterfaceKit')

    % setup a timer to delay the reads 0.3 seconds
    t = timer('TimerFcn','disp(''Getting data...'')', 'StartDelay', 0.3);
    n=0;

    % try to get some data from sensor 0
    while n<10
        start(t);
        wait(t);
        dataptr = libpointer('int32Ptr',0);
        %get the value, make sure it's valid
        if calllib('phidget21', 'CPhidgetInterfaceKit_getSensorValue', handle, 0, dataptr) == 0
            disp(get(dataptr, 'Value'));
        end
        n=n+1;
    end

else
    disp('Could not open InterfaceKit')
end

% clean up
calllib('phidget21', 'CPhidget_close', handle);
calllib('phidget21', 'CPhidget_delete', handle);

%unloading the library too quickly causes issues.
%unloadlibrary phidget21;

