package
{

	import com.phidgets.*;
	import com.phidgets.events.*;
	
	import flash.display.Sprite;
		
	public class PhidgetMotorControlTest extends Sprite {
		
		private var phid:PhidgetMotorControl;
		
		public function PhidgetMotorControlTest() {
			
			phid = new PhidgetMotorControl();
			
			phid.addEventListener(PhidgetEvent.CONNECT,	onConnect);
			phid.addEventListener(PhidgetEvent.DISCONNECT, onDisconnect);
			phid.addEventListener(PhidgetEvent.DETACH,	onDetach);
			phid.addEventListener(PhidgetEvent.ATTACH,	onAttach);
			phid.addEventListener(PhidgetErrorEvent.ERROR, onError);
			phid.addEventListener(PhidgetDataEvent.INPUT_CHANGE, onInputChange);
			phid.addEventListener(PhidgetDataEvent.VELOCITY_CHANGE, onVelocityChange);
			phid.addEventListener(PhidgetDataEvent.CURRENT_CHANGE, onCurrentChange);
			phid.addEventListener(PhidgetDataEvent.CURRENT_UPDATE, onCurrentUpdate);
			phid.addEventListener(PhidgetDataEvent.POSITION_CHANGE, onPositionChange);
			phid.addEventListener(PhidgetDataEvent.POSITION_UPDATE, onPositionUpdate);
			phid.addEventListener(PhidgetDataEvent.SENSOR_UPDATE, onSensorUpdate);
			phid.addEventListener(PhidgetDataEvent.BACKEMF_UPDATE, onBackemfUpdate);
			
			phid.open("localhost", 5001);
		}
		
		private function onError(evt:PhidgetErrorEvent):void {
			trace(evt);
		}
		private function onAttach(evt:PhidgetEvent):void{
			trace(evt);
			phid.setAcceleration(0,1);
			phid.setVelocity(0,25);
			phid.setBackEMFSensingState(0, true);
		}
		private function onDetach(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onConnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onDisconnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onInputChange(evt:PhidgetDataEvent):void{
			trace(evt);
		}
		private function onVelocityChange(evt:PhidgetDataEvent):void{
			trace(evt);
		}
		private function onCurrentChange(evt:PhidgetDataEvent):void{
			trace(evt);
		}
		private function onCurrentUpdate(evt:PhidgetDataEvent):void{
			//trace(evt);
		}
		private function onPositionChange(evt:PhidgetDataEvent):void{
			trace(evt);
			trace("Position: "+PhidgetMotorControl(evt.Device).getEncoderPosition(0).toString());
		}
		private function onPositionUpdate(evt:PhidgetDataEvent):void{
			//trace(evt);
		}
		private function onSensorUpdate(evt:PhidgetDataEvent):void{
			//trace(evt);
		}
		private function onBackemfUpdate(evt:PhidgetDataEvent):void{
			//trace(evt);
		}
	}
}