package
{
	import com.phidgets.*;
	import com.phidgets.events.*;
	
	import flash.events.TimerEvent;
    import flash.utils.Timer;
	import flash.display.Sprite;
		
	public class PhidgetIRTest extends Sprite {
		
		private var phid:PhidgetIR;
		
		public function PhidgetIRTest() {
			
			phid = new PhidgetIR();
			
			phid.addEventListener(PhidgetEvent.CONNECT,	onConnect);
			phid.addEventListener(PhidgetEvent.DISCONNECT, onDisconnect);
			phid.addEventListener(PhidgetEvent.DETACH,	onDetach);
			phid.addEventListener(PhidgetEvent.ATTACH,	onAttach);
			phid.addEventListener(PhidgetErrorEvent.ERROR, onError);
			phid.addEventListener(PhidgetDataEvent.CODE, onCode);
			phid.addEventListener(PhidgetDataEvent.LEARN, onLearn);
			phid.addEventListener(PhidgetDataEvent.RAW_DATA, onRawData);
			
			phid.open("localhost", 5001);
		}
		
		private function onError(evt:PhidgetErrorEvent):void {
			trace(evt);
		}
		private function onAttach(evt:PhidgetEvent):void{
			trace(evt);
			//Transmit a Raw Packet of data
			var data:Array = [
               9040,   4590,    540,    630,    550,   1740,    550,   1750,    550,   1740,
                550,    620,    550,   1750,    550,   1740,    550,   1750,    550,   1740,
                550,   1740,    560,   1740,    540,    630,    550,    620,    550,    620,
                540,    630,    550,   1750,    550,   1740,    560,   1740,    550,    620,
                550,   1740,    550,    620,    550,    620,    560,    610,    550,    620,
                550,   1750,    550,   1740,    550,    620,    550,   1740,    550,   1750,
                550,    620,    550,    620,    550,    620,    540];
            phid.transmitRaw(data,38000);
		}
		private function onDetach(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onConnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onDisconnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onCode(evt:PhidgetDataEvent):void{
			var code:PhidgetIRCode = (PhidgetIRCode)(evt.Data);
			trace("Code Event: " + code.Code + " ("+code.BitCount.toString()+"-bit)" + (code.Repeat?" repeat":""));
		}
		private function onLearn(evt:PhidgetDataEvent):void{
			var learnedCode:PhidgetIRLearnedCode = (PhidgetIRLearnedCode)(evt.Data);
			trace("Learn Event: " + learnedCode.Code + " ("+learnedCode.CodeInfo.BitCount.toString()+"-bit)");
			
			//re-transmit what we learned
			phid.transmit(learnedCode.Code, learnedCode.CodeInfo);        

			//and send out the repeat code for 1 second (simulates holding the button down)
            // 1 second at 50ms intervals
            var minuteTimer:Timer = new Timer(50, 20);
            minuteTimer.addEventListener(TimerEvent.TIMER, onTick);
            minuteTimer.start();
		}
        public function onTick(evt:TimerEvent):void 
        {
            phid.transmitRepeat();
        }
		private function onRawData(evt:PhidgetDataEvent):void{
			//trace(evt);
			
			//Reading raw data manually:
			//var data:Array = new Array(16);
			//var length:int = phid.readRaw(data);
			//trace(length.toString() + " - "+data.toString());
		}
	}
}