package
{
	import com.phidgets.*;
	import com.phidgets.events.*;
	
	import flash.display.Sprite;
		
	public class PhidgetFrequencyCounterTest extends Sprite {
		
		private var phid:PhidgetFrequencyCounter;
		
		public function PhidgetFrequencyCounterTest() {
			
			phid = new PhidgetFrequencyCounter();
			
			phid.addEventListener(PhidgetEvent.CONNECT,	onConnect);
			phid.addEventListener(PhidgetEvent.DISCONNECT, onDisconnect);
			phid.addEventListener(PhidgetEvent.DETACH,	onDetach);
			phid.addEventListener(PhidgetEvent.ATTACH,	onAttach);
			phid.addEventListener(PhidgetErrorEvent.ERROR, onError);
			phid.addEventListener(PhidgetDataEvent.COUNT, onCount);
			
			phid.open("localhost", 5001);
		}
		
		private function onError(evt:PhidgetErrorEvent):void {
			trace(evt);
		}
		private function onAttach(evt:PhidgetEvent):void{
			trace(evt);
			phid.setEnabled(0, true);
			phid.setFilter(0, PhidgetFrequencyCounter.PHIDGET_FREQUENCYCOUNTER_FILTERTYPE_LOGIC_LEVEL);
			phid.setTimeout(0, 2000000); //2 seconds
		}
		private function onDetach(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onConnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onDisconnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onCount(evt:PhidgetDataEvent):void{
			trace(evt);
			trace(" Frequency: "+phid.getFrequency(0)+"Hz");
			trace(" Total Counts: "+phid.getTotalCount(0)+", Time: "+phid.getTotalTime(0));
		}
	}
}