﻿package
{
	import com.phidgets.*;
	import com.phidgets.events.*;
	
	import flash.display.Sprite;
		
	public class PhidgetTextLCDTest extends Sprite {
		
		private var phid:PhidgetTextLCD;
		
		public function PhidgetTextLCDTest() {
			
			phid = new PhidgetTextLCD();
			
			phid.addEventListener(PhidgetEvent.CONNECT,	onConnect);
			phid.addEventListener(PhidgetEvent.DISCONNECT, onDisconnect);
			phid.addEventListener(PhidgetEvent.DETACH,	onDetach);
			phid.addEventListener(PhidgetEvent.ATTACH,	onAttach);
			phid.addEventListener(PhidgetErrorEvent.ERROR, onError);
			
			phid.open("localhost", 5001);
		}
		
		private function onError(evt:PhidgetErrorEvent):void {
			trace(evt);
		}
		private function onAttach(evt:PhidgetEvent):void{
			trace(evt);
			
			if(phid.Name == "Phidget TextLCD Adapter")
			{
				phid.ScreenSize = PhidgetTextLCD.PHIDGET_TEXTLCD_SCREEN_4x40;
				phid.Contrast = 20;
			}
			
			phid.setDisplayString(0, "HI There");
			phid.setCustomCharacter(0x8, 0, 0xF8000);
			phid.setCustomCharacter(0x9, 0, 0xFFC00);
			phid.setCustomCharacter(0xa, 0, 0xFFFE0);
			phid.setCustomCharacter(0xb, 0, 0xFFFFF);
			phid.setCustomCharacter(0xc, 0xF8000, 0xFFFFF);
			phid.setCustomCharacter(0xd, 0xFFC00, 0xFFFFF);
			phid.setCustomCharacter(0xe, 0xFFFE0, 0xFFFFF);
			phid.setCustomCharacter(0xf, 0xFFFFF, 0xFFFFF);
			phid.setDisplayString(1, "Custom: "+String.fromCharCode(0x8,0x9,0xa,0xb,0xc,0xd,0xe,0xf));
			
			phid.setDisplayCharacter(0, 15, "!");
			phid.setDisplayCharacter(1, 18, "@");
			
			phid.Backlight = true;
			phid.CursorBlink = true;
			phid.Cursor = true;
		}
		private function onDetach(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onConnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onDisconnect(evt:PhidgetEvent):void{
			trace(evt);
		}

	}
}