package
{
	import com.phidgets.*;
	import com.phidgets.events.*;
	
	import flash.display.Sprite;
		
	public class PhidgetSpatialTest extends Sprite {
		
		private var phid:PhidgetSpatial;
		
		public function PhidgetSpatialTest() {
			
			phid = new PhidgetSpatial();
			
			phid.addEventListener(PhidgetEvent.CONNECT,	onConnect);
			phid.addEventListener(PhidgetEvent.DISCONNECT, onDisconnect);
			phid.addEventListener(PhidgetEvent.DETACH,	onDetach);
			phid.addEventListener(PhidgetEvent.ATTACH,	onAttach);
			phid.addEventListener(PhidgetErrorEvent.ERROR, onError);
			phid.addEventListener(PhidgetDataEvent.SPATIAL_DATA, onSpatialData);
			
			phid.open("localhost", 5001);
		}
		
		private function onError(evt:PhidgetErrorEvent):void {
			trace(evt);
		}
		private function onAttach(evt:PhidgetEvent):void{
			trace(evt);
			phid.DataRate = 32; //slow down the data rate
		}
		private function onDetach(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onConnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onDisconnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onSpatialData(evt:PhidgetDataEvent):void{
			trace(evt);
			//How to access the spatial data:
			var sData:PhidgetSpatialEventData = evt.Data as PhidgetSpatialEventData;
			trace("Accel 0: " + sData.Acceleration[0]);
		}
	}
}