package
{
	import com.phidgets.*;
	import com.phidgets.events.*;
	
	import flash.display.Sprite;
		
	public class PhidgetTemperatureSensorTest extends Sprite {
		
		private var phid:PhidgetTemperatureSensor;
		
		public function PhidgetTemperatureSensorTest() {
			
			phid = new PhidgetTemperatureSensor();
			
			phid.addEventListener(PhidgetEvent.CONNECT,	onConnect);
			phid.addEventListener(PhidgetEvent.DISCONNECT, onDisconnect);
			phid.addEventListener(PhidgetEvent.DETACH,	onDetach);
			phid.addEventListener(PhidgetEvent.ATTACH,	onAttach);
			phid.addEventListener(PhidgetErrorEvent.ERROR, onError);
			phid.addEventListener(PhidgetDataEvent.TEMPERATURE_CHANGE, onTemperatureChange);
			
			phid.open("localhost", 5001);
		}
		
		private function onError(evt:PhidgetErrorEvent):void {
			trace(evt);
		}
		private function onAttach(evt:PhidgetEvent):void{
			trace(evt);
			phid.setTemperatureChangeTrigger(0,0.01);
		}
		private function onDetach(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onConnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onDisconnect(evt:PhidgetEvent):void{
			trace(evt);
		}
		private function onTemperatureChange(evt:PhidgetDataEvent):void{
			trace(evt);
			trace("Ambient: "+phid.AmbientTemperature.toString());
		}
	}
}