package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	import flash.accessibility.Accessibility;

	
	/*
		Class: PhidgetIR
		A class for controlling a PhidgetIR.
		See your product manual for more specific API details, supported functionality, units, etc.
		
		Topic: Events
		Events supported by PhidgetIR. Pass these constants to the addEventListener() function when adding event listeners to a Phidget object.
		
		PhidgetDataEvent.CODE		- code
		PhidgetDataEvent.RAW_DATA	- raw data
		PhidgetDataEvent.LEARN		- learned code
	*/
	public class PhidgetIR extends Phidget
	{
		internal static const IR_DATA_ARRAY_SIZE:int = 2048;
		internal static const IR_DATA_ARRAY_MASK:int = 0x7ff;
	
		private var rawData:Array;
		private var dataWritePtr:int;
		private var userReadPtr:int;

		private var lastCode:PhidgetIRCode;
		private var lastLearnedCode:PhidgetIRLearnedCode;
		
		public function PhidgetIR(){
			super("PhidgetIR");
		}
		
		override protected function initVars():void{
			rawData = new Array(IR_DATA_ARRAY_SIZE);
			dataWritePtr = 0;
			userReadPtr = 0;
			lastCode = null;
			lastLearnedCode = null;
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "Code":
					var data:Array = value.split(',');
					var code:PhidgetIRCode = new PhidgetIRCode(data[0], data[1], data[2]=="0"?false:true);
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.CODE,this,code));
					lastCode = code;
					break;
				case "Learn":
					var learnedCode:PhidgetIRLearnedCode = PhidgetIRLearnedCode.stringToPhidgetIRLearnedCode(value);
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.LEARN,this,learnedCode));
					lastLearnedCode = learnedCode;
					break;
				case "RawData":
					break;
			}
		}
		
		//Getters
		/*
			Property: LastCode
			Gets the last code received.
		*/
		public function get LastCode():PhidgetIRCode{
			if(lastCode == null)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return lastCode;
		}
		/*
			Property: LastLearnedCode
			Gets the last code received.
		*/
		public function get LastLearnedCode():PhidgetIRLearnedCode{
			if(lastLearnedCode == null)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return lastLearnedCode;
		}
		
		//Functions
		/*
			Function: readRaw
			Read raw IR data. Read data always starts with a space and ends with a pulse.
			
			parameters:
				buffer - an array to read data into
				offset - offset in array to start writing data
				count - maximum ammount of data to read
				
			Returns:
				The ammount of data actually read.
		*/
		public function readRaw(buffer:Array, offset:int, count:int):int
		{
			return count;
		}
	}
}