﻿package com.phidgets.events
{
	import com.phidgets.Phidget;
	import com.phidgets.PhidgetError;
	import com.phidgets.Constants;
	import flash.events.Event;
	import flash.accessibility.Accessibility;
	
	public class PhidgetDataEvent extends PhidgetEvent
	{
		//Multiple
		public static const INPUT_CHANGE	:String = "inputChange";
		public static const OUTPUT_CHANGE	:String = "outputChange";
		public static const POSITION_CHANGE	:String = "positionChange";
		//Accelerometer
		public static const ACCELERATION_CHANGE	:String = "accelearaionChange";
		//Encoder
		//public static const POSITION_CHANGE	:String = "positionChange";
		//public static const INPUT_CHANGE	:String = "inputChange";
		//InterfaceKit
		public static const SENSOR_CHANGE	:String = "sensorChange";
		//public static const INPUT_CHANGE	:String = "inputChange";
		//public static const OUTPUT_CHANGE	:String = "outputChange";
		//LED
		//MotorControl
		public static const CURRENT_CHANGE 	:String = "currentChange";
		public static const VELOCITY_CHANGE	:String = "velocityChange";
		//public static const INPUT_CHANGE	:String = "inputChange";
		//PHSensor
		public static const PH_CHANGE		:String = "phChange";
		//RFID
		public static const TAG				:String	= "tag";
		public static const TAG_LOST		:String	= "tagLost";
		//Servo
		//public static const POSITION_CHANGE	:String = "positionChange";
		//TemperatureSensor
		public static const TEMPERATURE_CHANGE	:String = "temperatureChange";
		//TextLCD
		//TextLED
		//WeightSensor
		public static const WEIGHT_CHANGE	:String = "weightChange";
		
		private var _data:Object;
		private var _index:int = -1;
		
		public function PhidgetDataEvent (type:String,phidget:Phidget,data:Object,index:int=-1) {
			super(type, phidget);
			_data = data;
			_index = index;
		}
		
		override public function toString():String{
			if(_index == -1)
				return "[ Phidget Data Event: "+type+" to "+_data+" ]";
			else
				return "[ Phidget Data Event: "+type+" "+_index+" to "+_data+" ]";
		}
		
		public function get Index():int{ 
			if(_index == -1)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNSUPPORTED);
			return _index;
		}
		public function get Data():Object{ 
			return _data;
		}
	}
}