package com.phidgets
{
	import com.phidgets.events.PhidgetDataEvent;
	
	public class PhidgetWeightSensor extends Phidget
	{
		private var weight:Number = com.phidgets.Constants.PUNK_NUM;
		private var weightTrigger:Number = com.phidgets.Constants.PUNK_NUM;
		
		public function PhidgetWeightSensor(){
			super("PhidgetWeightSensor");
		}
		
		override protected function onSpecificPhidgetDetach():void{
			weight = com.phidgets.Constants.PUNK_NUM;
			weightTrigger = com.phidgets.Constants.PUNK_NUM;
		}
		
		override protected function onSpecificPhidgetData(setThing:String, index:int, value:String):void{
			switch(setThing)
			{
				case "Weight":
					weight = Number(value);
					if(isAttached)
						dispatchEvent(new PhidgetDataEvent(PhidgetDataEvent.WEIGHT_CHANGE,this,weight));
					break;
				case "Trigger":
					weightTrigger = Number(value);
					break;
			}
		}
		
		//Getters
		public function get Weight():Number{
			if(weight == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return weight;
		}
		public function get WeightChangeTrigger():Number{
			if(weightTrigger == com.phidgets.Constants.PUNK_NUM)
				throw new PhidgetError(com.phidgets.Constants.EPHIDGET_UNKNOWNVAL);
			return weightTrigger;
		}
		
		//Setters
		public function set WeightChangeTrigger(val:Number):void{ 
			_phidgetSocket.setKey(makeKey("Trigger"), val.toString(), true);
		}
	}
}